package com.cku.oa.contest.web;

import com.cku.oa.contest.entity.ContestExhibit;
import com.cku.oa.contest.service.ContestExhibitService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 犬展犬只Controller
 *
 * @author yuanshuai
 * @version 2020-09-30
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestExhibit")
public class ContestExhibitController extends BaseController {

	@Autowired
	private ContestExhibitService contestExhibitService;

	@ModelAttribute
	public ContestExhibit get(@RequestParam(required = false) String id) {
		ContestExhibit entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = contestExhibitService.get(id);
		}
		if (entity == null) {
			entity = new ContestExhibit();
		}
		return entity;
	}

	@RequiresPermissions("contest:contestExhibit:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestExhibit contestExhibit, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestExhibit> page = contestExhibitService.findPage(new Page<>(request, response), contestExhibit);
		model.addAttribute("page", page);
		return "oa/contest/contestExhibitList";
	}

	@RequiresPermissions("contest:contestExhibit:view")
	@RequestMapping(value = "form")
	public String form(ContestExhibit contestExhibit, Model model) {
		model.addAttribute("contestExhibit", contestExhibit);
		return "oa/contest/contestExhibitForm";
	}

	@RequiresPermissions("contest:contestExhibit:edit")
	@RequestMapping(value = "save")
	public String save(ContestExhibit contestExhibit, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestExhibit)) {
			return form(contestExhibit, model);
		}
		contestExhibitService.save(contestExhibit);
		addMessage(redirectAttributes, "保存犬展犬只成功");
		return "redirect:" + Global.getAdminPath() + "/contest/contestExhibit/?repage";
	}

	@RequiresPermissions("contest:contestExhibit:del")
	@RequestMapping(value = "delete")
	public String delete(ContestExhibit contestExhibit, RedirectAttributes redirectAttributes) {
		contestExhibitService.delete(contestExhibit);
		addMessage(redirectAttributes, "删除犬展犬只成功");
		return "redirect:" + Global.getAdminPath() + "/contest/contestExhibit/?repage";
	}

	/**
	 * @Description： 导入犬展犬只
	 * @author: yuanshuai
	 * @date: 2020/09/30 15:36
	 */
	@RequiresPermissions("contest:contestExhibit:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			int count = contestExhibitService.importContestDog(file);
			addMessage(redirectAttributes, "导入犬展犬只成功，共导入" + count + "条记录。");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入犬展犬只失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/contest/contestExhibit/?repage";
	}

	/**
	 * 下载导入赛事信息模板
	 *
	 * @param response
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("statistics:memberVip:view")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		List<ContestExhibit> list;
		try {
			list = contestExhibitService.importFileTemplate();
			new ExportExcel("犬展活动区域犬只导入模板", ContestExhibit.class, 2).setDataList(list).write(response, "犬展活动区域犬只导入模板.xlsx").dispose();
			return null;
		} catch (Exception e) {
			e.printStackTrace();
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/contest/contestExhibit/?repage";
		}
	}

}