/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场犬只部位评价Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestCritic extends DataEntity<ContestCritic> {
	
	private static final long serialVersionUID = 1L;
	private String contestCriticNo;		// 编号
	private String name;		// 名称
	private String languageNo;		// 语言
	
	public ContestCritic() {
		super();
	}

	public ContestCritic(String id){
		super(id);
	}

	@Length(min=1, max=11, message="编号长度必须介于 1 和 11 之间")
	public String getContestCriticNo() {
		return contestCriticNo;
	}

	public void setContestCriticNo(String contestCriticNo) {
		this.contestCriticNo = contestCriticNo;
	}
	
	@Length(min=1, max=255, message="名称长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=11, message="语言长度必须介于 1 和 11 之间")
	public String getLanguageNo() {
		return languageNo;
	}

	public void setLanguageNo(String languageNo) {
		this.languageNo = languageNo;
	}
	
}