package com.cku.oa.buying.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * Created by user on 2016/12/10.
 */
public class Buying extends DataEntity<Buying> {
    private static final long serialVersionUID = 1L;
    private String memberCode;		// 会员号
    private String memberName;		// 会员名称
    private String runningNumber;		// 订单编号
    private String paymentState;		// 支付状态
    private Date paymentTime;		// 支付时间
    private String paymentWay;	//支付方式

    @Length(min=0, max=64, message="会员号长度必须介于 0 和 64 之间")
    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    @Length(min=0, max=100, message="会员名称长度必须介于 0 和 100 之间")
    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }
    @Length(min=1, max=100, message="订单编号长度必须介于 1 和 100 之间")
    public String getRunningNumber() {
        return runningNumber;
    }

    public void setRunningNumber(String runningNumber) {
        this.runningNumber = runningNumber;
    }
    @Length(min=0, max=10, message="支付方式长度必须介于 0 和 10之间")
    public String getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(String paymentWay) {
        this.paymentWay = paymentWay;
    }

    @Length(min=0, max=2, message="支付状态长度必须介于 0 和 2 之间")
    public String getPaymentState() {
        return paymentState;
    }

    public void setPaymentState(String paymentState) {
        this.paymentState = paymentState;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }
}
