/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.activity.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 会员续费参与活动记录Entity
 * 
 * @author Sunny
 * @version 2019-12-05
 */
public class SysMemberActivityRecord extends DataEntity<SysMemberActivityRecord> {

	private static final long serialVersionUID = 1L;
	private String memeberCode; // 会员号
	private String memeberName; // 会员姓名
	private String kennelCode; // 犬舍编号
	private String kennelName; // 犬舍名称
	private String memberType; // 原会员类型 professional：专业 basic：基础
	private String newMemberType; // 新会员类型 professional：专业 basic：基础
	private String groomerType; // 美容师类型 formal:正式会员 reserve:预备会员
	private Date memberEndDate; // 原会员到期时间
	private Date kennelEndDate; // 原犬舍到期时间
	private Date groomerEndDate; // 原年美容师到期时间
	private String activityType; // 参与活动类型：1:新会员注册，2:基础会员升级，3:有犬舍的专业会员续费，4:无犬舍的专业会员续费，5:美容续费，6:分享拉取新会员
	private String preferentialWay; // 优惠方式：1:赠送时间，2:返券，3:减免金额
	private String preferentialAmount; // 优惠金额
	private String couponAmount; // 优惠券金额
	private String giveMonth; // 赠送月份：
	private String giveGift; // 赠送礼包 0 未赠送，1 赠送：
	private Date newMemberEndDate; // 参与活动后专业会员到期时间
	private Date newKennelEndDate; // 参与活动后年度犬舍到期时间
	private Date newGroomerEndDate; // 参与活动后年美容师到期时间：
	private Date participationTime; // 参与时间
	private String referee; // 推荐人
	private String recordType; // 记录创建类型: 1 手动创建, 2 系统自动创建
	private String orderCode; // 订单编号

	private Date paymentTime; // 支付时间
	private String totalPrice;
	
	private String memberCardType;
	
	private String newMemberCardType;
	
	private String kennelType;
	
	private String newKennelType;
	
	private String newGroomerType;
	

	private String originalMemberCode;
	
	public String getOriginalMemberCode() {
		return originalMemberCode;
	}

	public void setOriginalMemberCode(String originalMemberCode) {
		this.originalMemberCode = originalMemberCode;
	}

	public String getNewGroomerType() {
		return newGroomerType;
	}

	public void setNewGroomerType(String newGroomerType) {
		this.newGroomerType = newGroomerType;
	}

	public String getMemberCardType() {
		return memberCardType;
	}

	public void setMemberCardType(String memberCardType) {
		this.memberCardType = memberCardType;
	}

	public String getNewMemberCardType() {
		return newMemberCardType;
	}

	public void setNewMemberCardType(String newMemberCardType) {
		this.newMemberCardType = newMemberCardType;
	}

	public String getKennelType() {
		return kennelType;
	}

	public void setKennelType(String kennelType) {
		this.kennelType = kennelType;
	}

	public String getNewKennelType() {
		return newKennelType;
	}

	public void setNewKennelType(String newKennelType) {
		this.newKennelType = newKennelType;
	}

	public String getCouponAmount() {
		return couponAmount;
	}

	public void setCouponAmount(String couponAmount) {
		this.couponAmount = couponAmount;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public SysMemberActivityRecord() {
		super();
	}

	public SysMemberActivityRecord(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemeberCode() {
		return memeberCode;
	}

	public void setMemeberCode(String memeberCode) {
		this.memeberCode = memeberCode;
	}

	@Length(min = 0, max = 64, message = "会员姓名长度必须介于 0 和 64 之间")
	public String getMemeberName() {
		return memeberName;
	}

	public void setMemeberName(String memeberName) {
		this.memeberName = memeberName;
	}

	@Length(min = 0, max = 64, message = "犬舍编号长度必须介于 0 和 64 之间")
	public String getKennelCode() {
		return kennelCode;
	}

	public void setKennelCode(String kennelCode) {
		this.kennelCode = kennelCode;
	}

	@Length(min = 0, max = 64, message = "犬舍名称长度必须介于 0 和 64 之间")
	public String getKennelName() {
		return kennelName;
	}

	public void setKennelName(String kennelName) {
		this.kennelName = kennelName;
	}

	@Length(min = 0, max = 64, message = "原会员类型 professional：专业 basic：基础长度必须介于 0 和 64 之间")
	public String getMemberType() {
		return memberType;
	}

	public void setMemberType(String memberType) {
		this.memberType = memberType;
	}

	@Length(min = 0, max = 50, message = "美容师类型 formal:正式会员 reserve:预备会员长度必须介于 0 和 50 之间")
	public String getGroomerType() {
		return groomerType;
	}

	public void setGroomerType(String groomerType) {
		this.groomerType = groomerType;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getMemberEndDate() {
		return memberEndDate;
	}

	public void setMemberEndDate(Date memberEndDate) {
		this.memberEndDate = memberEndDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getKennelEndDate() {
		return kennelEndDate;
	}

	public void setKennelEndDate(Date kennelEndDate) {
		this.kennelEndDate = kennelEndDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getGroomerEndDate() {
		return groomerEndDate;
	}

	public void setGroomerEndDate(Date groomerEndDate) {
		this.groomerEndDate = groomerEndDate;
	}

	@Length(min = 0, max = 1, message = "参与活动类型：1:新会员注册，2:基础会员升级，3:有犬舍的专业会员续费，4:无犬舍的专业会员续费，5:美容续费，6:分享拉取新会员长度必须介于 0 和 1 之间")
	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	@Length(min = 0, max = 1, message = "优惠方式：1:赠送时间，2:返券，3:减免金额长度必须介于 0 和 1 之间")
	public String getPreferentialWay() {
		return preferentialWay;
	}

	public void setPreferentialWay(String preferentialWay) {
		this.preferentialWay = preferentialWay;
	}

	public String getPreferentialAmount() {
		return preferentialAmount;
	}

	public void setPreferentialAmount(String preferentialAmount) {
		this.preferentialAmount = preferentialAmount;
	}

	@Length(min = 0, max = 11, message = "赠送月份：长度必须介于 0 和 11 之间")
	public String getGiveMonth() {
		return giveMonth;
	}

	public void setGiveMonth(String giveMonth) {
		this.giveMonth = giveMonth;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getNewMemberEndDate() {
		return newMemberEndDate;
	}

	public void setNewMemberEndDate(Date newMemberEndDate) {
		this.newMemberEndDate = newMemberEndDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getNewKennelEndDate() {
		return newKennelEndDate;
	}

	public void setNewKennelEndDate(Date newKennelEndDate) {
		this.newKennelEndDate = newKennelEndDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getNewGroomerEndDate() {
		return newGroomerEndDate;
	}

	public void setNewGroomerEndDate(Date newGroomerEndDate) {
		this.newGroomerEndDate = newGroomerEndDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getParticipationTime() {
		return participationTime;
	}

	public void setParticipationTime(Date participationTime) {
		this.participationTime = participationTime;
	}

	@Length(min = 0, max = 100, message = "推荐人长度必须介于 0 和 100 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@Length(min = 0, max = 1, message = "记录创建类型: 1 手动创建, 2 系统自动创建长度必须介于 0 和 1 之间")
	public String getRecordType() {
		return recordType;
	}

	public void setRecordType(String recordType) {
		this.recordType = recordType;
	}

	public String getNewMemberType() {
		return newMemberType;
	}

	public void setNewMemberType(String newMemberType) {
		this.newMemberType = newMemberType;
	}

	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getGiveGift() {
		return giveGift;
	}

	public void setGiveGift(String giveGift) {
		this.giveGift = giveGift;
	}

}