/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.cab.editor.ckuhotel.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import java.util.List;

import com.cku.cab.editor.groomervenue.entity.RestfulCkuImage;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容培训酒店Entity
 * @author zhuoHeng
 * @version 2016-11-29
 */
public class RestCkuHotel {
	
	private String id;
	private String hotelPhone;		// 酒店电话
	private String hotelLongitude;		// 经度
	private String hotelLatitude;		// 纬度
	private String hotelAddress;		// 酒店地址
	private String hotelName;		// 酒店名称
	private String hotelInfo;		// 酒店更多信息
	private String hotelLine;		// 行车路线
	private String createTime;		// 酒店建立时间
	private List<RestfulCkuImage> ckuImage;
	
	

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Length(min=0, max=50, message="酒店电话长度必须介于 0 和 50 之间")
	public String getHotelPhone() {
		return hotelPhone;
	}

	public void setHotelPhone(String hotelPhone) {
		this.hotelPhone = hotelPhone;
	}
	
	@Length(min=0, max=20, message="经度长度必须介于 0 和 20 之间")
	public String getHotelLongitude() {
		return hotelLongitude;
	}

	public void setHotelLongitude(String hotelLongitude) {
		this.hotelLongitude = hotelLongitude;
	}
	
	@Length(min=0, max=20, message="纬度长度必须介于 0 和 20 之间")
	public String getHotelLatitude() {
		return hotelLatitude;
	}

	public void setHotelLatitude(String hotelLatitude) {
		this.hotelLatitude = hotelLatitude;
	}
	
	public String getHotelAddress() {
		return hotelAddress;
	}

	public void setHotelAddress(String hotelAddress) {
		this.hotelAddress = hotelAddress;
	}
	
	@Length(min=0, max=100, message="酒店名称长度必须介于 0 和 100 之间")
	public String getHotelName() {
		return hotelName;
	}

	public void setHotelName(String hotelName) {
		this.hotelName = hotelName;
	}
	
	public String getHotelInfo() {
		return hotelInfo;
	}

	public void setHotelInfo(String hotelInfo) {
		this.hotelInfo = hotelInfo;
	}
	
	public String getHotelLine() {
		return hotelLine;
	}

	public void setHotelLine(String hotelLine) {
		this.hotelLine = hotelLine;
	}
	

	public String getCreateTime() {
		return createTime;
	}

	public void setCreateTime(String createTime) {
		this.createTime = createTime;
	}

	public List<RestfulCkuImage> getCkuImage() {
		return ckuImage;
	}

	public void setCkuImage(List<RestfulCkuImage> ckuImage) {
		this.ckuImage = ckuImage;
	}
	
}