//会员信息，会员注册
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.memberInfo = ko.observable({});
        //是否存在会员
        me.isMember = ko.observable(false);
        //会员续费
        //me.isLastTime = ko.observable(false);


        //省List
        me.provinceList = ko.observableArray([]);
        //市List
        me.cityList = ko.observableArray([]);
        me.provinceHtml = ko.observable("");
        me.cityHtml = ko.observable("");
        me.showProvince = function(){
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{
                $("#provinceDiv").css("display","none");
            }
            $("#cityDiv").css("display","none");
        }
        me.showCity = function(){
            if($("#cityDiv").css("display")=="none"){
                $("#cityDiv").css("display","block");
            }else{
                $("#cityDiv").css("display","none");
            }
            $("#provinceDiv").css("display","none");
        }
        me.changeProvince = function(data){
            me.provinceHtml(data);
            me.memberInfo().province = data;
            for(var i = 0;i<util.city.length;i++){
                if(data==util.city[i].local){
                    me.initProCity(data,util.city[i].localcity[0]);
                }
            }
            $("#provinceDiv").css("display","none");
        }
        me.changeCity = function(data){
            me.memberInfo().city = data;
            me.cityHtml(data);
            $("#cityDiv").css("display","none");
        }
        me.initProCity = function(province,city){
            me.provinceList().length = 0;
            me.cityList().length = 0;
            me.provinceHtml(province);
            me.cityHtml(city);
            for(var i = 0;i<util.city.length;i++){
                me.provinceList.push(util.city[i].local);
                if(province==util.city[i].local){
                    for(var j=0;j<util.city[i].localcity.length;j++){
                        me.cityList.push(util.city[i].localcity[j]);
                    }
                }
            }

        }


        //展现会员升级div
        //注册-改变会员类型
        me.changeType = function(type){
            $("#typeDiv a").removeClass("active");
            $("#"+type).addClass("active");
            me.memberInfo().memberType = type;
        }
        //注册-改变性别
        me.changeSex = function(type){
            $("#sexDiv a").removeClass("active");
            $("#"+type).addClass("active");
            me.memberInfo().gender = type;
        }
        /**
         * 注册会员
         */
        me.registerMember = function(){
            if(util.isVal(me.memberInfo().name)==""){
                layer.msg("会员姓名不能为空！");
                return;
            }
            if(!util.isCardNo(me.memberInfo().cardNo)){
                layer.msg("会员身份证格式不正确！");
                return;
            }
            if(!util.isMobile(me.memberInfo().mobile)){
                layer.msg("会员手机号不正确！");
                return;
            }

            if(!util.isEmail(me.memberInfo().email)){
                layer.msg("会员邮箱不正确！");
                return;
            }
            if(util.isVal(me.memberInfo().qq)==""){
                layer.msg("会员qq号不能为空！");
                return;
            }
            if(util.isVal(me.memberInfo().province)==""){
                layer.msg("会员省不能为空！");
                return;
            }
            if(util.isVal(me.memberInfo().city)==""){
                layer.msg("会员市不能为空！");
                return;
            }
            if(util.isVal(me.memberInfo().street)==""){
                layer.msg("会员街道不能为空！");
                return;
            }
            if(util.isVal(me.memberInfo().deliveryNotice)==""){
                layer.msg("通知邮寄方式不能为空！");
                return;
            }
            if(util.isVal(me.memberInfo().deliveryCertified)==""){
                layer.msg("证书邮寄方式不能为空！");
                return;
            }
            util.sendAjax({
                url:'userCenter/personalInfo',
                data:JSON.stringify(me.memberInfo()),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        userInfo.refresh();
                        context.app.changeCart();
                        layer.alert('注册会员成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                        location.href = location.href.split("#")[0]+"#home";
                    }else{
                        layer.msg("注册会员失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //会员升级
        me.memberUpgrade = function(){
            util.sendAjax({
                url:'member/upgrade',
                data:{},
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("会员升级失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //会员续费
        me.memberRenew = function(){
            util.sendAjax({
                url:'member/renew',
                data:{},
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("会员续费失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //展现cku条款
        me.showckuinfo = function(){
            if($("#showckuDiv").css("display")=="none"){
                $("#showckuDiv").css("display","block");
                $("#showEm").removeClass("show");
            }else{
                $("#showckuDiv").css("display","none");
                $("#showEm").addClass("show");
            }
        }
        $(function(){
            //得到会员信息
            if(userInfo.isMember){
                me.memberInfo(userInfo.getMember());
                var flag = Math.floor(new Date(me.memberInfo().memberEndDate).getTime()/1000)-Math.floor(new Date().getTime()/1000)<0?true:false;
                //me.isLastTime(flag);
                me.isMember(userInfo.isMember);
            }else{
                var data = {
                    "name":"",
                    "memberType":"basic",
                    "gender":"male",
                    "nameEn":"",
                    "cardNo":"",
                    "phone":"",
                    "mobile":"",
                    "birthday":"2017-02-03",
                    "fax":"",
                    "email":"",
                    "province":"北京市",
                    "city":"朝阳区",
                    "street":""
                };
                me.memberInfo(data);
                me.initProCity('北京市','朝阳区');
            }
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});