<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>工作日历管理</title>
	<meta name="decorator" content="default"/>
	<link href="${ctxStatic}/common/workday.css" rel="stylesheet" type="text/css" />
	<script src="${ctxStatic}/vue/vue.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			var vueEle = new Vue({
				el:"#dpLTE",
				data(){
					return {
						dateYear:new Date().getFullYear(),
						yearData:{}
					}
				},
				created() {
				    this.fetchData();
				},
				methods: {
					fetchData(){
						const that = this;
						that.loadFun();
						$.ajax({
							type: "GET",
							dataType:"json",
							url:"${ctx}/sys/workday/list/"+that.dateYear,
							success: function(res) {
								that.closeLoadFun();
								that.yearData =res.data; 
							}
						});
					},
					getCellClass(day){
						if(!day){
							return '';
						}
						if(day.day<=0){
							return 'calendar-td calendar-disabled';
						}else if(day.holiday == true){
							return 'calendar-td calendar-holiday';
						}else if(day.supplement == true){
							return 'calendar-td calendar-day-mark-td';
						}else{
							return '';
						}
					},
					isNull(value) {
						return value == undefined || value == null || value.length == 0;
					},
					isNotNull(value) {
						return value != undefined && value != null && value.length != 0;
					},
					changeDateYear(){
						this.dateYear = $("#dateYear").val();         
						this.fetchData();
					},
					addWeekend(){
						const that = this;
						$.jBox.confirm("确认要创建当年日历吗？","系统提示",function(v,h,f){
							if(v=="ok"){
								that.loadFun('addWeekend');
								$.ajax({
									type: "POST",
									dataType:"json",
									url:"${ctx}/sys/workday/addWeekend",
									data:{"dateStr":that.dateYear},
									success: function(data) {
										that.closeLoadFun('addWeekend');
									    if(data.rc=="0"){
									    	$.jBox.alert("创建成功！","消息",{submit:function (v, h, f) { 
						                		window.location = "${ctx}/sys/workday";
						                	}});
										}else{
											$.jBox.alert(data.msg);
										}
									}
								});
							}
						},{buttonsFocus:1,persistent: true});
						$('.jbox-body .jbox-icon').css('top','55px');
					},
					deleteWeekend(){
						const that = this;
						$.jBox.confirm("确认要删除当年日历吗？","系统提示",function(v,h,f){
							if(v=="ok"){
								that.loadFun('deleteWeekend');
								$.ajax({
									type: "POST",
									dataType:"json",
									url:"${ctx}/sys/workday/deleteWeekend",
									data:{"dateStr":that.dateYear},
									success: function(data) {
										that.closeLoadFun('deleteWeekend');
									    if(data.rc=="0"){
									    	$.jBox.alert("删除成功！","消息",{submit:function (v, h, f) { 
						                		window.location = "${ctx}/sys/workday";
						                	}});
										}else{
											$.jBox.alert(data.msg);
										}
									}
								});
							}
						},{buttonsFocus:1,persistent: true});
						$('.jbox-body .jbox-icon').css('top','55px');
					},
					getTruncatedText(text) {
				      if (text.length > 2) {
				        return text.substring(0, 2);
				      }
				      return text;
				    },
				    loadFun(btnId){
						top.layer.load();
						if(!btnId){
							$("#"+btnId).prop("disabled",true);
						}
					},
					closeLoadFun(btnId){
						top.layer.closeAll('loading');
						if(!btnId){
							$("#"+btnId).prop("disabled",false);
						}
					}
			    }
			})
		});
		
	</script>
</head>
<body>
		<div id="dpLTE">
		    <div class="flex-row form-row" style="padding:30px 0px;">
		    	<div class="col-md-4 text-center text-muted form-search"></div>
		        <div class="col-md-3 text-center text-muted  form-search">
			        <ul class="ul-form">
						<li>
							<label>年份：</label>
							<input id="dateYear" v-model="dateYear" @focus="changeDateYear()"  style="width:150px" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate" onclick="WdatePicker({dateFmt:'yyyy',isShowClear:true});"/>		
						</li>
						<li class="btns"><input v-if="!yearData.existDb" id="addWeekend" @click="addWeekend" class="btn btn-primary" type="button" value="初始日历数据"/></li>
						<li class="btns"><input v-if="yearData.existDb" id="deleteWeekend" @click="deleteWeekend" class="btn" type="button" value="删除当年日历"/></li>
					</ul>
		        </div>
		        <div class="col-md-4 text-center text-muted form-search"></div>
		    </div>
		    <div v-if="!yearData.existDb">
		    	<div class="no-data-content">
					<img src="${ctxStatic}/img/nodata.png"  class="no-data-img" />
					<div class="no-data-text">暂无数据</div>
				</div>
			</div>
		    <div class="flex-row"  v-for="(month,index) in yearData.monthGroup">
		        <div class="col-md-3 text-center text-muted" v-for="(m,mIndex) in month">
		            <div id="month1">
		            	<div class="calendar-box">
							<div class="calendar-content">
								<table>
									<thead>
										<tr>
											<th colspan="7" class="month">{{m.yearMonthLabel}}月</th>
										</tr>
										<tr>
											<th class="calendar-th-td">一</th>
											<th class="calendar-th-td">二</th>
											<th class="calendar-th-td">三</th>
											<th class="calendar-th-td">四</th>
											<th class="calendar-th-td">五</th>
											<th class="calendar-th-td weekend">六</th>
											<th class="calendar-th-td weekend">日</th>
										</tr>
									</thead>
									<tbody>
										<tr v-for="(d,dIndex) in m.daysGroup">
											<td :class="getCellClass(day)" v-for="day in d">
												<span v-if="day.day>0" >{{day.supplement == true && day.holiday == false?'补班':getTruncatedText(day.dayLabel)}}</span>
											</td>
										</tr>
									</tbody>
								</table>
							</div>
						</div>
		            </div>
		        </div>
		    </div>
		</div>
</body>
</html>