<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>认证师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/appraiser/">认证师列表</a></li>
		<shiro:hasPermission name="sys:appraiser:edit"><li><a href="${ctx}/sys/appraiser/form">认证师添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="appraiser" action="${ctx}/sys/appraiser/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>证书编号：</label>
				<form:input path="certificateNum" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>认证师姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>所属服务中心：</label>
				<form:select path="orgId" class="input-medium">
					<form:option value="">全部</form:option>
					<c:forEach items="${fns:getOrgsByType('catRenZheng') }" var="c">
						<form:option value="${fns:escapeHtml(c.id) }">${fns:escapeHtml(c.name) }</form:option>
					</c:forEach>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>证书编号</th>
				<th>认证师姓名</th>
				<th>所属服务中心</th>
				<th>截止时间</th>
				<th>审核</th>
				<shiro:hasPermission name="sys:appraiser:edit"><th>操作</th></shiro:hasPermission>
				<shiro:hasPermission name="sys:appraiser:edit"><th>打印</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="appraiser">
			<tr>
				<td>
					${appraiser.certificateNum}
				</td>
				<td>
					${appraiser.name}
				</td>
				<c:set var="tmpOrg" value="${fns:getOrgById(appraiser.orgId)}"/>
				<td>
					${tmpOrg.name}
				</td>
				<td>
					<fmt:formatDate value="${tmpOrg.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${appraiser.reviewState==0}" > 未审核 </c:if>
					<c:if test="${appraiser.reviewState==1}" > 通过 </c:if>
					<c:if test="${appraiser.reviewState==2}" > 未通过 </c:if>
				</td>
				<shiro:hasPermission name="sys:appraiser:edit"><td>
    				<a href="${ctx}/sys/appraiser/view?id=${appraiser.id}">查看</a>
    				<a href="${ctx}/sys/appraiser/form?id=${appraiser.id}">修改</a>
					<a href="${ctx}/sys/appraiser/delete?id=${appraiser.id}" onclick="return confirmx('确认要删除该记录吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
				<shiro:hasPermission name="sys:appraiser:edit"><td>
					<c:if test="${appraiser.reviewState eq 1 && appraiser.printFlag eq 0}">
    					<a href="${ctx}/sys/appraiser/print?id=${appraiser.id}" onclick="return confirmx('确认要打印证书吗？', this.href)" target="_Blank">打印</a>
    				</c:if>
    				<c:if test="${appraiser.reviewState eq 1 && appraiser.printFlag eq 1}">
    					<a href="${ctx}/sys/appraiser/resetPrint?id=${appraiser.id}" onclick="return confirmx('确认要重置打印吗？', this.href)">重置</a>
    				</c:if>
    				<c:if test="${appraiser.reviewState ne 1}">
    					打印
    				</c:if>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>