<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容报名统计</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function mySubmit()
		{
			document.getElementById("isOnSubmit").value = "1";
			document.getElementById("searchForm").submit();
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctx}/statistics/activity/showRegister">赛事报名统计</a></li>
		<li class=""><a href="${ctx}/statistics/activity/showOrderList">赛事报名订单统计</a></li>
		<li class=""><a href="${ctx}/statistics/activity/groomRegister">美容报名统计</a></li>
		<li class="active"><a href="#">培训报名统计</a></li>
	</ul>
	<form id="searchForm"  action="${ctx}/statistics/activity/handleRegister" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id="isOnSubmit" type="hidden" name="isOnSubmit" value=""/>
		<ul class="ul-form">
			<li><label>开始时间：</label>
				<input style="width:160px;" id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label style="width:100px;">结束时间：</label>
				<input style="width:160px;" id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd  HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>活动编号：</label>
				<input style="width:150px" id="showCode" name="showCode" value="${showCode}" type="text" maxlength="20" />
			</li>
			<li class="btns"><input id="btnSubmit" name="btnSubmit" class="btn btn-primary" type="submit" onclick = "mySubmit()" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<hr style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
		<p style="font-weight:bold;text-align:left;margin:0;border:none;padding:0">场次总数：${countTotal.numOfHandle} 收入总金额：<fmt:formatNumber type="currency" value="${countTotal.feeOfHandle}" maxFractionDigits="2"/> 报名人总数：${countTotal.numOfReg}</p>
	<hr style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
	<c:forEach items="${handleDetails}" var="handleDetails">
	<table id="${handleDetails.key}" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th style="width:150px">培训编号</th>
				<th style="width:400px">培训名称</th>
				<th style="width:70px">开始日期</th>
				<th style="width:70px">结束日期</th>
				<th style="width:350px">培训地点</th>
				<th style="width:25px">报名人数</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${handleDetails.value.details}" var="handleChild">
			<tr>
				<td>${fns:escapeHtml(handleChild.show_code)}</td>
				<td>${fns:escapeHtml(handleChild.show_name)}</td>
				<td>${fns:escapeHtml(handleChild.start_time)}</td>
				<td>${fns:escapeHtml(handleChild.end_time)}</td>
				<td>${fns:escapeHtml(handleChild.show_address)}</td>
				<td><a href="${ctx }/statistics/activity/handleView?showCode=${fns:escapeHtml(handleChild.show_code)}">${fns:escapeHtml(handleChild.numOfReg)}</a></td>
			</tr>
		</c:forEach>
		</tbody>
		<tbody>
			<tr>
    			<td colspan="7" valign="top" style="padding: 0;">
					<table align="right" cellpadding="0" cellspacing="0" style="width: 900px;">
						<tbody>
							<tr>
    							<td align="right" style="border-left:0; border-top:0px; padding:5px;">
    								<strong style="display: inline-block;width: 120px;">本场报名人数：</strong>
    								<em style="display: inline-block;width: 100px;font-style: normal;text-align: right;margin-right: 10px;">
    									<span style="font-size:16px;color: #9999ff;display: inline-block;">${handleDetails.value.countAll.numOfOrder}</span>
    									<strong style="display: inline-block;text-align: right;">人</strong>
    								</em>
    								<strong style="display: inline-block; width: 120px;">本场报名费应收：</strong>
    								<em style="display: inline-block;width: 120px;font-style: normal;text-align: right;margin-right: 10px;">
    									<span style="font-size:16px;color: #9999ff;"><fmt:formatNumber type="currency" value="${handleDetails.value.countAll.receivables}" maxFractionDigits="2"/></span>
    									<strong style="display: inline-block;">元</strong>
    								</em>
    								<br>
    								<strong style="display: inline-block; width: 120px;">赛前退赛人数：</strong>
    								<em style="display: inline-block;width: 100px;font-style: normal;text-align: right;margin-right: 10px;text-align: right;margin-right: 10px;">
    									<span style="font-size:16px;color: #9999ff;">${handleDetails.value.countAll.numOfAbsence}</span>
    									<strong style="display: inline-block;">人</strong>
    								</em>
    								<strong style="display: inline-block;width: 120px;">赛场请假人数：</strong>
    								<em style="display: inline-block;width: 120px;font-style: normal;text-align: right;margin-right: 10px;">
    									<span style="font-size:16px;color: #9999ff;">${handleDetails.value.countAll.numOfRefund}</span>
    									<strong style="display: inline-block;">人</strong>
    								</em>
    								<strong style="display: inline-block; width: 120px;">本场退参赛费合计：</strong>
    								<em style="display: inline-block;width: 100px;font-style: normal;text-align: right;margin-right: 10px;">
    									<span style="font-size:16px;color: #9999ff;"><fmt:formatNumber type="currency" value="${handleDetails.value.countAll.refund}" maxFractionDigits="2"/></span>
    									<strong style="display: inline-block;">元</strong>
    								</em>

    							</td>
    							<td style="border-right:0px;border-top:0px; padding:5px;">
    								<span style="font-size:20px; color: #9999ff"><fmt:formatNumber type="currency" value="${handleDetails.value.countAll.receivables-handleDetails.value.countAll.refund}" maxFractionDigits="2"/></span>
    								<strong style="font-size:20px;display: inline-block;">元</strong>
    							</td>
  							</tr>
						</tbody>
					</table>
				</td>
    		</tr>
		</tbody>
	</table>
	</c:forEach>
	<div class="pagination">${page}</div>
</body>
</html>