<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>犬展子表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
		//回显裁判信息
		var referee = '${fns:escapeHtml(mainShows.hospitalId)}';
		var refereeArray = referee.split(",");
		$.each(refereeArray, function(i,val) {
			$("#hospitalId").find("option[value='"+val+"']").attr("selected",true);
	    });
		$("#hospitalId").trigger("change");
		
        });
    </script>
<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
 <script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
    <ul class="nav nav-tabs">
        <li class="active"><a href="#">录入官网犬展信息</a></li>
    </ul><br/>
    <form:form id="inputForm" modelAttribute="mainShows" action="${ctx}/mainShow/CkuShows/saveMain" method="post" class="form-horizontal" style="min-height:2000px">
        <form:hidden path="id"/>
        <sys:message content="${message}"/>
        	<h3>主犬展信息</h3>
            <div class="control-group"></div>
            <div class="control-group" style="width: 100%;float: left;">
                <label class="control-label">主犬展名称：</label>
                <div class="controls">
                    <form:input path="mainShowName" htmlEscape="false" readonly="true"  maxlength="100" class="input-xxlarge required"/>
                </div>
            </div>
            <div class="control-group" style="width:100%;float: left;">
                <label class="control-label">犬展地点：</label>
                <div class="controls">
                    <form:input path="showLocation" htmlEscape="false" readonly="true"  class="input-xxlarge required"/>
                </div>
            </div>
            <div class="control-group" style="width: 50%;float: left">
                <label class="control-label">举办方式：</label>
                <div class="controls">
                    <form:radiobuttons path="orgnizeType" disabled="true" items="${fns:getDictList('show_orgnize_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
                </div>
            </div>
            <div class="control-group" style="width: 50%;float: right;">
                <label class="control-label">犬展报名：</label>
                <div class="controls">
                    <form:radiobuttons path="register" disabled="true"  items="${fns:getDictList('show_register')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
                </div>
            </div>
            <div class="control-group" style="width: 50%;float: left">
                <label class="control-label">报名结束日期：</label>
                <div class="controls">
                    <input name="closingTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                        value="<fmt:formatDate value="${mainShows.closingTime}" pattern="yyyy-MM-dd HH:mm"/>"
                        />
                </div>
            </div>
            <div class="control-group" style="width: 50%;float: right;">
                <label class="control-label">主办单位：</label>
                <div class="controls">
                    ${mainShows.organizer}
                </div>
            </div>
            <div class="control-group" style="width: 100%;float: left;">
			<label class="control-label">缩略图：</label>
				<div class="controls">
				<c:if test="${not empty mainShows.thumbnailImage }">
					<div><img  id="test" src="${pageContext.request.contextPath}/api/v1/open/image/${mainShows.thumbnailImage}"></div>
				</c:if>
				<c:if test="${empty mainShows.thumbnailImage }">
					<div><img  id="test" src=""></div>
				</c:if>
				<input id="image1" type="file" name="file" lay-type="image" lay-title="请上传犬展缩略图" class="layui-upload-file">
						<span><a class="btn btn-success" onclick="deleteImg('thumbnailImage')">删除图片</a></span>
				<form:input path="thumbnailImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
				  layui.upload({
					    url: '${ctx}/sys/file/layupload'
					    ,elem: '#image1' //指定原始元素，默认直接查找class="layui-upload-file"
					    ,method: 'POST' //上传接口的http类型
					    ,success: function(res){
					    	$("#thumbnailImage").val(res.id);
					    	$("#test").attr("src",res.url);
					    }
					  }); 
				</script>
				</div>
			</div>
             <div class="control-group" style="width: 100%;float: left;">
			<label class="control-label">犬展长图：</label>
				<div class="controls">
					<c:if test="${not empty mainShows.handerImage }">
						<div><img  id="test1" src="${pageContext.request.contextPath}/api/v1/open/image/${mainShows.handerImage}"></div>
					</c:if>
					<c:if test="${empty mainShows.handerImage }">
						<div><img  id="test1" src=""></div>
					</c:if>
					<input id="image2" type="file" name="file" lay-type="image" lay-title="请上传犬展标题图" class="layui-upload-file">
						<span><a class="btn btn-success" onclick="deleteImg('handerImage')">删除图片</a></span>
					<form:input path="handerImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<!-- 文件上传成功的回调方法 -->
					<script type="text/javascript">
					  layui.upload({
						    url: '${ctx}/sys/file/layupload'
						    ,elem: '#image2' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#handerImage").val(res.id);
						    	$("#test1").attr("src",res.url);
						    }
						  }); 
					</script>
				</div>
			</div> 
            <div class="control-group" style="width: 100%;float: left;">
			<label class="control-label">犬展时间安排：</label>
				<div class="controls">
				<c:if test="${not empty mainShows.scheduleImage }">
					<div><img  id="test2" src="${pageContext.request.contextPath}/api/v1/open/image/${mainShows.scheduleImage}"></div>
				</c:if>
				<c:if test="${ empty mainShows.scheduleImage }">
					<div><img  id="test2" src=""></div>
				</c:if>
					<input id="image3" type="file" name="file" lay-type="image" lay-title="请上传犬展时间安排图" class="layui-upload-file">
					<span><a class="btn btn-success" onclick="deleteImg('scheduleImage')">删除图片</a></span>
					<form:input path="scheduleImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<!-- 文件上传成功的回调方法 -->
					<script type="text/javascript">
				 	  layui.upload({
						    url: '${ctx}/sys/file/layupload'
						    ,elem: '#image3' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#scheduleImage").val(res.id);
						    	$("#test2").attr("src",res.url);
						    }
						  }); 
				 	  
				 	  function deleteImg(type){
				 		  var id =$("#id").val();
			                $.post('${ctx}/mainShow/CkuShows/deleteCkuImage', {
			                	mainShowId: id,
			                    type: type
			                }, function(data) {
			                    if(data.rc==0){
			                    	if("scheduleImage"==type){
								    	$("#test2").attr("src","");
								    	$("#scheduleImage").val("");
			                    	}
			                    	if("handerImage"==type){
								    	$("#test1").attr("src","");
								    	$("#handerImage").val("");

			                    	}
			                    	if("thumbnailImage"==type){
								    	$("#test").attr("src","");
								    	$("#thumbnailImage").val("");
			                    	}
			                    	
			                    	if("imageMaxUrl"==type){
								    	$("#imageMaxUrlView").attr("src","");
								    	$("#imageMaxUrl").val("");
								    	$("#imageMaxUrlId").val("");
			                    	}
			                    	if("imageMinUrl"==type){
								    	$("#imageMinUrlView").attr("src","");
								    	$("#imageMinUrl").val("");
								    	$("#imageMinUrlId").val("");
			                    	}
			                        alert("操作成功！");
			                    }else{
			                        alert("操作失败,错误信息："+data.msg);
			                    } 
			                });
				 	  }
					</script>
				</div>
			</div> 
			<div class="control-group" style="width: 100%;float: left;">
				<label class="control-label">app犬展页banner图：</label>
				<div class="controls">
				<c:if test="${not empty mainShows.imageMaxUrl }">
					<div><img  id="imageMaxUrlView" src="${mainShows.imageMaxUrl}"></div>
				</c:if>
				<c:if test="${ empty mainShows.imageMaxUrl }">
					<div><img  id="imageMaxUrlView" src=""></div>
				</c:if>
					<input id="image4" type="file" name="file" lay-type="image" lay-title="请上传app犬展页banner图" class="layui-upload-file">
					<span><a class="btn btn-success" onclick="deleteImg('imageMaxUrl')">删除图片</a></span>
					<form:input path="imageMaxUrl" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<form:input path="imageMaxUrlId" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<!-- 文件上传成功的回调方法 -->
					<script type="text/javascript">
				 	  layui.upload({
						    url: '${ctx}/sys/file/layupload'
						    ,elem: '#image4' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#imageMaxUrl").val(res.url);
						    	$("#imageMaxUrlId").val(res.id);
						    	$("#imageMaxUrlView").attr("src",res.url);
						    }
						  }); 
					</script>
				</div>
			</div> 
			<div class="control-group" style="width: 100%;float: left;">
				<label class="control-label">app缩略图：</label>
				<div class="controls">
				<c:if test="${not empty mainShows.imageMinUrl }">
					<div><img  id="imageMinUrlView" src="${mainShows.imageMinUrl}"></div>
				</c:if>
				<c:if test="${ empty mainShows.imageMinUrl }">
					<div><img  id="imageMinUrlView" src=""></div>
				</c:if>
					<input id="image5" type="file" name="file" lay-type="image" lay-title="请上传app缩略图" class="layui-upload-file">
					<span><a class="btn btn-success" onclick="deleteImg('imageMinUrl')">删除图片</a></span>
					<form:input path="imageMinUrl" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<form:input path="imageMinUrlId" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					<!-- 文件上传成功的回调方法 -->
					<script type="text/javascript">
				 	  layui.upload({
						    url: '${ctx}/sys/file/layupload'
						    ,elem: '#image5' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#imageMinUrl").val(res.url);
						    	$("#imageMinUrlId").val(res.id);
						    	$("#imageMinUrlView").attr("src",res.url);
						    }
						  }); 
					</script>
				</div>
			</div> 
			
			
			
			
            <h3>地方办公室信息</h3>
            <div class="control-group"></div>
           <div class="control-group" style="width:100%;float: left;">
	          <label class="control-label">办公室：</label>
				<div class="controls">
	                <form:select  path="officeId"  class="input-xxlarge required" >
	                	<form:option value="" label="请选择"/>
	                	<form:options items="${officeList}" itemLabel="name" itemValue="id" htmlEscape="false"/>
	                </form:select>
				</div>
            </div>
            <h3>活动场馆信息</h3>
            <div class="control-group" style="width:100%;float: left;">
            </div>
           <div class="control-group" style="width:100%;float: left;">
	          <label class="control-label">犬展场馆：</label>
				<div class="controls">
	                <form:select path="showVenueId"  class="input-xxlarge required" >
	                	<form:option value="" label="请选择"/>
	                	<form:options items="${venueList}" itemLabel="venueName" itemValue="id" htmlEscape="false"/>
	                </form:select>
				</div>
            </div>
            <h3>酒店住宿信息</h3>
            <div class="control-group" style="width:100%;float: left;">
            </div>
            <div class="control-group" style="width:100%;float: left;">
            	<label class="control-label">犬展酒店：</label>
				<div class="controls">
	                <form:select id="hospitalId" path="hospitalId" class="input-xxlarge" multiple="true">
                        <form:options items="${hotelList}" itemLabel="hotelName" itemValue="id" htmlEscape="false"/>
                    </form:select>
				</div>
            </div>
        <div class="form-actions"  style="width: 89%;float: right;">
            <shiro:hasPermission name="mainShow:CkuShows:add"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
            <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
        </div>
    </form:form>
</body>
</html>