<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>牵犬师电话报名录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	$(document).ready(function() {
		$("#inputForm").validate({
			submitHandler: function(form){
				var memberCode=$("#memberCode").val();
				var showCode=$("#showCode").val();
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/handler/handlerRegister/registerCheck?showCode="+encodeURI(showCode, "UTF-8")+"&memberCode="+memberCode,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == true){
	                		$.jBox.alert("您已经报名过了,请勿重复报名!","错误");
	                	}else{
	                		loading('正在提交，请稍等...');
	                		form.submit();
	                	}
	                }
				}); 
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});	
		
		$("#showDog").hide();
		//根据赛事的级别进行犬种的变化
		//犬种的变化
		var showType='${handlerShow.showType}';
		if(showType=='0'){
			
			var level=$("input[name='showLevel'][type='radio']:checked").val();
			var html="";
			if(level=='C'){
				html="<label class='control-label'>任意品种：</label><div class='controls '><input name='anyBreed' type='text'class='required' /></div>";
			}else if(level=='B'){
				html="<label class='control-label'>桌面审查犬:</label><div class='controls '><input name='desktopReviewerDog' type='text' class='required'  /> "+
					"<label>地面审查犬:</label><input name='floorReviewerDog' type='text' class='required'  /></div>";
			}else if(level=='A'){
				html="<label class='control-label'>桌面审查犬:</label><div class='controls required'><input name='desktopReviewerDog' type='text' class='required' /> "+
					"<label>地面审查犬:</label><input name='floorReviewerDog' type='text' class='required'  />"+
					"<label>任意品种：</label><input name='anyBreed' type='text' class='required' /></div>";
			}else if(level=='MASTER'){
				html="<label class='control-label'>桌面审查犬:</label><div class='controls'><input name='desktopReviewerDog' type='text' class='required'  /> "+
					"<label>地面审查犬:</label><input name='floorReviewerDog' type='text'  class='required' />"+
					"<label>美容品种：</label><input name='groomerBreed' type='text' class='required' /></div>";
			}else{
				html="<label class='control-label'>比赛犬种:</label><div class='controls'>无</div>"
			}
			$("#showDog").show();
			$("#showDog").html(html);
		}else if(showType=='1'){
			var html="<label class='control-label'>任意品种：</label><input name='anyBreed' type='text' class='required' /></div>";
			$("#showDog").show();
			$("#showDog").html(html);
		}
		
	});
		
	
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">电话报名录入</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/mobileFrom" method="post"
		class="form-horizontal">
		<input id="avatar" name="avatar" type="hidden">
		<input id="anyBreed" name="anyBreed" type="hidden">
		<input id="showDog" name="showDog" type="hidden">
		<sys:message content="${message}" />
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100"
					class="input-xlarge required" readonly="true" />
				<input id="selectMember" class="btn btn-primary" value="查询"
					type="button" onclick="searchUser()" /> 
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100"
					class="input-xlarge " readonly="true" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">余额：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="accountBalance"
					class="input-xlarge ">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input name="gender" maxlength="50" class="input-xlarge" type="radio" value="male" readonly="readonly" /> 
				<label>男</label> 
				<input name="gender" maxlength="50"  class="input-xlarge" type="radio" value="female" readonly="readonly" /> 
				<label>女</label>
			</div>
		</div>
		<div class="control-group" style="display: none;">
			<label class="control-label">培训机构：</label>
			<div class="controls">
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="100" value="无" class="input-xlarge required" />
				<ul>
					<li><font color="red">注:无培训机构,请填写'无'!</font></li>
				</ul>
			</div>
		</div>
		<div style="clear: both;"></div>
		<h3>赛事信息</h3>
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<input value="${handlerShow.showName}" type="text"
					readonly="readonly" id="showName" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<input id="showCode" name="showCode" type="text"
					value="${handlerShow.showCode}" class="input-xlarge required"
					readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				<input id="fee" name="fee" type="text" value="${handlerShow.fee}"
					class="input-xlarge required" readonly="readonly" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛组别：</label>
			<div class="controls">
				<input id="showLevel" name="showLevel" type="text"
					 class="input-xlarge required"
					readonly="readonly" />
			</div>
		</div> 
		<div class="control-group">
			<label class="control-label">参赛犬只：</label>
			<div class="controls">
				<input name="haveTx" maxlength="50" class="input-xlarge "  type="radio"  value="Cku" onchange="selectCku()"/> 
				<label>CKU注册犬</label> 
				<input name="haveTx" maxlength="50" class="input-xlarge "   type="radio"  value="notCku" onchange="selectCku()"/> 
				<label>国外犬只</label> 
			</div>
		</div> 
		<div id="isCku" class="control-group" style="width: 100%;display: none" >
			<label class="control-label">CKU注册犬只：</label>
			<div class="controls">
					<span style="width: 100%;float: left">血统证书号:<input id="dogCode" maxlength="50" class="input-xlarge required"  type="text"  /><a onclick="checkDog();" class="btn btn-primary">查询</a></span> 
					<span style="float: left">犬种名称:<input id="dogBreedName" maxlength="50" class="input-xlarge " readonly="readonly" type="text"  /></span> 
					<span style="float: left">犬只姓名:<input id="nameEn"  maxlength="50" class="input-xlarge "  readonly="readonly" type="text" /> </span>
					<span style="float: left">芯片号码:<input id="identificationFlag" maxlength="50" class="input-xlarge "  readonly="readonly" type="text" /> </span>
					<span style="float: left;">犬主姓名:<input id="dogOwner" maxlength="50" class="input-xlarge " readonly="readonly" type="text"  /> </span>
					<span style="float: left;">出生日期:<input id="birthdate" maxlength="50" class="input-xlarge "  readonly="readonly" type="text" /> </span>
					<span style="float: left;">犬只毛色:<input id="colorFlag" maxlength="50" class="input-xlarge "  readonly="readonly" type="text" /> </span>
			</div>
		</div> 
		<div id="notCku" class="control-group" style="width: 100%;display: none" >
			<label class="control-label">国外犬只：</label>
			<div class="controls">
					<span style="float: left">国外证书号:<input id="overPediCode" maxlength="50" class="input-xlarge required"  type="text"  /></span> 
					<span style="float: left">芯片号:<input id="dogChip" maxlength="50" class="input-xlarge required"   type="text" /> </span>
					<span style="float: left">犬种:<input id="dogType" maxlength="50" class="input-xlarge required"   type="text" /> </span>
			</div>
		</div> 
		<div id="showDog" class="control-group"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" onclick="saveRegister()"
				value="保 存" />&nbsp; <input id="btnCancel"
				class="btn" type="button" value="返 回" onclick="history.go(-1)" />
		</div>
	</form:form>
	<script>
   	function selectCku(){
    	var pediCode=$('input[name=haveTx]:checked').val();
    	if (pediCode=='Cku'){
    		$("#isCku").show();
    		$("#notCku").hide();
    	}else if (pediCode=='notCku'){
    		$("#isCku").hide();
    		$("#notCku").show();
    	}else{
    		$("#isCku").hide();
    		$("#notCku").hide();
    	}
    }
	
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}
		
		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode").val(json.memberCode);
			$("#name").val(json.name);
            if(json.paymentState==2){
         	   $("#paymentState").text('有效');
            }else{
         	   $("#paymentState").text('无效');
            };
            $("#mobile").val(json.mobile);
            $("#avatar").val(json.avatar);
            $("#accountBalance").val(json.accountBalance);
            $("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
            var memberCode=json.memberCode;
            var id = '${handlerShow.id}';
            $.ajax({
                type:"POST",
                url: ctx+"/handler/handlerRegister/getMemberGroup",
                data : {'memberCode':memberCode,'id':id},
                dataType: 'json',
                async: false, 
                success: function(jsons){
                	if (jsons.rc==0) {
                  		$("#showLevel").val(jsons.group);
					}else{
                  		$.jBox.alert(jsons.msg,"提示");
						$("#memberCode").val('');
						$("#name").val('');
						$("#mobile").val('');
		           		$("#accountBalance").val('');
		           		$("#schoolNameCn").val('');
		          	    $("input[type=radio][name='gender']").removeAttr("checked");
					}
                }
            });
            
		}
		
		function checkDog(){
			var dogCode=$("#dogCode").val();
			if(dogCode==''){
          		$.jBox.alert("血统证书号不可为空!","提示");
			}
            $.ajax({
                type:"GET",
                url: ctx+"/dog/dog/getDogMsg",
                data : {'pedigreeCertifiedCode':dogCode},
                dataType: 'json',
                async: false, 
                success: function(json){
                	if (json.rc==0) {
                       $("#dogBreedName").val(json.dogBreedName);
                       $("#nameEn").val(json.nameEn);
                       $("#identificationFlag").val(json.identificationFlag);
                       $("#dogOwner").val(json.dogOwner);
                       $("#birthdate").val(json.birthdate);
                       $("#colorFlag").val(json.colorFlag);
                      }else{
                  		$.jBox.alert(json.msg,"提示");
                        $("#dogBreedName").val("");
                        $("#nameEn").val("");
                        $("#identificationFlag").val("");
                        $("#dogOwner").val("");
                        $("#birthdate").val("");
                        $("#colorFlag").val("");
					}
                }
            });
			
		}
		function saveRegister(){
			debugger;
			var memberCode=$("#memberCode").val();
			var dogBreedName=$("#dogBreedName").val();
			if(memberCode==''){
          		$.jBox.alert("会员号不可为空!","提示");
          		return false;
			}
	    	var pediCode=$('input[name=haveTx]:checked').val();
	    	if (pediCode=='Cku'){
				var dogCode=$("#dogCode").val();
				if(dogCode==''){
	          		$.jBox.alert("血统证书号不可为空!","提示");
	          		return false;
				}
				if(dogBreedName==''){
	          		$.jBox.alert("请查询后提交!","提示");
	          		return false;
				}
				$("#showDog").val(pediCode);
				$("#anyBreed").val(dogBreedName);
	    	}else if (pediCode=='notCku'){
				var overCode=$("#overPediCode").val();
				var chipCode=$("#dogChip").val();
				var dogType=$("#dogType").val();
				if(overCode==''){
	          		$.jBox.alert("国外证书号不可为空!","提示");
	          		return false;
				}
				if(chipCode==''){
	          		$.jBox.alert("芯片号不可为空!","提示");
	          		return false;
				}
				if(dogType==''){
	          		$.jBox.alert("犬种不可为空!","提示");
	          		return false;
				}
				$("#showDog").val(overCode+"/"+chipCode);
				$("#anyBreed").val(dogType);
	    	}else{
          		$.jBox.alert("请选择参赛犬只!","提示");
          		return false;
	    	}
	    	
			$("#inputForm").submit();
			
		}
		

	</script>
</body>
</html>