<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<!-- RECORD 报名信息管理-列表编辑-OA报名编辑 -->
	<title>报名信息修改</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			
			if("${groomerShow.showCategory}"=='3'){
				if('${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")}' != 'true'){
					$("#moxing").hide();
				}
				$("input[type='radio'][name='showLevel']").change(function(){
					if($(this).val()=='国际宠物美容师'){
						$("#moxing").show();
					}else{
						$("#moxing").hide();
						if($('input[type=radio][name=showDogBreed]:checked').val()=='模型'){
							$("input[type='radio'][name='showDogBreed'][value='贵宾']").attr("checked","true");	
						}
					}
				});
			}
			if('${groomerShow.showCategory}' == '6' || '${groomerShow.showCategory}' == '7'){
				var testLevel = '${groomerShow.testLevel}'.split(",");
				var showLevel = '${groomerRegister.showLevel}';
				$.each(testLevel, function (index, value){
					/*$("<input type='radio' name='showLevel' value=''>").attr("value",value).text(value).appendTo("#showLevelDiv");*/
					var levelRadioHtml = "<input type='radio' name='showLevel' value='" + value + "'>" + "<span>" + value + "</span>";
					$(levelRadioHtml).appendTo("#showLevelDiv");
					if (value === showLevel) {
						$("input[type='radio'][name='showLevel'][value='" + value + "']").prop('checked', true);
					}
				});
			}
			
			$('input[type=radio][name=showDogBreed]').change(function() {
		          if ($(this).val() == '无') {
		              $("#showDogBreedId").removeAttr("disabled");
		          } else  {
					  $("#showDogBreedId").attr("disabled","disabled");
					  $("#showDogBreedId").val("");
		          }
		    });
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><shiro:hasPermission name="groomer:groomerRegister:edit"><a href="${ctx}/groomer/groomerRegister/form?id=${groomerRegister.id}">报名信息编辑</a></shiro:hasPermission></li>
	</ul>
	<form:form id="inputForm" modelAttribute="groomerRegister" action="${ctx}/groomer/groomerRegister/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label> 
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
				<span class="help-inline"><font color="red">*</font></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label> 
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训学校：</label> 
			<div class="controls">
				<form:input path="schoolNameCn"   htmlEscape="false" class="input-xlarge " />
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事名称：</label>
			<div class="controls">
				<form:input path="groomerShow.showName" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true" />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">活动分类：</label>
			<div class="controls">
					${fns:getDictLabel(groomerShow.showCategory, 'groomer_show_category', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				<c:set var="showCategory" value="${groomerShow.showCategory}"></c:set>
				<c:choose>
				    <c:when test="${showCategory eq '1'}">
						<input name="showLevel" class="required" type="radio" value="none" ${fns:splitContains(groomerRegister.showLevel,"none",",")?"checked":""}/>
						<label>无</label>
						<input  name="showLevel" class="required" type="radio" value="C" ${fns:splitContains(groomerRegister.showLevel,"C",",")?"checked":""}/>
						<label>C</label>
						<input  name="showLevel" class="required" type="radio" value="B" ${fns:splitContains(groomerRegister.showLevel,"B",",")?"checked":""}/>
						<label>B</label>
						<input name="showLevel" class="required" type="radio" value="A" ${fns:splitContains(groomerRegister.showLevel,"A",",")?"checked":""}/>
						<label>A</label>
						<input name="showLevel" class="required" type="radio" value="MASTER" ${fns:splitContains(groomerRegister.showLevel,"MASTER",",")?"checked":""}/>
						<label>教师</label>
				    </c:when>
				    <c:when test="${showCategory eq '2'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '3'}">
				    	<input name="showLevel" class="required" type="radio" value="国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"国际宠物美容师",",")?"checked":""}/>
						<label>国际宠物美容师</label>
						<input  name="showLevel" class="required" type="radio" value="宠物造型师&国际宠物美容师" ${fns:splitContains(groomerRegister.showLevel,"宠物造型师&国际宠物美容师",",")?"checked":""}/>
						<label>宠物造型师&国际宠物美容师</label>
				    </c:when>
				    <c:when test="${showCategory eq '4'}">
				    	<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_nurse_level" rangeItems="${groomerShow.testLevel}" remarks="注：切换参赛级别请重新选择比赛犬种"></oa:dictRadios>
				    </c:when>
					<c:when test="${groomerShow.showCategory eq '6' || groomerShow.showCategory eq '7'}">
						<div id = "showLevelDiv">

						</div>
						<%--<input  name="showLevel" class="required" type="radio" value="C"/>
						<label>C</label>
						<input  name="showLevel" class="required" type="radio" value="B"/>
						<label>B</label>
						<input name="showLevel" class="required" type="radio" value="A"/>
						<label>A</label>--%>
					</c:when>
					<c:when test="${showCategory eq '8'}">
						<oa:dictRadios name="showLevel" value="${groomerRegister.showLevel}" cssClass="input-xlarge required" type="groomer_cat_nurse_level" rangeItems="${groomerShow.testLevel}"></oa:dictRadios>
					</c:when>
				    <c:otherwise>
				    	活动类型错误
				    </c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">请假及取消：</label>
			<div id="leaveCancel"  class="controls">
	            <c:if test="${groomerRegister.leaveCancel=='0'}">
				否&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<a href="${ctx}/groomer/groomerRegister/updateLeaveFlag?id=${groomerRegister.id}&leaveCancel=1" onclick="return confirmx('确认要退费吗？', this.href)">确认退费</a>
				</c:if>
				<c:if test="${groomerRegister.leaveCancel=='1'}">
				是&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<a href="${ctx}/groomer/groomerRegister/updateLeaveFlag?id=${groomerRegister.id}&leaveCancel=0" onclick="return confirmx('确认要撤销退费吗？', this.href)">撤销退费</a>
				</c:if>
				<label  style="margin-left:20px;color:red;">（关联报名统计中“赛前请假人数”）</label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">赛场请假：</label>
			<div id="showLeave" class="controls">
				 <c:if test="${groomerRegister.showLeave=='0'}">
				否&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<a href="${ctx}/groomer/groomerRegister/updateLeaveFlag?id=${groomerRegister.id}&showLeave=1" onclick="return confirmx('确认要请假吗？', this.href)">确认请假</a>
				</c:if>
				<c:if test="${groomerRegister.showLeave=='1'}">
				是&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<a href="${ctx}/groomer/groomerRegister/updateLeaveFlag?id=${groomerRegister.id}&showLeave=0" onclick="return confirmx('确认要撤销请假吗？', this.href)">撤销请假</a>
				</c:if>
				<label style="margin-left:20px;color:red; ">（关联报名统计中“赛前退赛人数”）</label>
			</div>
			
		</div>
		<c:set var="showLevelHidden" value="${groomerShow.showCategory eq '1' && groomerShowTypeMap['showType'] eq 'cathedra'}"></c:set>
		<div class="control-group" ${showLevelHidden?'style="display:none"':''}>
			<label class="control-label">比赛品种：</label>
			<div class="controls">
				<c:choose>
				    <c:when test="${showCategory eq '4'}">
						<oa:groomerBreeds name="showDogBreed" validate="false" value="${groomerRegister.showDogBreed}" otherName="showDogBreedExtra" otherValue="${groomerRegister.showDogBreedExtra}" memberElementId="memberCode" levelElementId="showLevel" cssClass="input-xlarge required"></oa:groomerBreeds>
				    </c:when>
					<c:when test="${showCategory eq '8'}">
						<input name="showDogBreed" type="text" value="${groomerRegister.showDogBreed}"/>
					</c:when>
				    <c:otherwise>
				    	<c:choose>
							<c:when test="${groomerRegister.showDogBreed==''}">
								无
							</c:when>
							<c:otherwise>
				                <input  name="showDogBreed" type="radio" class="required" value="贵宾" ${fns:splitContains(groomerRegister.showDogBreed,"贵宾",",")?"checked":""}/>
				                <label>贵宾</label>
				               	<input  name="showDogBreed" type="radio" class="required" value="比熊" ${fns:splitContains(groomerRegister.showDogBreed,"比熊",",")?"checked":""}/>
				                <label>比熊</label>
				                <input name="showDogBreed" type="radio" class="required" value="雪纳瑞" ${fns:splitContains(groomerRegister.showDogBreed,"雪纳瑞",",")?"checked":""}/>
				                <label>雪纳瑞</label>
								<c:if test="${showCategory eq '2' || showCategory eq '3'}">
									<div id="moxing" style="display: inline-block;">
										<input name="showDogBreed" class="required" type="radio" value="模型" ${fns:splitContains(groomerRegister.showDogBreed,"模型",",")?"checked":""}/>
										<label>模型</label>
									</div>
								</c:if>
								<input name="showDogBreed" type="radio" class="required" value="无" ${fns:splitContains(groomerRegister.showDogBreed,"无",",")?"checked":""}/>
				                <label>其他犬种: </label>
				                <input id="showDogBreedId" name="showDogBreed" type="text" ${!fns:splitContains(groomerRegister.showDogBreed,"无",",")?"disabled":""} value='${fns:replaceContainsEmpty(groomerRegister.showDogBreed,"无,贵宾,比熊,雪纳瑞,模型",",")}'/><span><font>&nbsp;&nbsp;注:多个犬种用空格分隔</font></span>
							</c:otherwise>
						</c:choose>
				    </c:otherwise>
				</c:choose>
			</div>
		</div>
		<div class="control-group">
		<label class="control-label">审核状态：</label>
				<div class="controls">
				<form:select path="reviewState" class="input-medium">
					<form:option value="0" label="未审核"/>
					<form:option value="1" label="通过"/>
					<form:option value="2" label="未通过"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核备注：</label>
			<div class="controls">
				<form:input path="reviewRemarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="groomer:groomerRegister:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="提交"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>