<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只种类管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			var bo;
			$("#dogBreedCode").blur(function(){
				var dogBreedCode = encodeURI($("#dogBreedCode").val());
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/dogtype/dogType/dogBreedCodeCheck?dogBreedCode="+dogBreedCode,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == false){
	                		bo = data.rc;
	                		$("#dogBreedCodeError").html('犬种代码已经存在！');
							$("#dogBreedCodeError").show();
							$("#dogBreedCode").attr("value", '');
	                	}else{
	                		bo = data.rc;
	                	}
	                }
				})
			});
			$("#dogBreedCode").focus(function(){
				$("#dogBreedCodeError").hide();
			})
			$("#inputForm").validate({
				submitHandler: function(form){
					if(bo == false){
						alert(bo);
                		$("#dogBreedCodeError").html('犬种代码已经存在！');
						$("#dogBreedCodeError").show();
						$("#dogBreedCode").attr("value", '');
					}else{
						loading('正在提交，请稍等...');
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogtype/dogType/">犬只种类列表</a></li>
		<li class="active"><a href="${ctx}/dogtype/dogType/form?id=${dogType.id}">犬只种类<shiro:hasPermission name="dogtype:dogType:edit">${not empty dogType.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogtype:dogType:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogType" action="${ctx}/dogtype/dogType/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">犬种类代码：</label>
			<div class="controls">
				<form:input path="dogBreedCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
				<span id="dogBreedCodeError" style="color:red;display:none" class="error"></span>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬种：</label>
            <div class="controls">
                <form:input path="dogBreed"  htmlEscape="false" maxlength="255" class="input-xlarge "/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬种类英文名称：</label>
			<div class="controls">
				<form:input path="breedEnName" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类英文别名：</label>
			<div class="controls">
				<form:input path="breedEnAlias" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">犬种类中文名称：</label>
			<div class="controls">
				<form:input path="breedCnName" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类中文别名：</label>
			<div class="controls">
				<form:input path="breedCnAlias" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国别：</label>
			<div class="controls">
				<form:input path="countries" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">CACIB：</label>
			<div class="controls">
				<form:input path="cacib" htmlEscape="false" maxlength="1" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">标准时间：</label>
			<div class="controls">
				<form:input path="standardTime" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种分类：</label>
			<div class="controls">
				<form:select path="breedClass" class="input-xlarge" style="width:284px;">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('dog_breed_class')}" itemLabel="label" itemValue="value"  htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">组：</label>
			<div class="controls">
				<form:input path="typeGroup" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">节：</label>
			<div class="controls">
				<form:input path="node" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">位：</label>
			<div class="controls">
				<form:input path="figures" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种类照片：</label>
			<div class="controls">
				<form:input path="dogBreedPhoto" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">当前最大序号：</label>
			<div class="controls">
				<form:input path="nowMaxNumber" htmlEscape="false" maxlength="11" class="input-xlarge required"/>
				<font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group"  style="float: left">
			<label class="control-label">犬种简称：</label>
			<div class="controls">
				<form:input path="shortName" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">是否热门标识：</label>
			<div class="controls">
                <form:select path="hot" class="input-xlarge " onclick="changeState()">
                    <form:options items="${fns:getDictList('hot')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
                <font color="#FF0000">注：此两项为APP端功能 </font>
            </div>
		</div>
		<div class="control-group">
			<label class="control-label">出生纸一窝最大犬数：</label>
			<div class="controls">
				<form:input path="batchMaxNum" htmlEscape="false" type="number" min="1" maxlength="2" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dogtype:dogType:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>