/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只DNA存档Controller
 * @author lgl
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "/subSystem/dogDnaArchive")
public class SubDogDnaArchiveController extends BaseController {

	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogDnaArchive get(@RequestParam(required=false) String id) {
		DogDnaArchive entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogDnaArchiveService.get(id);
		}
		if (entity == null){
			entity = new DogDnaArchive();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(DogDnaArchive dogDnaArchive, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogDnaArchive> page = dogDnaArchiveService.findPage(new Page<DogDnaArchive>(request, response), dogDnaArchive); 
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dnaarchive/dogDnaArchiveList";
	}
	
	@RequestMapping(value = "form")
	public String form(DogDnaArchive dogDnaArchive, Model model) {
		model.addAttribute("dogDnaArchive", dogDnaArchive);
		return "subSystem/"+getUrlByUserType()+"/dog/dnaarchive/dogDnaArchiveForm";
	}
}