package com.cku.restful.v2.order.vo.response;

import com.cku.oa.order.vo.OrderBusinessVo;
import com.cku.oa.sys.entity.user.Member;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author yuanshuai
 * @date 2023/6/15 17:54
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class OrderSkuResponse implements Serializable {
	private static final long serialVersionUID = -1377028452955332655L;

	@ApiModelProperty("商品ID")
	private String skuId;

	@ApiModelProperty("商品名称")
	private String skuName;

	@ApiModelProperty("数量")
	private Integer num;

	@ApiModelProperty("单价")
	private BigDecimal unitPrice;

	@ApiModelProperty("总价")
	private BigDecimal totalPrice;

}
