package com.cku.restful.v1.sys.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.service.RestRemindService;
import com.cku.util.ServletUtils;

/**
 * 业务提醒功能Controller
 * 
 * @author fanhuibin
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/messagecenter")
public class RestRemindController extends BaseRestController {

	@Autowired
	private RestRemindService restRemindService;

	@RequestMapping(value = "/remind", method = RequestMethod.GET)
	@ResponseBody
	public void getRemindList(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restRemindService.getRemindList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/notify", method = RequestMethod.GET)
	@ResponseBody
	public void getNotifyList(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restRemindService.getNotifyList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/notify", method = RequestMethod.PUT)
	@ResponseBody
	public void putNotify(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restRemindService.putNotify(json);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @description: 获取业务消息和系统消息条数
	 * @author: laiguanglong
	 * @date: 2016年10月14日 下午5:05:53
	 */
	@RequestMapping(value = "/getCount", method = RequestMethod.GET)
	@ResponseBody
	public void getCount(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restRemindService.getCount();
		ServletUtils.writeResponse(response, result);
	}
}