package com.cku.restful.v1.finance.service;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentOrderService;

@Service
@Transactional(readOnly = true)
public class OADeleteService {

	@Autowired
	private PaymentCartDao paymentCartDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderService paymentOrderService;
	
	/**
	 * 
	 * @description: OA删除订单
	 * @author: laiguanglong
	 * @date: 2016年11月14日 上午11:53:19
	 */
	@Transactional(readOnly = false)
	public void deleteUnpay(String paymentState,String businessTable,String businessIds,String runningNumber){
		//已缴费的订单不允许删除
		if(!"1".equals(paymentState)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单不是未缴费状态，不允许删除");
		}
		//删除购物车
		deletePaymentCart(businessTable, businessIds);
		//删除未支付订单
		deleteUnpayPaymentOrderByRunningNum(runningNumber);
	}
	/**
	 * 
	 * @description: 删除购物车
	 * @author: laiguanglong
	 * @date: 2016年11月14日 上午11:49:20
	 */
	private void deletePaymentCart(String businessTable,String businessIds){
		PaymentCart paymentCart = paymentCartDao.getByTableAndId(businessTable, businessIds);
		if(paymentCart!=null){
			paymentCartService.removeCart(paymentCart.getId(),true);
		}
	}
	
	/**
	 * 
	 * @description: 删除未支付订单
	 * @author: laiguanglong
	 * @date: 2016年11月14日 上午11:25:24
	 */
	private void deleteUnpayPaymentOrderByRunningNum(String runningNumber){
		if(StringUtils.isBlank(runningNumber)){
			return;
		}
		PaymentOrder paymentOrder = paymentOrderDao.getOrderByRunningNum(runningNumber);
		if(paymentOrder!=null){
			if(!"1".equals(paymentOrder.getPaymentState())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单不是未缴费状态，不允许删除");
			}
			PaymentOrder example = new PaymentOrder();
			example.setId(paymentOrder.getId());
			paymentOrderService.removeOrder(example);
		}
	}
}