package com.cku.restful.v1.dog.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogOwnerChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogOwnerChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogOwnerChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.SaPaymentDetailTotalService;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.user.MemberService;
//import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.util.ZtSmsUtil;
import com.cku.restful.v1.dog.model.RestDogOwnerChange;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 犬主变更申请Service
 *
 * @author zhuoHeng
 * @version 2016-08-17
 */
@Service
@Transactional(readOnly = true)
public class RestDogOwnerChangeService {

	public static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_owner_change@All";
	public static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_owner_change@Zangao";

	public static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL0 = "dog_owner_change@All0";
	@Autowired
	private DogService dogService;
	@Autowired
	private DogOwnerChangeService dogOwnerChangeService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private DogOwnerChangeDao dogOwnerChangeDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private MemberService memberService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	private SMSRemindService smsRemindService;
	@Autowired
	private SaPaymentDetailTotalService saPaymentDetailTotalService;
	@Autowired
	private PaymentOrderService paymentOrderService;

	private void validateRefundState(DogOwnerChange po, RestDogOwnerChange vo) {

		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(po.getId(),
				po.getRunningNumber());
		if (vo == null) {
			if (!canCanceled)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		} else {
			vo.setCanEdit(canCanceled);
		}
	}

	public RESTResponse getList(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		DogOwnerChange example = new DogOwnerChange();
		// 设置分页参数
		Page<DogOwnerChange> page = new Page<DogOwnerChange>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 宠爱王国APP端需按我的申请和我的审核来展示犬主变更列表，此处通过判断参数中是否存在token来判断cabFlag参数是否有效 by zhuoHeng
		// 2016年11月10日12:13:47
		String token = request.getParameter("token");
		String cabFlag = request.getParameter("cabFlag");
		if (StringUtils.isNotBlank(token)) {
			if (StringUtils.isNotBlank(cabFlag) && "myApply".equals(cabFlag)) {
				example.setNewOwnerMemberCode(member.getMemberCode());
			} else if (StringUtils.isNotBlank(cabFlag) && "myReview".equals(cabFlag)) {
				example.setOriginOwnerMemberCode(member.getMemberCode());
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "cabFlag参数无效");
			}
		} else {
			// 设置查询条件
			example.setPaymentMemberCode(member.getMemberCode());
		}
		// end by zhuoHeng
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			Dog dog = new Dog();
			dog.setPedigreeCertifiedCode(pedigreeCertifiedCode);
			example.setDog(dog);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		// 查询并组装返回对象
		Page<DogOwnerChange> result = dogOwnerChangeService.findPage(page, example);
		List<DogOwnerChange> dogOwnerChangeList = result.getList();
		List<RestDogOwnerChange> list = new ArrayList<RestDogOwnerChange>();
		for (DogOwnerChange dogOwnerChange : dogOwnerChangeList) {
			RestDogOwnerChange vo = new RestDogOwnerChange();
			BeanUtil.copyProperties(vo, dogOwnerChange, "yyyy-MM-dd");
			vo.setPedigreeCertifiedCode(dogOwnerChange.getDog().getPedigreeCertifiedCode());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			this.validateRefundState(dogOwnerChange, vo);
			if (member.getMemberCode().equals(vo.getOriginOwnerMemberCode())) {
				vo.setIsOriginOwner("1");
			} else {
				vo.setIsOriginOwner("0");
			}
			if (StringUtils.isNotBlank(vo.getReviewer()) && vo.getReviewer().startsWith("mycku.")) {
				vo.setReviewer(vo.getReviewer().substring(6));
			}
			vo.setColorFlag(dogOwnerChange.getDog().getColorFlag());
			DogType dogType = dogTypeService.getByDogBreedCode(dogOwnerChange.getDog().getDogBreed());
			String breedCnName = "";
			if (dogType == null) {
				breedCnName = dogTypeService.getUnMapBreedCnName(dogOwnerChange.getDog().getDogBreed());
			} else {
				breedCnName = dogType.getBreedCnName();
			}
			vo.setDogBreedName(breedCnName);
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDogOwnerChange>(list, count));
	}

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {
		Member member = UserUtils.getLoginMember();
		DogOwnerChange example = new DogOwnerChange();
		example.setPaymentMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setId(ids);
		List<DogOwnerChange> dogOwnerChangeList = dogOwnerChangeService.findList(example);
		List<RestDogOwnerChange> list = new ArrayList<RestDogOwnerChange>();
		for (DogOwnerChange dogOwnerChange : dogOwnerChangeList) {
			RestDogOwnerChange vo = new RestDogOwnerChange();
			BeanUtil.copyProperties(vo, dogOwnerChange, "yyyy-MM-dd");
			vo.setPedigreeCertifiedCode(dogOwnerChange.getDog().getPedigreeCertifiedCode());
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			if (member.getMemberCode().equals(vo.getOriginOwnerMemberCode()))
				vo.setIsOriginOwner("1");
			else
				vo.setIsOriginOwner("0");

			if (StringUtils.isNotBlank(vo.getReviewer()) && vo.getReviewer().startsWith("mycku."))
				vo.setReviewer(vo.getReviewer().substring(6));

			vo.setColorFlag(dogOwnerChange.getDog().getColorFlag());
			DogType dogType = dogTypeService.getByDogBreedCode(dogOwnerChange.getDog().getDogBreed());
			String breedCnName = "";
			if (dogType == null)
				breedCnName = dogTypeService.getUnMapBreedCnName(dogOwnerChange.getDog().getDogBreed());
			else
				breedCnName = dogType.getBreedCnName();

			vo.setDogBreedName(breedCnName);
			list.add(vo);
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse get(String id) {
		DogOwnerChange dogOwnerChange = dogOwnerChangeService.get(id);
		if (dogOwnerChange == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		Member member = UserUtils.getLoginMember();
		if (!dogOwnerChange.getOriginOwnerMemberCode().equals(member.getMemberCode())
				&& !dogOwnerChange.getNewOwnerMemberCode().equals(member.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogOwnerChange vo = new RestDogOwnerChange();
		BeanUtil.copyProperties(vo, dogOwnerChange, "yyyy-MM-dd");
		vo.setPedigreeCertifiedCode(dogOwnerChange.getDog().getPedigreeCertifiedCode());
		vo.setNameCn(dogOwnerChange.getDog().getNameCn()); // 中文姓名
		vo.setNameEn(dogOwnerChange.getDog().getNameEn()); // 英文姓名
		vo.setGender(DictUtils.getDictLabel(dogOwnerChange.getDog().getGender(), "dog_gender", "")); // 性别
		vo.setBirthdate(new SimpleDateFormat("yyyy-MM-dd").format(dogOwnerChange.getDog().getBirthdate())); // 出生日期
		vo.setIdentificationFlag(dogOwnerChange.getDog().getIdentificationFlag()); // 身份识别标记
		vo.setColorFlag(dogOwnerChange.getDog().getColorFlag());// 毛色
		DogType dogType = dogTypeService.getByDogBreedCode(dogOwnerChange.getDog().getDogBreed());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dogOwnerChange.getDog().getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		vo.setDogBreedName(breedCnName);// 犬种
		Member newOwner = memberService.getByMemberCode(dogOwnerChange.getNewOwnerMemberCode());
		Member oldOwner = memberService.getByMemberCode(dogOwnerChange.getOriginOwnerMemberCode());

		vo.setProvince(newOwner.getProvince());
		vo.setCity(newOwner.getCity());
		if (StringUtils.isNotBlank(newOwner.getSafeMobile())) {
			vo.setNewOwneSafeMobile(newOwner.getSafeMobile());
		} else {
			vo.setNewOwneSafeMobile(newOwner.getMobile());
		}
		if (StringUtils.isNotBlank(oldOwner.getSafeMobile()) && oldOwner.getSafeMobile().length() == 11) {
			vo.setOriginOwneSafeMobile(
					oldOwner.getSafeMobile().substring(0, 3) + "****" + oldOwner.getSafeMobile().substring(7, 11));
		} else {
			vo.setOriginOwneSafeMobile("");
		}
		return new RESTResponse("data", vo);
	}

	/**
	 *
	 * @description: 犬主变更申请
	 * @author: laiguanglong
	 * @throws Exception
	 * @date: 2016年9月9日 下午5:04:57
	 */
	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		DogOwnerChange vo = BeanUtil.toBean(json, DogOwnerChange.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		DogOwnerChange po = buildPo(vo);
		// 业务校验
		dogOwnerChangeService.validateBusiness(po);
		// 写入业务表
		dogOwnerChangeService.save(po);
		// 写入购物车
		String businessOrderCode = IdGen.uuid();
//		PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
		String cartIds = buildCart(po,businessOrderCode);
		
//		paymentCartService.addToCart(paymentCart, "1009");
		// 宠爱王国app需要回显数据 2016年12月15日09:23:04 by zhuoHeng
		RestDogOwnerChange restModel = new RestDogOwnerChange();
		BeanUtil.copyProperties(restModel, po, "yyyy-MM-dd");
		DogType dogType = dogTypeService.getByDogBreedCode(po.getDog().getDogBreed());
		restModel.setNameEn(po.getDog().getNameEn());
		restModel.setDogBreedName(dogType.getBreedCnName());
		restModel.setPedigreeCertifiedCode(po.getDog().getPedigreeCertifiedCode());
		restModel.setIdentificationFlag(po.getDog().getIdentificationFlag());
		restModel.setColorFlag(po.getDog().getColorFlag());
//		restModel.setCartIds(paymentCart.getId());
		restModel.setCartIds(cartIds);
		return new RESTResponse("data", restModel);
	}

	/**
	 *
	 * @description: 犬主变更审核
	 * @author: laiguanglong
	 * @date: 2016年9月9日 下午5:05:30
	 */
	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		// 获取参数
		DogOwnerChange vo = BeanUtil.toBean(json, DogOwnerChange.class);
		SMSChangePassword change = (SMSChangePassword) smsRemindService.getSafeCode(vo.getId());
		if (vo.getReviewState().equals("1")) {
			if (StringUtils.isBlank(vo.getCaptcha())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码为空");
			}
			if (change == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的验证码已过期，请重新获取");
			}
			if(!(Global.isDevMode() && "6666".equals(vo.getCaptcha()))) {
				if (!vo.getCaptcha().equals(change.getKey())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的验证码输入错误，请重新输入");
				} else {
					smsRemindService.removeSafeCode(vo.getId(), vo.getCaptcha());
				}
			}
			
		}
		Member member = UserUtils.getLoginMember();
		// 判断会员是否是有效会员
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的会员身份已经过期，无法办理该业务");
		}
		DogOwnerChange vdogOwnerChange = dogOwnerChangeService.get(vo.getId());
		this.validateRefundState(vdogOwnerChange, null);
		// 犬主变更审核参数校验
		putValidateParameter(vo);
		// 业务校验
		DogOwnerChange dogOwnerChange = putValidateBusiness(vo, member);
		// 改为已审核，并填入审核人
		audit(dogOwnerChange, vo, member);
		// 处理犬主变更
		resolve(dogOwnerChange);
		Calendar calendar = Calendar.getInstance();
		Member newOwner = memberService.getByMemberCode(dogOwnerChange.getNewOwnerMemberCode());
		Member oldOwner = memberService.getByMemberCode(dogOwnerChange.getOriginOwnerMemberCode());
		if (vo.getReviewState().equals("1")) {
			if (null != newOwner.getSafeMobile() && !"".equals(newOwner.getSafeMobile())) {
				ZtSmsUtil.sendNote(
						"CKU犬主变更业务提醒，犬只（" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "）已于"
								+ calendar.get(Calendar.YEAR) + "年" + (calendar.get(Calendar.MONTH) + 1) + "月"
								+ calendar.get(Calendar.DATE) + "日" + calendar.get(Calendar.HOUR_OF_DAY) + "时"
								+ calendar.get(Calendar.MINUTE) + "分" + calendar.get(Calendar.SECOND)
								+ "秒经原犬主审核通过完成犬主变更，犬主由" + dogOwnerChange.getOriginOwnerName() + "变更为"
								+ dogOwnerChange.getNewOwnerName() + "。如有疑问，请致电协会客服400-660-7000。",
						newOwner.getSafeMobile());
			}
			if (null != oldOwner.getSafeMobile() && !"".equals(oldOwner.getSafeMobile())) {
				ZtSmsUtil.sendNote(
						"CKU犬主变更业务提醒，犬只（" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "）已于"
								+ calendar.get(Calendar.YEAR) + "年" + (calendar.get(Calendar.MONTH) + 1) + "月"
								+ calendar.get(Calendar.DATE) + "日" + calendar.get(Calendar.HOUR_OF_DAY) + "时"
								+ calendar.get(Calendar.MINUTE) + "分" + calendar.get(Calendar.SECOND)
								+ "秒经原犬主审核通过完成犬主变更，犬主由" + dogOwnerChange.getOriginOwnerName() + "变更为"
								+ dogOwnerChange.getNewOwnerName() + "。如有疑问，请致电协会客服400-660-7000。",
						oldOwner.getSafeMobile());
			}
			// TODO 财务收入确认时点 （原犬主系统审核通过）
			saPaymentDetailTotalService.financeConfirmTime(dogOwnerChange.getId(), "dog_owner_change");
		} else if (vo.getReviewState().equals("2")) {
			if (null != newOwner.getSafeMobile() && !"".equals(newOwner.getSafeMobile())) {
				ZtSmsUtil.sendNote(
						"CKU犬主变更业务提醒，犬只（" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "）已于"
								+ calendar.get(Calendar.YEAR) + "年" + (calendar.get(Calendar.MONTH) + 1) + "月"
								+ calendar.get(Calendar.DATE) + "日" + calendar.get(Calendar.HOUR_OF_DAY) + "时"
								+ calendar.get(Calendar.MINUTE) + "分" + calendar.get(Calendar.SECOND) + "秒被原犬主拒绝变更。",
						newOwner.getSafeMobile());
			}
			if (null != oldOwner.getSafeMobile() && !"".equals(oldOwner.getSafeMobile())) {
				ZtSmsUtil.sendNote(
						"CKU犬主变更业务提醒，犬只（" + dogOwnerChange.getDog().getPedigreeCertifiedCode() + "）已于"
								+ calendar.get(Calendar.YEAR) + "年" + (calendar.get(Calendar.MONTH) + 1) + "月"
								+ calendar.get(Calendar.DATE) + "日" + calendar.get(Calendar.HOUR_OF_DAY) + "时"
								+ calendar.get(Calendar.MINUTE) + "分" + calendar.get(Calendar.SECOND) + "秒被原犬主拒绝变更。",
						oldOwner.getSafeMobile());
			}

		}
		return new RESTResponse();
	}

	/**
	 * @description: 处理犬主变更
	 * @author: laiguanglong
	 * @date: 2017/2/7 15:28
	 */
	private void resolve(DogOwnerChange dogOwnerChange) {
		// 审核通过自动处理
		if ("1".equals(dogOwnerChange.getReviewState())) {
			dogOwnerChangeService.changeProcessState(dogOwnerChange);
		}
	}

	/**
	 *
	 * @description: 犬主变更审核参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 下午5:10:23
	 */
	private void putValidateParameter(DogOwnerChange vo) {
		if (StringUtils.isBlank(vo.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬主变更id为空");
		}
		if (StringUtils.isBlank(vo.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核状态为空");
		}
		if ("2".equals(vo.getReviewState()) && StringUtils.isBlank(vo.getReviewRemarks())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核备注为空");
		}
		if (!"1".equals(vo.getReviewState()) && !"2".equals(vo.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审核状态只能为1或2");
		}
	}

	/**
	 *
	 * @description: 犬主变更审核业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 下午5:13:45
	 */
	private DogOwnerChange putValidateBusiness(DogOwnerChange vo, Member member) {
		DogOwnerChange dogOwnerChange = dogOwnerChangeService.get(vo.getId());
		if (dogOwnerChange == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "数据不合法");
		}
		if (!member.getMemberCode().equals(dogOwnerChange.getOriginOwnerMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只不在您的名下");
		}
		if (!"2".equals(dogOwnerChange.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单未支付");
		}
		if ("1".equals(dogOwnerChange.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已审核通过");
		}
		if (!"0".equals(dogOwnerChange.getProcessState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已处理");
		}
		Dog dog = dogService.get(dogOwnerChange.getDogId());
		if (!dogOwnerChange.getOriginOwnerMemberCode().equals(dog.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只不在您的名下");
		}
		return dogOwnerChange;
	}

	/**
	 *
	 * @description: 原犬主审核
	 * @author: laiguanglong
	 * @date: 2016年9月9日 下午5:22:56
	 */
	private void audit(DogOwnerChange dogOwnerChange, DogOwnerChange vo, Member member) {
		dogOwnerChange.setReviewState(vo.getReviewState());
		dogOwnerChange.setReviewRemarks(vo.getReviewRemarks());
		dogOwnerChange.setReviewTime(new Date());
		dogOwnerChange.setReviewer(member.getName());
		dogOwnerChangeDao.changeStatus(dogOwnerChange);
	}

	/**
	 *
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:35:32
	 */
	private void validateParameter(DogOwnerChange vo) {
		if (StringUtils.isBlank(vo.getDogId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起，没有找到犬只信息");
		}
	}

	/**
	 *
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private DogOwnerChange buildPo(DogOwnerChange vo) {
		Member member = UserUtils.getLoginMember();
		Dog dog = dogService.get(vo.getDogId());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起，没有找到犬只信息");
		}
		DogOwnerChange po = new DogOwnerChange();
		po.setDogId(dog.getId());
		po.setOriginOwnerMemberCode(dog.getMemberCode());
		po.setOriginOwnerName(dog.getDogOwner());
		po.setOriginSecondOwnerMemberCode(dog.getSecondOwnerMemberNum());
		po.setOriginSecondOwnerName(dog.getSecondDogOwner());
		po.setNewOwnerMemberCode(member.getMemberCode());
		po.setNewOwnerName(member.getName());
		po.setPaymentMemberCode(member.getMemberCode());
		
		if (StringUtils.isNotBlank(dog.getBreederMemberCode())
				&& dog.getBreederMemberCode().equals(member.getMemberCode()) 
				&&  com.cku.oa.sys.util.DateUtils.isInXMounth(dog.getBirthdate(), 12)) {
			po.setPrice("0");
		}else {
			String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
			if ("230".equals(dog.getDogBreed())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
			}
			PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
			po.setPrice(paymentChargingItem.getPrice());
		}
		
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		po.setDog(dog);
		return po;
	}

	
	private String buildCart(DogOwnerChange po, String businessOrderCode) {
		StringBuilder cartIds = new StringBuilder();
		Dog dog = dogService.get(po.getDogId());
//		Member member = UserUtils.getLoginMember();
		// 原犬主为繁殖人，且犬只年龄小于等于1岁。提交后收费项调整为：犬主变更申请120元、犬主变更申请（减免）-120元，合计付款金额0元
		if (StringUtils.isNotBlank(dog.getBreederMemberCode())
				&& dog.getBreederMemberCode().equals(dog.getMemberCode()) 
				&& com.cku.oa.sys.util.DateUtils.isInXMounth(dog.getBirthdate(), 12)) {
			PaymentCart paymentCart = buildPaymentCartFree(po, businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1009");
			cartIds.append(paymentCart.getId());
		}
		PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
		paymentCartService.addToCart(paymentCart, "1009");
		if(cartIds.length() <= 0) {
			cartIds.append(paymentCart.getId());
		}else {
			cartIds.append(",").append(paymentCart.getId());
		}
		return cartIds.toString();
	}
	
	private PaymentCart buildPaymentCartFree(DogOwnerChange po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		Dog dog = dogService.get(po.getDogId());
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL0;
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL0;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_owner_change");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1009");
	}
	
	private PaymentCart buildPaymentCart(DogOwnerChange po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		Dog dog = dogService.get(po.getDogId());
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}

		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_owner_change");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1009");
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String dogId = request.getParameter("dogId");
		if (StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起，没有找到犬只信息");
		}
		Dog dog = dogService.get(dogId);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起，没有找到犬只信息");
		}

		JSONObject jo = new JSONObject();
		// 原犬主为繁殖人，且犬只年龄小于等于1岁。提交后收费项调整为：犬主变更申请120元、犬主变更申请（减免）-120元，合计付款金额0元
//		Member member = UserUtils.getLoginMember();
		if (StringUtils.isNotBlank(dog.getBreederMemberCode())
					&& dog.getBreederMemberCode().equals(dog.getMemberCode()) 
					&& com.cku.oa.sys.util.DateUtils.isInXMounth(dog.getBirthdate(), 12)) {
			jo.put("price", "0");
		} else {
			// 获取价格
			String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
			if ("230".equals(dog.getDogBreed())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
			}
			PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);

			jo.put("price", paymentChargingItem.getPrice());
		}
		return new RESTResponse("data", jo);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午4:28:51
	 */
	public RESTResponse orderDetail(String id) {
		DogOwnerChange dogOwnerChange = dogOwnerChangeService.get(id);
		if (dogOwnerChange == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogOwnerChange vo = new RestDogOwnerChange();
		BeanUtil.copyProperties(vo, dogOwnerChange, "yyyy-MM-dd");
		DogType dogType = dogTypeService.getByDogBreedCode(dogOwnerChange.getDog().getDogBreed());
		Map<String, String> map = new HashMap<>();
		map.put("key1", "新犬主：" + vo.getNewOwnerName());
		map.put("key2", "原犬主：" + vo.getOriginOwnerName());
		map.put("key3", "犬名：" + dogOwnerChange.getDog().getNameEn());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dogOwnerChange.getDog().getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		map.put("key4", "犬种：" + breedCnName);
		map.put("key5", "血统证书号：" + dogOwnerChange.getDog().getPedigreeCertifiedCode());
		map.put("key6", "芯片号：" + dogOwnerChange.getDog().getIdentificationFlag());
		map.put("key7", "性别：" + DictUtils.getDictLabel(dogOwnerChange.getDog().getGender(), "dog_gender", ""));
		map.put("key8", "毛色：" + dogOwnerChange.getDog().getColorFlag());
		return new RESTResponse("data", map);
	}

	
}