package com.cku.restful.v1.contest.model;

import com.cku.oa.contest.entity.ContestBreed;
import com.cku.oa.contest.entity.ContestClass;
import com.cku.oa.contest.entity.ContestExhibit;
import com.cku.oa.contest.service.ContestExhibitService;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.ShowApply;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import java.text.SimpleDateFormat;

/**
 * 赛场犬只Entity
 *
 * @author yuanshuai
 * @version 2020-10-12
 */
public class RestContestExhibit {

	private static final long serialVersionUID = 1L;

	private String exhibit_no;
	private String gender;
	private String grade;
	private String microchip_no;
	private String pedigree_code;
	private String class_code;
	private String breed_code;
	private String origin_code;
	private String pedigree_name;
	private String breed_name;
	private String class_name;
	private String gender_name;
	private String owner_name;
	private String owner_name_en;
	private String date_contest;
	private String contest_title;
	private String judge_type_name;
	private String date_birth;
	private String class_no;
	private String breed_no;
	private String group_no;
	private String contest_no;
	private String contest_event_no;
	private String boh;

	private final static SimpleDateFormat SDF_YMD = new SimpleDateFormat("yyyy-MM-dd");

	public RestContestExhibit() {
	}

	public RestContestExhibit(ContestExhibit exhibit, ShowApply showApply, ContestBreed breed, ChildShows childShows, ContestClass contestClass) {
		exhibit_no = exhibit.getExhibitNo();
		gender = showApply.getDogGender();
		grade = exhibit.getGrade();
		microchip_no = showApply.getChipCode();
		pedigree_code = exhibit.getPedigreeCode();
		class_code = contestClass.getCode();
		breed_code = breed.getCode();
		origin_code = showApply.getOtherCertified();
		pedigree_name = showApply.getDogName();
		breed_name = breed.getName();
		class_name = DictUtils.getDictLabel(ContestExhibitService.getCurrentAgeGroup(childShows.getShowCode(), showApply.getShowCode(), showApply.getAgeGroup()), "show_age_group", "");
		gender_name = "1".equals(showApply.getDogGender()) ? "公" : "母";
		owner_name = showApply.getDogOwnerNameCn();
		owner_name_en = showApply.getDogOwnerNameEn();
		date_contest = SDF_YMD.format(childShows.getStartTime());
		contest_title = childShows.getShowCode();
		judge_type_name = childShows.getContestJudgeType().contains("CACIB") ? "CACIB" : "CAC";
		date_birth = SDF_YMD.format(showApply.getDogBirthday());
		class_no = exhibit.getClassNo();
		breed_no = exhibit.getBreedNo();
		group_no = showApply.getDogBreedGroup();
		contest_no = exhibit.getContestNo();
		contest_event_no = exhibit.getContestEventNo();
		boh = exhibit.getBoh();
	}


	public String getExhibit_no() {
		return exhibit_no;
	}

	public void setExhibit_no(String exhibit_no) {
		this.exhibit_no = exhibit_no;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getMicrochip_no() {
		return microchip_no;
	}

	public void setMicrochip_no(String microchip_no) {
		this.microchip_no = microchip_no;
	}

	public String getPedigree_code() {
		return pedigree_code;
	}

	public void setPedigree_code(String pedigree_code) {
		this.pedigree_code = pedigree_code;
	}

	public String getClass_code() {
		return class_code;
	}

	public void setClass_code(String class_code) {
		this.class_code = class_code;
	}

	public String getBreed_code() {
		return breed_code;
	}

	public void setBreed_code(String breed_code) {
		this.breed_code = breed_code;
	}

	public String getOrigin_code() {
		return origin_code;
	}

	public void setOrigin_code(String origin_code) {
		this.origin_code = origin_code;
	}

	public String getPedigree_name() {
		return pedigree_name;
	}

	public void setPedigree_name(String pedigree_name) {
		this.pedigree_name = pedigree_name;
	}

	public String getBreed_name() {
		return breed_name;
	}

	public void setBreed_name(String breed_name) {
		this.breed_name = breed_name;
	}

	public String getClass_name() {
		return class_name;
	}

	public void setClass_name(String class_name) {
		this.class_name = class_name;
	}

	public String getGender_name() {
		return gender_name;
	}

	public void setGender_name(String gender_name) {
		this.gender_name = gender_name;
	}

	public String getOwner_name() {
		return owner_name;
	}

	public void setOwner_name(String owner_name) {
		this.owner_name = owner_name;
	}

	public String getOwner_name_en() {
		return owner_name_en;
	}

	public void setOwner_name_en(String owner_name_en) {
		this.owner_name_en = owner_name_en;
	}

	public String getDate_contest() {
		return date_contest;
	}

	public void setDate_contest(String date_contest) {
		this.date_contest = date_contest;
	}

	public String getContest_title() {
		return contest_title;
	}

	public void setContest_title(String contest_title) {
		this.contest_title = contest_title;
	}

	public String getJudge_type_name() {
		return judge_type_name;
	}

	public void setJudge_type_name(String judge_type_name) {
		this.judge_type_name = judge_type_name;
	}

	public String getDate_birth() {
		return date_birth;
	}

	public void setDate_birth(String date_birth) {
		this.date_birth = date_birth;
	}

	public String getClass_no() {
		return class_no;
	}

	public void setClass_no(String class_no) {
		this.class_no = class_no;
	}

	public String getBreed_no() {
		return breed_no;
	}

	public void setBreed_no(String breed_no) {
		this.breed_no = breed_no;
	}

	public String getGroup_no() {
		return group_no;
	}

	public void setGroup_no(String group_no) {
		this.group_no = group_no;
	}

	public String getContest_no() {
		return contest_no;
	}

	public void setContest_no(String contest_no) {
		this.contest_no = contest_no;
	}

	public String getContest_event_no() {
		return contest_event_no;
	}

	public void setContest_event_no(String contest_event_no) {
		this.contest_event_no = contest_event_no;
	}

	public String getBoh() {
		return boh;
	}

	public void setBoh(String boh) {
		this.boh = boh;
	}
}