package com.cku.restful.v1.breeder.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.breeder.service.RestStudDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @description: 种犬
 * @author: laiguanglong
 * @date: 2017/10/9 9:56
 */
@Controller
@RequestMapping(value = "/api/v1/breeder/studDog")
public class RestStudDogController extends BaseRestController {

    @Autowired
    private RestStudDogService restStudDogService;

    /**
     * @description: 我的爱宠，种公犬只列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/getMyStudDog", method = RequestMethod.GET)
    public void getMyStudDog(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.getMyStudDog(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 保存种公信息并上架接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "", method = RequestMethod.POST)
    public void post(@RequestBody String json, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.post(json);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 保存种公信息并上架接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "", method = RequestMethod.PUT)
    public void put(@RequestBody String json, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.put(json);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 种犬状态变更接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/studDogState", method = RequestMethod.PUT)
    public void studDogState(@RequestBody String json, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.studDogState(json);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/label", method = RequestMethod.GET)
    public void label(HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.label();
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 公犬犬种列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/maleDogBreed", method = RequestMethod.GET)
    public void maleDogBreed(HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.maleDogBreed();
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 根据犬种获取我的公犬列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @RequestMapping(value = "/getMaleDogByDogBreed", method = RequestMethod.GET)
    public void getMaleDogByDogBreed(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.getMaleDogByDogBreed(request);
        ServletUtils.writeResponse(response, result);
    }

}