package com.cku.restful.v1.banner.vo;

import java.io.Serializable;

import javax.validation.constraints.Min;

import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class RestBannerListRequest implements Serializable {
	/**
	* 
	*/
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("页码")
	@Min(value = 0, message = "pageNo需大于0")
	private int pageNo;

	@ApiModelProperty("条数")
	@Min(value = 0, message = "pageSize需大于0")
	private int pageSize;

	@ApiModelProperty("广告位置 1:强力推荐 2:热门犬舍 3:犬舍联盟")
	@NotBlank(message = "bannerPlace不能为空")
	private String bannerPlace;

}
