package com.cku.partner.club.web;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_RENEWALS;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogChipMemberLock;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogChipMemberLockService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.dao.PrintLogsDao;
import com.cku.oa.sys.dao.SysOrgPrintDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.PrintLogs;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.entity.user.IEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.partner.club.service.ClubDogChipService;
import com.cku.partner.club.service.ClubMemberService;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 合作俱乐部 user chaixueteng 2016年10月8日
 */
@Controller
@RequestMapping(value = "/partner/clubMember")
public class clubMemberController extends BaseController {
	@Autowired
	public MemberService memberService;
	@Autowired
	public ClubMemberService clubMemberService;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public KennelService kennelService;
	@Autowired
	public DogService dogService;
	@Autowired
	public DogChipService dogChipService;
	@Autowired
	public ClubDogChipService clubDogChipService;
	@Autowired
	public PaymentOrderService paymentOrderService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public KennelDao kennelDao;
	@Autowired
	public OrgService orgService;
	@Autowired
	public SysOrgPrintDao sysOrgPrintDao;
	@Autowired
	public DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	public RestIDCardService restIDCardService;
	@Autowired
	public DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private SysCouponDao sysCouponDao;
	@Autowired
	private SMSRemindService smsRemindService;
	@Autowired
	public OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	public RestDogChipService restDogChipService;
	@Autowired
	private PrintLogsDao printLogsDao;
	@Autowired
	private DogChipMemberLockService dogChipMemberLockService;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private SamplingService samplingService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	@ModelAttribute
	public Member get(@RequestParam(required = false) String id) {
		Member entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = memberService.get(id);
		}
		if (entity == null) {
			entity = new Member();
		}
		return entity;
	}

	/**
	 * 根据会员号查询会员信息
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:00:45
	 */
	@ResponseBody
	@RequestMapping(value = "search")
	public Object search(String memberCode, String checkSingle) {
		Map<String, String> map = new HashMap<String, String>();
		if (StringUtils.isNotBlank(memberCode)) {
			Org org = (Org) UserUtils.getSession().getAttribute("org");
			if (!StringUtils.isEmpty(checkSingle)) {
				// 单犬种查询会员
				if ("singleTypeClub".equals(org.getOrgType()) && !(memberCode.equals(org.getAdminCode()))) {
					Member sigleMember = memberService.singleMember(memberCode, org.getUser().getLoginName());
					if (sigleMember == null) {
						map.put("rc", "1");
						map.put("msg", "不是该单犬种俱乐部名下登记会员，无法在该机构办理业务");
						return map;
					}
				}
			}
			Member member = memberService.getByMemberCode(memberCode);
			if (member != null) {
				if (!MemberUtil.isActiveMember(member)) {
					map.put("rc", "1");
					map.put("msg", "新犬主会员无效!");
				} else {
					map.put("rc", "0");
					map.put("name", member.getName());
				}
			} else {
				map.put("rc", "1");
				map.put("msg", "查无此会员信息!");
			}
		}
		return map;
	}

	/**
	 * 犬舍中文重复校验
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "nameCheck")
	@ResponseBody
	public ResultDto<Boolean> nameCheck(HttpServletRequest request, HttpServletResponse response) {
		String kennelName = request.getParameter("name");
		String memberCode = request.getParameter("memberCode");
		ResultDto<Boolean> result = ResultDto.success(Boolean.TRUE);
		try {
			kennelService.nameCnCheck(kennelName, memberCode);
		} catch (Exception ex) {
			result = ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return result;
	}

	/**
	 * 犬舍英文重复校验
	 *
	 * @Author chaixuetengl
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "nameEnCheck")
	@ResponseBody
	public ResultDto<Boolean> nameEnCheck(HttpServletRequest request, HttpServletResponse response) {
		String kennelNameEn = request.getParameter("nameEn");
		Boolean isValidBlank = Boolean.valueOf(request.getParameter("isValidBlank"));
		String memberCode = request.getParameter("memberCode");
		ResultDto<Boolean> result = ResultDto.success(Boolean.TRUE);
		;
		try {
			kennelService.nameEnCheck(kennelNameEn, isValidBlank, memberCode);
		} catch (Exception ex) {
			result = ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return result;
	}

	/**
	 * 证件号重复校验
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "cardNoCheck")
	@ResponseBody
	public String cardNoCheck(HttpServletRequest request, HttpServletResponse response) {
		String param = request.getParameter("param");
		String memberSite = request.getParameter("memberSite");
		return memberService.cardNoCheck(param, memberSite);
	}

	/**
	 * 邮箱重复校验
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "emailCheck")
	@ResponseBody
	public String emailCheck(HttpServletRequest request, HttpServletResponse response) {
		String param = request.getParameter("param");
		String id = request.getParameter("id");
		return memberService.emailCheck(param, id, null);
	}

	/**
	 * 手机号重复校验
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "mobileCheck")
	@ResponseBody
	public String mobileCheck(HttpServletRequest request, HttpServletResponse response) {
		String param = request.getParameter("param");
		String id = request.getParameter("id");
		return memberService.mobileCheck(param, id, null);
	}

	/**
	 * 会员录入
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "form")
	public String form(Member member, Model model) {
		model.addAttribute("date", new Date());
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		model.addAttribute("orgSite", org.getOrgSite());
		List<SysCoupon> couponList = sysCouponDao.getCouponList(org.getMemberCode(), "2", "member");
		model.addAttribute("couponNum", couponList.size());
		String loginName = org.getUser().getLoginName();
		model.addAttribute("loginName", loginName);
		model.addAttribute("memberCouponNum", sysCouponDao.getCouponList(org.getMemberCode(), "", "member").size());
		model.addAttribute("member", member);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(member.getProvince()));
		model.addAttribute("overdueNum", sysCouponDao.getCouponList(org.getMemberCode(), "1", "member").size());
		model.addAttribute("availableNum", sysCouponDao.getCouponList(org.getMemberCode(), "0", "member").size());
		return "partner/club/memberAdd";
	}

	@RequestMapping(value = "dogAllNestApply")
	public String dogAllNestApply(Member member, Model model) {
		return "partner/club/dogAllNestForm";
	}

	/**
	 * 过期会员续费
	 *
	 * @Author
	 * @2016年10月8日下午6:24:28
	 */

	@RequestMapping(value = "reform")
	public String reform(Model model, String memberCode) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		List<SysCoupon> couponList = sysCouponDao.getCouponList(org.getMemberCode(), "2", "member");
		String loginName = org.getUser().getLoginName();
		model.addAttribute("loginName", loginName);
		model.addAttribute("org", org);
		model.addAttribute("memberCode", memberCode);
		model.addAttribute("couponNum", couponList.size());
		model.addAttribute("memberCouponNum", sysCouponDao.getCouponList(org.getMemberCode(), "", "member").size());
		model.addAttribute("overdueNum", sysCouponDao.getCouponList(org.getMemberCode(), "1", "member").size());
		model.addAttribute("availableNum", sysCouponDao.getCouponList(org.getMemberCode(), "0", "member").size());
		return "partner/club/memberReForm";
	}

	/**
	 * 查询会员信息
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "getMemberMessage")
	@ResponseBody
	public Object getMemberMessage(HttpServletRequest request, HttpServletResponse response, Model model,
			RedirectAttributes redirectAttributes) {
		Map<String, String> map = new HashMap<String, String>();
		String memberCodeMobile = request.getParameter("memberCodeMobile");
		try {
			map = clubMemberService.getMemberMessage(memberCodeMobile);
			map.put("checkMemberCodeMobile", memberCodeMobile);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 会员信息修改页
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "edit")
	public String edit(Member member, Model model) {
		model.addAttribute("member", member);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(member.getProvince()));
		return "partner/club/memberEdit";
	}

	/**
	 * @Description：犬舍信息录入页
	 * @author: yuanshuai
	 * @date: 2018/7/27 15:30
	 */
	@RequestMapping(value = "addKennel")
	public String addKennel(Member member, Model model) {
		model.addAttribute("member", member);
		return "partner/club/kennelFormAdd";
	}

	/**
	 * 犬舍修改
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "editKennel")
	public String editKennel(Member member, Model model) {
		String memberCode = member.getMemberCode();
		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
		model.addAttribute("kennel", kennel);
		return "partner/club/kennelFormEdit";
	}

	/**
	 * 修改犬舍信息
	 *
	 * @Author chaixueteng
	 * @2016年10月18日下午4:19:54
	 */
	@RequestMapping(value = "kennelEdit")
	public String kennelEdit(Kennel kennel) {
		if (!kennel.getName().endsWith("犬舍")) {
			kennel.setName(kennel.getName() + "犬舍");
		}
		kennel.preUpdate();
		kennelDao.update(kennel);
		return "redirect:/partner/clubMember/list?repage";
	}

	/**
	 * 新生犬录入(未预约入口)
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "validBirth")
	public String validBirth(HttpServletRequest request, HttpServletResponse response, Model model,
			RedirectAttributes redirectAttributes) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		String birthCode = request.getParameter("birthCode").trim();
		DogBirthCertificate birthCerRegCode = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if (birthCerRegCode == null) {
			addMessage(redirectAttributes, "查询登记卡失败:登记卡编号不正确!");
			return "redirect:/partner/clubMember/dogList?repage";
		}

		// 芯片锁定
		DogChipMemberLock dogChipMemberLock = dogChipMemberLockService
				.getByChipCode(birthCerRegCode.getIdentificationFlag(), "1");
		if (dogChipMemberLock != null && !StringUtils.isBlank(dogChipMemberLock.getId())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,
					"该犬只已被锁定，只可于宠爱王国APP进行操作，过户给" + dogChipMemberLock.getMemberCode() + "会员");
		}

		if (StringUtils.isNotBlank(birthCerRegCode.getPedigreeCertified())) {
			addMessage(redirectAttributes, "查询登记卡失败:该登记卡已有证书!");
			return "redirect:/partner/clubMember/dogList?repage";
		} else if (StringUtils.isNotBlank(birthCerRegCode.getAddUser())) {
			if (loginName.equals(birthCerRegCode.getAddUser())) {
				addMessage(redirectAttributes, "查询登记卡失败:该登记卡已预约本机构!");
				return "redirect:/partner/clubMember/dogList?birthCerRegCode=" + birthCode;
			} else {
				addMessage(redirectAttributes, "查询登记卡失败:该登记卡已预约其他机构!");
				return "redirect:/partner/clubMember/dogList?repage";
			}
		}
		// 判断犬种是否有效
		if ("singleTypeClub".equals(org.getOrgType())
				&& !orgDogTypeLimitService.checkSingleOrgDogTypeCode(org.getId(), birthCerRegCode.getDogBreed())) {
			addMessage(redirectAttributes, "俱乐部不经营此犬种，如有疑问，请联系CKU。");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		DogChip dogChip = dogChipService.getByBirthCode(birthCode);
		if (dogChip != null && StringUtils.isNotBlank(dogChip.getIsAll()) && "1".equals(dogChip.getIsAll())) {
			if (!"2".equals(dogChip.getPaymentState())) {
				addMessage(redirectAttributes, "查询登记卡失败:该登记卡未缴费!");
				return "redirect:/partner/clubMember/dogList?repage";
			} else {
				birthCerRegCode
						.setDogBreed(dogTypeService.getByDogBreedCode(birthCerRegCode.getDogBreed()).getBreedCnName());
				model.addAttribute("dogBirthCertificate", birthCerRegCode);
				DogActivation dogActivation = dogActivationService.getByBirthCode(birthCode);
				if ((StringUtils.isNotBlank(birthCerRegCode.getActivitionState())
						&& birthCerRegCode.getActivitionState().equals("1")) || dogActivation != null) {
					model.addAttribute("birthCode", dogChip.getBirthCode());
					model.addAttribute("breederMemberCode", birthCerRegCode.getBreederMemberCode());
					return "partner/club/dogChipAllNestForm";
				} else {
					return "partner/dogActivation/dogActivationAllNestForm";
				}
			}
		}
		if (birthCerRegCode.getCreateDate().getTime() > DogBirthCertificateService.DOG_ACTIVATION_MILLIS
				&& !"1".equals(birthCerRegCode.getActivitionState())) {
			addMessage(redirectAttributes, "查询登记卡失败:该登记卡尚未办理激活 !");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		model.addAttribute("birthcode", birthCode);
		// 新出生纸申请
		if (StringUtils.isNotBlank(birthCerRegCode.getIdentificationFlag())) {
			return "partner/club/dogChipNewForm";
		} else {
			addMessage(redirectAttributes, "查询登记卡失败:登记卡信息不正确!");
			return "redirect:/partner/clubMember/dogList";
		}
	}

	/**
	 * 新生犬录入
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "dogChipForm")
	public String dogChipForm(DogChip dogChip, Model model, RedirectAttributes redirectAttributes) {
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(dogChip.getBirthCode());
		if (StringUtils.isNotBlank(birth.getPedigreeCertified())) {
			addMessage(redirectAttributes, "查询出生纸失败:该出生纸已有证书!");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		model.addAttribute("dogChip", dogChip);
		model.addAttribute("birthcode", dogChip.getBirthCode());
		return "partner/club/dogChipNewForm";
	}

	/**
	 * 新生犬办理入口
	 *
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "dogChipHandleForm")
	public String dogChipHandleForm(DogChip dogChip, Model model, RedirectAttributes redirectAttributes) {
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(dogChip.getBirthCode());
		DogChip validDogChip = dogChipService.getByBirthCode(dogChip.getBirthCode());
		// 合作机构办理，金质证书不在生成证书号
		if (clubMemberService.validGoldenPedigreeCertified(validDogChip.getBirthCode(),validDogChip.getHaddleWay())) {
			addMessage(redirectAttributes, "暂不支持金质证书办理，请前往DNA留存进行采样包绑定!");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		// 判断新旧出生纸
		if (StringUtils.isNotBlank(birth.getPedigreeCertified())) {
			addMessage(redirectAttributes, "查询出生纸失败:该出生纸已有证书!");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		model.addAttribute("dogChip", dogChip);
		model.addAttribute("birthcode", dogChip.getBirthCode());
		if (StringUtils.isNotBlank(dogChip.getIsAll()) && "1".equals(dogChip.getIsAll())) {
			birth.setDogBreed(dogTypeService.getByDogBreedCode(birth.getDogBreed()).getBreedCnName());
			model.addAttribute("dogBirthCertificate", birth);
			DogActivation dogActivation = dogActivationService.getByBirthCode(dogChip.getBirthCode());
			if ((StringUtils.isNotBlank(birth.getActivitionState()) && birth.getActivitionState().equals("1"))
					|| dogActivation != null) {
				model.addAttribute("birthCode", dogChip.getBirthCode());
				model.addAttribute("breederMemberCode", birth.getBreederMemberCode());
				return "partner/club/dogChipAllNestForm";
			} else {
				return "partner/dogActivation/dogActivationAllNestForm";
			}

		} else {
			if (StringUtils.isNotBlank(birth.getIdentificationFlag())) {// 有芯片号的新出生纸
				return "partner/club/dogChipHandlerNewForm";
			} else {// 无芯片的旧出生纸 需要录芯片及新生犬主等信息
				return "partner/club/dogChipHandlerForm";
			}
		}
	}

	/**
	 * 保存会员
	 *
	 * @Author chaixueteng
	 * @2016年10月9日下午2:36:45
	 */
	@RequestMapping(value = "save", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<String> save(Member member, Model model, RedirectAttributes redirectAttributes,
			HttpServletRequest request) {
		ResultDto<String> result = ResultDto.success("ok");
		try {
			member.setName(StringEscapeUtils.unescapeHtml4(member.getName()));
			member.setMemberType(IEnum.getMessage(MemberCardTypeEnum.class, member.getMemberCardType()));
			if (member.getIsNewRecord()) {// 新增的验证实名
				int flag = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),
						member.getMemberSite(), true);
				if (flag != 1) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "实名认证失败，请重试!");
				} else {
					member.setAuthentication("1");
				}
				clubMemberService.save(member);
				result.setMsg("创建成功");
			} else {
				clubMemberService.save(member);
				result.setMsg("保存成功");
			}
		} catch (Exception e) {
			e.printStackTrace();
			result = ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
		}
		return result;
	}

	@RequestMapping(value = "saveMemberCaptcha", method = RequestMethod.POST)
	public String saveMemberCaptcha(Member member, String captcha, RedirectAttributes redirectAttributes,
			HttpServletRequest request, Model model) {
		try {
			if (member == null || StringUtils.isBlank(member.getId()) || StringUtils.isBlank(member.getMobile())) {
				addMessage(redirectAttributes, "会员信息有误，请重试");
				return "redirect:/partner/clubMember/list?repage";
			}
			String mobile = StringUtils.isBlank(member.getSafeMobile()) ? member.getMobile() : member.getSafeMobile();
			if (smsRemindService.checkVerifyCode(mobile, captcha)) {
				return clubMemberService.saveMemberCaptcha(member, model);
			} else {
				addMessage(redirectAttributes, "验证码错误，请重试");
				return "redirect:/partner/clubMember/list?repage";
			}
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:/partner/clubMember/list?repage";
		}
	}

	/**
	 * @Description： 保存犬舍
	 *
	 * @author: yuanshuai
	 * @date: 2018/7/27 14:36
	 */
	@RequestMapping(value = "saveKennel", method = RequestMethod.POST)
	public String saveKennel(Member member, RedirectAttributes redirectAttributes) {
		try {
			clubMemberService.saveKennel(member);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:/partner/clubMember/list?repage";
	}

	/**
	 * 会员列表
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午3:02:08
	 */
	@RequestMapping(value = { "list", "" })
	public String list(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		member.setRegistrant(loginName);
		Page<Member> page = memberService.findPage(new Page<Member>(request, response), member);
		model.addAttribute("date", new Date());
		model.addAttribute("page", page);
		return "partner/club/memberList";
	}

	/**
	 * 新生犬管理
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午3:32:48
	 */
	@RequestMapping(value = "dogList")
	public String dogList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		Page<DogBirthCertificate> page = dogBirthCertificateService
				.findClubPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		SysOrgPrint sysOrgPrint = sysOrgPrintDao.getByOrgId(org.getId());
		String restPrintCode = sysOrgPrint.getRestPrintCode();
		model.addAttribute("restPrintCode", restPrintCode);
		return "partner/club/dogBirthCertificateList";
	}

	/**
	 * 整窝申请
	 *
	 * @param dogBirthCertificate
	 * @param request
	 * @param response
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "dogAllNestList")
	public String dogAllNestList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		Page<DogBirthCertificate> page = dogBirthCertificateService
				.dogAllNestList(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		SysOrgPrint sysOrgPrint = sysOrgPrintDao.getByOrgId(org.getId());
		String restPrintCode = sysOrgPrint.getRestPrintCode();
		model.addAttribute("restPrintCode", restPrintCode);
		return "partner/club/dogChipAllNestList";
	}

	/**
	 * 新生犬管理
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午3:32:48
	 */
	@RequestMapping(value = "dogOldList")
	public String dogOldList(DogBirthCertificate dogBirthCertificate, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		dogBirthCertificate.setAddUser(loginName);
		dogBirthCertificate.setTempMemberCode(org.getMemberCode());
		Page<DogBirthCertificate> page = dogBirthCertificateService
				.findClubOldPage(new Page<DogBirthCertificate>(request, response), dogBirthCertificate);
		model.addAttribute("page", page);
		return "partner/club/dogBirthCertificateOldList";
	}

	@RequestMapping(value = "dogChipInjectList")
	public String dogChipInjectList(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		paymentOrder.setCreateBy(org.getUser());
		paymentOrder.setPaymentState("1");
		paymentOrder.setDelFlag("0");
		Page<PaymentOrder> page = paymentOrderService.dogChipInjectList(new Page<PaymentOrder>(request, response),
				paymentOrder);
		model.addAttribute("page", page);
		return "partner/club/dogChipInjectList";
	}

	/**
	 *
	 * 删除会员(逻辑)
	 *
	 * @Author chaixueteng
	 * @2016年10月14日下午2:01:45
	 */
	@RequestMapping(value = "delete")
	public String delete(Member member, RedirectAttributes redirectAttributes) {
		try {
			clubMemberService.delete(member);
			addMessage(redirectAttributes, "删除用户会员成功");
		} catch (ZAException e) {
			e.printStackTrace();
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:/partner/clubMember/list?repage";
	}

	/**
	 * 新生犬删除
	 *
	 * @Author chaixueteng
	 * @2016年10月24日下午6:03:32
	 */
	@RequestMapping(value = "deleteBirth")
	public String deleteBirth(String birthId, RedirectAttributes redirectAttributes) {
		try {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(birthId);
			DogChip dogChip = dogChipService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
			dogChipService.delete(dogChip);
			// 注释重复删除订单
			// String runningNumber = dogChip.getRunningNumber();
			// if(StringUtils.isNotBlank(runningNumber)){
			// clubMemberService.deleteUnPayOrder(runningNumber);
			// }

			addMessage(redirectAttributes, "删除新生犬成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除新生犬失败:" + e.getMessage());
		}
		return "redirect:/partner/clubMember/dogOldList?repage";
	}

	/**
	 * 根据出生纸和标识码查询
	 *
	 * @Author chaixueteng
	 * @2016年10月12日下午4:26:03
	 */
	@RequestMapping(value = "searchChipMessage")
	@ResponseBody
	public Object searchChipMessage(HttpServletRequest request, HttpServletResponse response, Model model) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String snCode = request.getParameter("snCode");
			map = clubMemberService.searchChipMessage(birthCode.trim(), snCode.trim());
			DogActivation dogActivation = dogActivationService.getByBirthCode(birthCode);
			if (dogActivation != null) {
				map.put("frontPic", dogActivation.getFrontPic());
				map.put("sidePic", dogActivation.getSidePic());
				map.put("backPic", dogActivation.getBackPic());
			} else {
				map.put("frontPic", "");
				map.put("sidePic", "");
				map.put("backPic", "");
			}
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 根据出生纸和芯片号查询
	 *
	 * @Author chaixueteng(新出生)
	 * @2016年10月12日下午4:26:03
	 */
	@RequestMapping(value = "searchMessage")
	@ResponseBody
	public Object searchMessage(HttpServletRequest request, Model model, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String chipCode = request.getParameter("chipCode");
			map = clubMemberService.searchMessage(birthCode.trim(), chipCode.trim());
			DogActivation dogActivation = dogActivationService.getByBirthCode(birthCode);
			if (dogActivation != null) {
				map.put("frontPic", dogActivation.getFrontPic());
				map.put("sidePic", dogActivation.getSidePic());
				map.put("backPic", dogActivation.getBackPic());
			} else {
				map.put("frontPic", "");
				map.put("sidePic", "");
				map.put("backPic", "");
			}
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 整窝办理查询犬只信息
	 *
	 * @param request
	 * @param model
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "searchAllNestChipMessage")
	@ResponseBody
	public Object searchAllNestChipMessage(HttpServletRequest request, Model model, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String snCode = request.getParameter("snCode");
			map = clubMemberService.searchAllNestMessage(birthCode.trim(), snCode.trim());
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequestMapping(value = "searchDogChipMessage")
	@ResponseBody
	public Object searchDogChipMessage(HttpServletRequest request, Model model, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String snCode = request.getParameter("snCode");
			map = clubMemberService.searchDogChipMessage(birthCode.trim(), snCode.trim());
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 录入芯片
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "add")
	public String add(HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
		String identificationFlag = request.getParameter("xinpian2");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String memberCode = request.getParameter("memberCode");
		String dna = request.getParameter("dna");
		String parent = request.getParameter("parent");
		String callName = request.getParameter("callName");
		String chipInject = request.getParameter("chipInject");
		String stickerFlag = request.getParameter("stickerFlag");
		try {
			clubMemberService.add(birthCerRegCode, identificationFlag, memberCode, dna, parent, callName, chipInject,
					stickerFlag);
		} catch (Exception e) {
			logger.warn("录入芯片失败", e);
			addMessage(redirectAttributes, "录入芯片失败:" + e.getMessage());
		}
		return "redirect:/partner/clubMember/dogOldList?repage";
	}

	/**
	 * 预约(旧出生纸办理)
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "addOldMemberCenter")
	public String addOldMemberCenter(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes, Model model) {
		String identificationFlag = request.getParameter("xinpian2");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String callName = request.getParameter("callName");
		String chipInject = request.getParameter("chipInject");
		String stickerFlag = request.getParameter("stickerFlag");
		try {
			clubMemberService.addOldMemberCenter(birthCerRegCode, identificationFlag, callName, chipInject, model,
					stickerFlag);
		} catch (Exception e) {
			logger.warn("录入芯片失败", e);
			addMessage(redirectAttributes, "录入芯片失败:" + e.getMessage());
		}
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			return "partner/sys/dogChipPayPage";
		} else {
			return "redirect:/partner/clubMember/dogList?repage";
		}
	}

	/**
	 * 预约(新出生纸办理)
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "addMemberCenter")
	public String addMemberCenter(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes, Model model) {
		String identificationFlag = request.getParameter("chipCode");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String callName = request.getParameter("callName");
		String chipInject = request.getParameter("chipInject");
		String stickerFlag = request.getParameter("stickerFlag");
		String samplingCode = request.getParameter("samplingCode");
		try {
			clubMemberService.addMemberCenter(birthCerRegCode, identificationFlag, callName, chipInject, model,
					stickerFlag, samplingCode);
		} catch (Exception e) {
			logger.warn("办理失败", e);
			addMessage(redirectAttributes, "办理失败:" + e.getMessage());
		}
		// 地方俱乐部代打芯片
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			return "redirect:/partner/clubMember/dogChipInjectList?repage";
		} else {
			return "redirect:/partner/clubMember/dogList?repage";
		}
	}

	@RequestMapping(value = "addAllNestChip")
	public String addAllNestChip(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes, Model model) {
		String identificationFlag = request.getParameter("identificationFlag");
		String birthCerRegCode = request.getParameter("birthCerRegCode");
		String callName = request.getParameter("callName");
		String chipInject = request.getParameter("chipInject");
		String stickerFlag = request.getParameter("stickerFlag");
		String dna = request.getParameter("dna");
		String memberCode = request.getParameter("memberCode");
		try {
			clubMemberService.addAllNestChip(birthCerRegCode, identificationFlag, callName, chipInject, model,
					stickerFlag, dna, memberCode);
		} catch (Exception e) {
			logger.warn("办理失败", e);
			addMessage(redirectAttributes, "办理失败:" + e.getMessage());
		}
		// 地方俱乐部代打芯片
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			return "redirect:/partner/clubMember/dogChipInjectList?repage";
		} else {
			return "redirect:/partner/clubMember/dogList?repage";
		}
	}

	/**
	 * 整窝办理保存新犬主、芯片号
	 *
	 * @param request
	 * @param response
	 * @param redirectAttributes
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "saveMemberIdentificationFlag")
	public String saveMemberIdentificationFlag(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes, Model model) {
		String identificationFlag = request.getParameter("identificationFlag");
		String birthCode = request.getParameter("birthCode");
		String memberCode = request.getParameter("memberCode");
		String snCode = request.getParameter("snCode");
		String callName = request.getParameter("callName");
		String classSticker = request.getParameter("classSticker");
		try {
			clubMemberService.saveMemberIdentificationFlag(birthCode, identificationFlag, memberCode, snCode, callName,
					classSticker, model);
		} catch (Exception e) {
			logger.warn("保存信息办理失败", e);
			addMessage(redirectAttributes, "办理失败:" + e.getMessage());
		}
		return "redirect:/partner/clubMember/dogAllNestList?repage";
	}

	/**
	 * 整窝办理生成血统证书
	 *
	 * @param request
	 * @param response
	 * @param redirectAttributes
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "saveAllNest")
	public String saveAllNest(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes, Model model) {
		String birthCode = request.getParameter("birthCode");
		String frontPic = request.getParameter("frontPic");
		String sidePic = request.getParameter("sidePic");
		String backPic = request.getParameter("backPic");
		try {
			clubMemberService.saveAllNest(frontPic, sidePic, backPic, birthCode, model);
		} catch (Exception e) {
			logger.warn("保存信息办理失败", e);
			addMessage(redirectAttributes, "办理失败:" + e.getMessage());
			return "redirect:/partner/clubMember/dogAllNestList?repage";
		}
		return "partner/club/dogChipAllNestForm";
	}

	/**
	 * 新出生纸确认(新版出生纸提交)
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "addNew")
	public String addNew(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		String birthCode = request.getParameter("birthCode");
		String chipCode = request.getParameter("chipCode");
		String dna = request.getParameter("dna");
		String parent = request.getParameter("parent");
		String memberCode = request.getParameter("memberCode");
		String callName = request.getParameter("callName");
		String chipInject = request.getParameter("chipInject");
		String stickerFlag = request.getParameter("stickerFlag");
		String samplingCode = request.getParameter("samplingCode");
		try {
			clubMemberService.addNew(birthCode, chipCode, dna, parent, memberCode, callName, chipInject, stickerFlag,
					samplingCode);
		} catch (Exception e) {
			logger.warn("确认失败", e);
			addMessage(redirectAttributes, "确认失败:" + e.getMessage());
			return "redirect:/partner/clubMember/dogOldList?repage";
		}
		return "redirect:/partner/clubMember/dogOldList?repage";
	}

	/**
	 * 新生犬缴费
	 *
	 * @Author chaixueteng
	 * @2016年10月13日下午4:05:44
	 */
	@RequestMapping(value = "payment")
	public String payment(String birthid, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		Org org2 = orgService.get(org.getId());
		String orderId;
		List<PaymentOrderDetail> list;
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.get(birthid);
		String birthCerRegCode = dogBirthCertificate.getBirthCerRegCode();
		DogChip dogChip = dogChipService.getByBirthCode(birthCerRegCode);
		String runningNumber = dogChip.getRunningNumber();
		PaymentOrder order = paymentOrderService.getByOrderCode(runningNumber);
		if (order == null) {// 订单不存在或者已经被删除了
			list = clubDogChipService.addToOrder(dogBirthCertificate, dogChip);
			String orderCode = list.get(0).getOrderCode();
			PaymentOrder byOrderCode = paymentOrderService.getByOrderCode(orderCode);
			orderId = byOrderCode.getId();
		} else {
			orderId = order.getId();
			list = paymentOrderDetailDao.getOrderByRunningNum(runningNumber, dogBirthCertificate.getTempMemberCode());
		}
		model.addAttribute("orderId", orderId);
		model.addAttribute("paymentOrderDetail", list);
		model.addAttribute("org", org2);
		return "partner/sys/dogChipPayPage";
	}

	@RequestMapping(value = "paymentDogChipInject")
	public String paymentDogChipInject(String orderId, String memberCode, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String id = org.getId();
		Org org2 = orgService.get(id);
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		List<PaymentOrderDetail> list = paymentOrderDetailDao.getOrderByRunningNum(paymentOrder.getOrderCode(),
				memberCode);
		model.addAttribute("orderId", paymentOrder.getId());
		model.addAttribute("paymentOrderDetail", list);
		model.addAttribute("org", org2);
		return "partner/sys/dogChipPayPage";
	}

	@RequestMapping(value = "delDogChipInject")
	public String delDogChipInject(String orderId) {
		clubMemberService.deleteUnPayOrder(paymentOrderService.get(orderId).getOrderCode());
		return "redirect:/partner/clubMember/dogList?repage";
	}

	/**
	 * 查询芯片号是否所属当前登录俱乐部
	 *
	 * @Author chaixueteng
	 * @2016年10月12日下午4:26:24
	 */
	@RequestMapping(value = "checkChip")
	@ResponseBody
	public Object checkChip(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String identificationFlag = request.getParameter("xinpian2");
			clubMemberService.checkChip(identificationFlag);
		} catch (ZAException e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 打印
	 *
	 * @Author chaixueteng
	 * @2016年10月14日上午10:08:34
	 */
	@RequestMapping(value = "print")
	public String print(String pedigreeCertified, Model model, RedirectAttributes redirectAttributes) {
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		// if("02".equals(dog.getPrintState())){//证书已打印的
		// addMessage(redirectAttributes, "打印失败:证书已打印,请刷新页面!");
		// return "redirect:/partner/clubMember/dogList?repage";
		// }
		String birthCertificateLevelCode = dog.getBirthCertificateLevelCode();
		DogChip byBirthCode = dogChipService.getByBirthCode(birthCertificateLevelCode);
		byBirthCode.setPrintSource("1");// 添加打印来源
		dogChipService.save(byBirthCode);
		// 添加打印日志
		PrintLogs printLogs = new PrintLogs();
		printLogs.preInsert();
		if (dog.getDogBreed().trim().equals("292")) {// 杜高
			printLogs.setPrintTypeLogs("1");
		} else if (dog.getDogBreed().trim().equals("15C")) {// 马犬
			printLogs.setPrintTypeLogs("2");
		} else {
			printLogs.setPrintTypeLogs("3");
		}
		printLogs.setPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
		printLogs.setBussinessTable("dog");
		printLogs.setBussinessId(dog.getId());
		printLogs.setRemarks("");
		printLogsDao.insert(printLogs);

		return dogService.processPrintBusiness(dog, model, Boolean.FALSE);
	}

	@RequestMapping(value = "parent")
	@ResponseBody
	public Object parent(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String snCode = request.getParameter("snCode");
			map = clubMemberService.parent(birthCode, snCode);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequestMapping(value = "chipParent")
	@ResponseBody
	public Object chipParent(HttpServletRequest request, HttpServletResponse response) {
		Map<String, String> map = new HashMap<String, String>();
		try {
			String birthCode = request.getParameter("birthCode");
			String chipCode = request.getParameter("chipCode");
			map = clubMemberService.chipParent(birthCode, chipCode);
			map.put("rc", "0");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 国外证书换发管理
	 *
	 * @Author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogPedigreeCertifiedChangelist")
	public String dogPedigreeCertifiedChangelist(DogPedigreeCertifiedChange dogPedigreeCertifiedChange,
			HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String orgId = org.getId();
		dogPedigreeCertifiedChange.setOrgId(orgId);
		dogPedigreeCertifiedChange.setReviewState("1");
		dogPedigreeCertifiedChange.setIsCanceled("0");
		Page<DogPedigreeCertifiedChange> page = dogPedigreeCertifiedChangeService
				.findPage(new Page<DogPedigreeCertifiedChange>(request, response), dogPedigreeCertifiedChange);
		model.addAttribute("page", page);
		return "partner/club/dogPedigreeCertifiedChangeList";
	}

	/**
	 * 国外换发芯片的
	 *
	 * @param id
	 * @param model
	 * @return
	 * @author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogCertifiedChangeChipForm")
	public String dogCertifiedChangeChipForm(String id, Model model) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(id);
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String orgid = org.getId();
		Org org2 = orgService.get(orgid);
		model.addAttribute("org", org2);
		// 有无占用芯片号
		DogChipChange dogChipChange = dogChipChangeService
				.getByOverseasPedigreeCertified(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		if (dogChipChange != null) {
			model.addAttribute("chipCodeNew", dogChipChange.getChipCodeNew());
		}
		return "partner/club/dogCertifiedChangeChipForm";
	}

	/**
	 * 国外证书换发采集dna
	 *
	 * @return
	 * @author chaixueteng
	 * @2017年5月10日下午3:32:48
	 */
	@RequestMapping(value = "dogCertifiedChangeDNAForm")
	public String dogCertifiedChangeDNAForm(String id, Model model) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(id);
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 重新查找 session域固定不变 所以需要重新查询 余额
		String orgid = org.getId();
		Org org2 = orgService.get(orgid);
		model.addAttribute("org", org2);
		// 有无占用采样包
		Sampling sampling = samplingService.getByDogCode(dogPedigreeCertifiedChange.getOverseasPedigreeCertified(),
				SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED);
		if (sampling != null) {
			model.addAttribute("samplingCode", sampling.getSamplingCode());
		}

		return "partner/club/dogCertifiedChangeDNAForm";
	}

	/**
	 * 芯片确认页面
	 *
	 * @param id
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "dogCertifiedChangeChipYesForm")
	public String dogCertifiedChangeChipYesForm(String id, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChangeService.get(id));
		return "partner/club/dogCertifiedChangeChipYesForm";
	}

	/**
	 * 审核芯片
	 *
	 * @Author chaixueteng
	 */
	@RequestMapping(value = { "toYesChip" })
	@ResponseBody
	public Object saveImage(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedChangeService.toYesChip(dogPedigreeCertifiedChange);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 犬只呼名校验
	 *
	 * @Author chaixueteng
	 * @2016年10月10日下午6:32:01
	 */
	@RequestMapping(value = "callNameCheck")
	@ResponseBody
	public String callNameCheck(HttpServletRequest request, HttpServletResponse response) {
		String callName = request.getParameter("callName");
		try {
			demandSensitiveWordService.validCallName(callName);
		} catch (Exception e) {
			return "{\"rc\":-1,\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	@RequestMapping(value = "/smsValidate/bindUser", method = RequestMethod.GET)
	@ResponseBody
	public void validateSMSBindUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		Member member = memberService.getByMemberCode(memberCode);
		// 有safemobile优先发safemobile没有发mobile
		if (member == null || StringUtils.isBlank(member.getId())
				|| (StringUtils.isBlank(member.getMobile()) && StringUtils.isBlank(member.getSafeMobile()))) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		String mobile = StringUtils.isBlank(member.getSafeMobile()) ? member.getMobile() : member.getSafeMobile();
		// 发送验证码，不进行判重
		smsRemindService.sendVerifyCode(request, mobile, false, TYPE_SMS_BIND_RENEWALS);
		request.getSession().setAttribute("cacheMobile", mobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping("singleClub/list")
	public String singleClubList(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		member.setSingleClubId(org.getId());
		Page<Member> page = memberService.findPage(new Page<Member>(request, response), member);
		model.addAttribute("member", member);
		model.addAttribute("page", page);
		return "partner/club/singleClubMemberList";
	}

}
