package com.cku.oa.timedtask.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.groomer.service.GroomerShowService;

@Service
@Transactional(readOnly = true)
public class GroomerShowEndTask extends JobActingService {
	
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private GroomerShowService groomerShowService; 

	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	int doJob() {
		int count = 0;
		try {
			count = groomerShowService.groomerShowEndReceive();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

	@SuppressWarnings("finally")
	@Transactional(readOnly = false)
	public int executeOnce() {
		int count = 0;
		try {
			SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
			count = groomerShowService.groomerShowEndReceive();
		} catch (Exception e) {
			count = -1;
		} finally {
			logger.info("修改数据,执行条数：" + count);
			return count;
		}
	}

}
