package com.cku.oa.timedtask.service;

import com.cku.oa.dog.service.DogActivationService;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import java.util.List;

@Service
@Transactional(readOnly = true)
public class DogActivationRemindTask extends JobActingService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    //犬只激活提醒触发天数，邮寄后的7，30，53天
    public static final List<Integer> DOG_ACTIVATION_REMIND_DAY_AFTER_SEND = Lists.newArrayList(7, 30, DogActivationService.EXPIRE_DAY - 7);

    @Autowired
    private DogActivationService dogActivationService;

    @SuppressWarnings("finally")
    int doJob() {
        int count = 0;
        try {
            for (Integer day : DOG_ACTIVATION_REMIND_DAY_AFTER_SEND) {
                count += dogActivationService.dogActivationRemind(day);
            }
        } catch (Exception e) {
            count = -1;
        } finally {
            logger.info("修改数据,执行条数：" + count);
            return count;
        }
    }

    @SuppressWarnings("finally")
    public int executeOnce() {
        int count = 0;
        try {
            SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
            for (Integer day : DOG_ACTIVATION_REMIND_DAY_AFTER_SEND) {
                count += dogActivationService.dogActivationRemind(day);
            }
        } catch (Exception e) {
            count = -1;
        } finally {
            logger.info("修改数据,执行条数：" + count);
            return count;
        }
    }

}
