package com.cku.oa.sys.badword.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.badword.dao.DemandSensitiveWordDao;
import com.cku.oa.sys.badword.entity.DemandSensitiveWord;
import com.cku.oa.sys.badword.util.SensitiveWordUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 敏感词Service
 * @author wangjie
 * @version 2018-03-13
 */
@Service
@Transactional(readOnly = true)
public class DemandSensitiveWordService extends CrudService<DemandSensitiveWordDao, DemandSensitiveWord> {

	@Autowired
    DemandSensitiveWordDao demandSensitiveWordDao;
	public DemandSensitiveWord get(String id) {
		return super.get(id);
	}

	public List<DemandSensitiveWord> findList(DemandSensitiveWord demandSensitiveWord) {
		return super.findList(demandSensitiveWord);
	}

	public Page<DemandSensitiveWord> findPage(Page<DemandSensitiveWord> page, DemandSensitiveWord demandSensitiveWord) {
		return super.findPage(page, demandSensitiveWord);
	}

	@Transactional(readOnly = false)
	public void save(DemandSensitiveWord demandSensitiveWord) {
		List<DemandSensitiveWord> byBadWord = demandSensitiveWordDao.findByBadWord(demandSensitiveWord.getBadWord());
		if(!Collections3.isEmpty(byBadWord) && byBadWord.size()>0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"敏感词重复！");
		}
		super.save(demandSensitiveWord);
	}

	@Transactional(readOnly = false)
	public void delete(DemandSensitiveWord demandSensitiveWord) {
		super.delete(demandSensitiveWord);
	}

	public List<DemandSensitiveWord> findByBadWord(String badWord) {
		List<DemandSensitiveWord> list = demandSensitiveWordDao.findByBadWord(badWord);
		return list;
	}

	/**
	 * 犬只呼名校验
	 * 呼名校验规则：(1、仅可输入1-4个汉字. 2、不允许包含空格及特殊符号 3、敏感词汇筛查，不可包含敏感词汇库的词语)
	 * @author chaixueteng
	 * @version 2018-03-13
	 */
	public void validCallName(String callName){
		String str=callName;
		// 不能有空格
		if (str.contains(" ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只呼名,不允许包含空格及特殊符号");
		}
		// 只能中文
		String regex = "[\\u4E00-\\u9FA5]+";
		if (!str.matches(regex)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只呼名,仅可输入汉字");
		}
		// 只能2-4个字
		if (str.length() < 1 || str.length() > 4) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只呼名,只能是1-4个字");
		}
		DemandSensitiveWord demandSensitiveWord=new DemandSensitiveWord();
		Set<String> sensitiveWordSet = new HashSet<>();
		List<DemandSensitiveWord> demandSensitiveWords=super.findList(demandSensitiveWord);
		for(DemandSensitiveWord demandSensitiveWord1: demandSensitiveWords){
			sensitiveWordSet.add(demandSensitiveWord1.getBadWord());
		}
		SensitiveWordUtil.init(sensitiveWordSet);
		Set<String> set = SensitiveWordUtil.getSensitiveWord(callName);
		if(set.size()>0){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只呼名,当前输入内容涉及敏感词汇，请更换其它内容");
		}
	}
}