package com.cku.oa.statistics.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.User;

@Service
@Transactional(readOnly = true, propagation = Propagation.NEVER)
public class PaymentRecordDataAdjustmentService {

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	@Autowired
	private PaymentRecordDao paymentRecordDao;

	@Transactional(readOnly = false)
	public void adjustment(String startDate, String endDate) {
		PaymentChargingItem charging = new PaymentChargingItem();
		charging.setIsShare("1");
		charging.setDelFlag("0");
		// 需要拆分调整的数据
		List<PaymentChargingItem> chargingList = paymentChargingItemService.findList(charging);
		for (PaymentChargingItem item : chargingList) {
			// 分摊时间段
			Integer section = Integer.parseInt(item.getShareSection());
			// 具体收费项
			PaymentOrderDetail deatil = new PaymentOrderDetail();
			deatil.setChargingItemId(item.getId());
			deatil.setStartDate(DateUtils.strToDate(startDate));
			deatil.setEndDate(DateUtils.strToDate(endDate));
			// 具体收费项结果集
			List<PaymentOrderDetail> deatilList = paymentOrderDetailDao.findAdjustmentList(deatil);
			if (!CollectionUtils.isEmpty(deatilList)) {
				/*
				 * 先物理删除拆分过的数据 (条件 del_flag = '0' create_by='PaymentRecordDataAdjustment'
				 * running_number in (deatilList.orderCode))
				 */
				paymentRecordDao.deleteAdjustment(deatilList);
				/*
				 * 恢复原来的数据 （条件 del_flag = '1' update_by='PaymentRecordDataAdjustment'
				 * running_number in (deatilList.orderCode) ）
				 */
				paymentRecordDao.restoreAdjustment(deatilList);

				// 拆分
				for (PaymentOrderDetail details : deatilList) {
					// 执行拆分（只处理shareSection大于1的记录）
					PaymentRecord result = null;
					List<PaymentRecord> adjustmentData = new ArrayList<>();
					if (section > 1) {
						for (int i = 1; i <= section; i++) {
							PaymentRecord entity = new PaymentRecord();
							entity.setDelFlag("0");
							entity.setRunningNumber(details.getOrderCode());
							result = paymentRecordDao.findAdjustmentData(entity);
							BeanUtils.copyProperties(result, entity);
							// createBy PaymentRecordDataAdjustment
							User user = new User("PaymentRecordDataAdjustment");
							entity.setCreateBy(user);
							entity.setUpdateDate(new Date());
							// 将payment_amount金额改成：price/share_sectio
							String paymentAmount = new BigDecimal(entity.getPrice()).divide(new BigDecimal(12), 2)
									.toString();
							entity.setPaymentAmount(paymentAmount);
							entity.setDelFlag("0");
							entity.setId(IdGen.uuid());
							adjustmentData.add(entity);
						}

						// 修改原纪录
						PaymentRecord entity = new PaymentRecord();
						entity.setDelFlag("1");
						entity.setRunningNumber(details.getOrderCode());
						User user = new User("PaymentRecordDataAdjustment");
						entity.setUpdateBy(user);
						entity.setId(result.getId());
						paymentRecordDao.updateById(entity);
						// 批量插入
//						paymentRecordDao.insertBatch(adjustmentData);
						for (PaymentRecord record : adjustmentData) {
							paymentRecordDao.newRecord(record);
						}
					}
				}
			}
		}
	}
}
