package com.cku.oa.order.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author yuanshuai
 * @date 2023/6/19 15:08
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class ChargingItemVo implements Serializable {
    private static final long serialVersionUID = 4574382183955241817L;

    @ApiModelProperty("收费项目ID")
    private String id;
    @ApiModelProperty("收费项目名")
    private String name;
    @ApiModelProperty("金额")
    private BigDecimal price;
    @ApiModelProperty("数量")
    private Integer num;
    @ApiModelProperty("业务ID")
    private String businessId;
    @ApiModelProperty("业务表名")
    private String businessTable;
    @ApiModelProperty("业务表ID")
    private String businessIds;
}
