/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.kennel.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelImage;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.LocalDateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

import net.sf.json.JSONObject;

/**
 * 犬舍基本信息Controller
 * @author fanhuibin
 * @version 2016-07-13
 */
@Controller
@RequestMapping(value = "${adminPath}/kennel/kennel")
public class KennelController extends BaseController {

	@Autowired
	private KennelService kennelService;

	@Autowired
	private MemberService memberService;
	
	@Autowired
	private DogTypeService dogTypeService;

	@ModelAttribute
	public Kennel get(@RequestParam(required=false) String id) {
		Kennel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = kennelService.get(id);
		}
		if (entity == null){
			entity = new Kennel();
		}
		return entity;
	}

	@RequiresPermissions("kennel:kennel:view")
	@RequestMapping(value = {"list", ""})
	public String list(Kennel kennel, HttpServletRequest request, HttpServletResponse response, Model model) {
		String name = kennel.getName();
		if (StringUtils.isNotBlank(name)) {
			String string = StringEscapeUtils.unescapeHtml4(name);
			kennel.setName(string);
		}
		String fciName = kennel.getFciName();
		if (StringUtils.isNotBlank(fciName)) {
			String string = StringEscapeUtils.unescapeHtml4(fciName);
			kennel.setFciName(string);
		}
		if("Fci".equals(kennel.getType())){//筛选条件为Fci犬舍
			model.addAttribute("tempFci", "Fci");
		}
		Page<Kennel> page = kennelService.findPage(new Page<Kennel>(request, response), kennel);
		model.addAttribute("page", page);
		Calendar ca = Calendar.getInstance();//得到一个Calendar的实例
		ca.setTime(new Date());   //设置时间为当前时间
		ca.add(Calendar.DATE, -1); //日期减1
		Date date = ca.getTime();
		model.addAttribute("date", date);
		if(StringUtils.isBlank(kennel.getTemp())){//temp标记请求来源
			model.addAttribute("temp","1");
		}else{
			model.addAttribute("temp", kennel.getTemp());
		}
		return "oa/kennel/kennelList";
	}



	@RequiresPermissions("kennel:kennel:view")
	@RequestMapping(value = "view")
	public String view(Kennel kennel, Model model) {
		/*Member member = memberService.getByMemberCode(kennel.getMemberCode());
		kennel.setMember(member);*/
		model.addAttribute("date", new Date());
		model.addAttribute("kennel", kennel);
		/*if(kennel.getEndTime()==null || (kennel.getEndTime()==null && ))*/
		return "oa/kennel/kennelFormView";
	}

	/**
	 * 犬舍中文名校验
	 */
	@RequiresPermissions("kennel:kennel:view")
	@RequestMapping(value = "nameCheck")
	@ResponseBody
	public ResultDto<Boolean> nameCheck(HttpServletRequest request, HttpServletResponse response) {
		String kennelName = request.getParameter("name");
		String memberCode = request.getParameter("memberCode");
		ResultDto<Boolean> result = ResultDto.success(Boolean.TRUE);
		try {
			kennelService.nameCnCheck(kennelName, memberCode);
		}catch(Exception ex) {
			result = ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return result;
	}
	
	/**
	 * 犬舍英文名校验
	 */
	@RequiresPermissions("kennel:kennel:view")
	@RequestMapping(value = "nameEnCheck")
	@ResponseBody
	public ResultDto<Boolean> nameEnCheck(HttpServletRequest request, HttpServletResponse response) {
		String kennelNameEn = request.getParameter("nameEn");
		Boolean isValidBlank = Boolean.valueOf(request.getParameter("isValidBlank"));
		String memberCode = request.getParameter("memberCode");
		ResultDto<Boolean> result = ResultDto.success(Boolean.TRUE);;
		try {
			kennelService.nameEnCheck(kennelNameEn,isValidBlank,memberCode);
		}catch(Exception ex) {
			result = ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, ex.getMessage());
		}
		return result;
	}


	@RequiresPermissions("kennel:kennel:view")
	@RequestMapping(value = "form")
	public String form(Kennel kennel, Model model) {
		if(StringUtils.isEmpty(kennel.getId())){
			Member member = memberService.getByMemberCode(kennel.getMemberCode());
			kennel.setMember(member);
		}
		model.addAttribute("kennel", kennel);
		if(StringUtils.isEmpty(kennel.getId())){
			return "oa/kennel/kennelForm";
		}else{
			String payItem = kennelService.getPayItem(kennel);
			model.addAttribute("payItem", payItem);
			String buttonValue = "缴费";
			/*if("kennel@ZC".equals(payItem))
				buttonValue = "犬舍初次注册缴费";
			if("kennel@ND".equals(payItem))
				buttonValue = "犬舍年度缴费";
			if("kennel@YJ".equals(payItem))
				buttonValue = "永久犬舍缴费";*/
			model.addAttribute("date", new Date());
			model.addAttribute("buttonValue", buttonValue);
			return "oa/kennel/kennelFormEdit";
		}
		//kennel.setMemberCode(request.getParameter("memberCode"));
		//kennel.setKennelCode(request.getParameter("memberCode"));
		//kennel.setCreateByName(UserUtils.getUser().getName());
		//model.addAttribute("kennel", kennel);
		//return "oa/kennel/kennelForm";
	}


	@RequiresPermissions("kennel:kennel:edit")
	@RequestMapping(value = "editFrom")
	public String editFrom(Kennel kennel, Model model) {
		if(StringUtils.isNotBlank(kennel.getTemp())){
			model.addAttribute("temp", kennel.getTemp());
		}
		if(StringUtils.isNotBlank(kennel.getTempFci())){
			model.addAttribute("tempFci", kennel.getTempFci());
		}
		if(StringUtils.isEmpty(kennel.getId())){
			Member member = memberService.getByMemberCode(kennel.getMemberCode());
			kennel.setMember(member);
		}
		model.addAttribute("kennel", kennel);
		if(StringUtils.isEmpty(kennel.getId())){
			return "oa/kennel/kennelForm";
		}else{
			String payItem = kennelService.getPayItem(kennel);
			model.addAttribute("payItem", payItem);
			String buttonValue = "缴费";
			model.addAttribute("date", new Date());
			model.addAttribute("buttonValue", buttonValue);
			Member member = memberService.getByMemberCode(kennel.getMemberCode());
			model.addAttribute("isActiveMember", MemberUtil.isActiveMember(member));
			return "oa/kennel/kennelFormEdit";
		}
		//kennel.setMemberCode(request.getParameter("memberCode"));
		//kennel.setKennelCode(request.getParameter("memberCode"));
		//kennel.setCreateByName(UserUtils.getUser().getName());
		//model.addAttribute("kennel", kennel);
		//return "oa/kennel/kennelForm";
	}



	@RequiresPermissions("kennel:kennel:add")
	@RequestMapping(value = "save")
	public String save(Kennel kennel, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, kennel)){
			return form(kennel, model);
		}
		kennelService.save(kennel);
		addMessage(redirectAttributes, "保存犬舍成功");
		return "redirect:"+Global.getAdminPath()+"/sys/user/member/?repage";
	}

	@SuppressWarnings("deprecation")
	@RequiresPermissions("kennel:kennel:edit")
	@RequestMapping(value = "edit")
	public String edit(Kennel kennel, Model model, RedirectAttributes redirectAttributes) {
		String paymentState = null;
		String reviewState = null;
		String fciReviewState = null;
		String type = null;
		try {
			Kennel temp = kennelService.get(kennel.getId());
			Date endTime = temp.getEndTime();
			if (endTime != null && endTime.getTime() > new Date().getTime()) {
				paymentState = "2";
			} else if (endTime != null && endTime.getTime() < new Date().getTime()) {
				paymentState = "1";
			} else {
				paymentState = "1";
			}
			reviewState = temp.getReviewState();
			fciReviewState = temp.getFciReviewState();
			type = temp.getType();
			kennelService.edit(kennel);
		} catch (ZAException e) {
			addMessage(redirectAttributes, e.getMessage());
			return "redirect:" + Global.getAdminPath() + "/kennel/kennel/editFrom?id=" + kennel.getId() + "&temp=1";
		}
		if (StringUtils.isNotBlank(kennel.getTemp())) {
			if ("2".equals(kennel.getTemp())) {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				Date createDate = kennel.getCreateDate();
				int month = createDate.getMonth();
				Calendar c = Calendar.getInstance();
				c.add(Calendar.MONTH, month - 1);
				c.set(Calendar.DAY_OF_MONTH, 1);
				Date beginTime = c.getTime();
				Calendar ca = Calendar.getInstance();
				c.add(Calendar.MONTH, month - 1);
				ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
				Date endTime = ca.getTime();
				String beginDate = sdf.format(beginTime);
				String endDate = sdf.format(endTime);
				if ("Fci".equals(kennel.getTempFci())) {
					return "redirect:" + Global.getAdminPath() + "/kennel/kennel/?paymentState=" + paymentState + "&repage"
							+ "&fciReviewState=" + fciReviewState + "&beginDate=" + beginDate + "&endDate=" + endDate + "&type=Fci";
				}
				return "redirect:" + Global.getAdminPath() + "/kennel/kennel/?paymentState=" + paymentState + "&repage&reviewState=" + reviewState
						+ "&fciReviewState=" + fciReviewState + "&beginDate=" + beginDate + "&endDate=" + endDate + "&type=" + type;
			}
			return "redirect:" + Global.getAdminPath() + "/kennel/kennel/?paymentState=" + paymentState + "&repage&reviewState=" + reviewState
					+ "&fciReviewState=" + fciReviewState;
		}
		return "redirect:" + Global.getAdminPath() + "/sys/user/member/?repage";
	}

	@RequiresPermissions("kennel:kennel:edit")
	@RequestMapping(value = "kennelEditFrom")
	public String kennelEditFrom(Kennel kennel, Model model, RedirectAttributes redirectAttributes) {
		try {
			kennelService.edit(kennel);
		} catch (ZAException e) {
			addMessage(redirectAttributes,e.getMessage());
			return "redirect:"+Global.getAdminPath()+"/kennel/kennel/editFrom?id="+kennel.getId();
		}
		return "redirect:"+Global.getAdminPath()+"/kennel/kennel/list?repage";
	}

	@RequiresPermissions("kennel:kennel:edit")
	@RequestMapping(value = "delete")
	public String delete(Kennel kennel, RedirectAttributes redirectAttributes) {
		kennelService.delete(kennel);
		addMessage(redirectAttributes, "删除犬舍成功");
		return "redirect:"+Global.getAdminPath()+"/kennel/kennel/?repage";
	}

	@RequiresPermissions("kennel:kennel:print")
	@RequestMapping(value = "print")
	public String print(Kennel kennel, Model model) {
        model.addAttribute("kennel", kennelService.print(kennel));
        return "oa/kennel/kennelPrint";
    }

	@RequiresPermissions("kennel:kennel:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(Kennel kennel, HttpServletRequest request, RedirectAttributes redirectAttributes){
		String tz=request.getParameter("tz");
		kennelService.resetPrint(kennel);
		if("1".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/kennel/kennelRename/?repage";
		}else if("2".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/sys/user/member/?repage";
		}else if("4".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/kennel/kennel/?repage";
		}else{
			return "";
		}
	}

	@RequiresPermissions("kennel:kennel:print")
	@RequestMapping(value = "fciPrint")
	public String fciPrint(Kennel kennel, Model model) {
        model.addAttribute("kennel", kennelService.fciPrint(kennel));
        return "oa/kennel/kennelFciPrint";
    }

	@RequiresPermissions("kennel:kennel:resetPrint")
	@RequestMapping(value = "fciResetPrint")
	public String fciResetPrint(Kennel kennel, HttpServletRequest request, RedirectAttributes redirectAttributes){
		String tz=request.getParameter("tz");
		kennelService.fciResetPrint(kennel);
		if("1".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/kennel/kennelRename/?repage";
		}else if("2".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/sys/user/member/?repage";
		}else if("4".equals(tz)){
			return "redirect:"+Global.getAdminPath()+"/kennel/kennel/?repage";
		}else{
			return "";
		}
	}

	/**
	 *
	 * @Description：根据犬舍中文名模糊查询相同的犬舍
	 * @author: chaixueteng
	 * @version: 2016年9月1日 下午4:11:56
	 */
	@RequestMapping("getKennel")
	@ResponseBody
	public String getBreedNumber(HttpServletRequest request){
	    String name = request.getParameter("name");
	    return kennelService.getkennel(name);
	}
	/**
	 *
	 * @Description：根据犬舍英文名模糊查询相同的犬舍
	 * @author: chaixueteng
	 * @version: 2016年9月1日 下午4:11:56
	 */
	@RequestMapping("getKennelFci")
	@ResponseBody
	public String getKennelFci(HttpServletRequest request){
		String fciName = request.getParameter("fciName");
	    return kennelService.getKennelFci(fciName);
	}

	/**
	 * FCI信息导出
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("kennel:kennel:export")
    @RequestMapping(value = "export")
    public String export(Kennel kennel,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			kennelService.export(kennel,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出犬舍信息失败！失败信息："+e.getMessage());
		}
		return null;
    }
	@RequestMapping(value = "editKennelType/form")
	public String editMemberType(Kennel kennel,String kennelType, Model model) {
		model.addAttribute("kennel", kennel);
		return "oa/kennel/kennelTypeEditForm";
	}
	
	@RequestMapping(value = "editExtra/form")
	public String editExtra(Kennel kennel,Model model) {
		model.addAttribute("kennel", kennel);
		if(Objects.nonNull(kennel)){
			if(StringUtils.isNotEmpty(kennel.getBusinessDays())) {
				kennel.setBusinessDaysArr(kennel.getBusinessDays().split(","));
			}
			List<KennelImage> images = kennelService.findImageList(kennel.getId());
			if(!CollectionUtils.isEmpty(images)) {
				kennel.setKennelImages(String.join(",",images.stream().map(entity->entity.getImageUrl()).collect(Collectors.toList())));
				kennel.setKennelImageList(images);
			}
		}
		model.addAttribute("dogBreedList", dogTypeService.findAllList());
		
		model.addAttribute("date", LocalDateUtils.LocalDateToDate(LocalDate.now()));
		return "oa/kennel/kennelExtraEditForm";
	}
	
	
	@ResponseBody
	@RequestMapping(value = "saveExtra")
	public ResultDto<String> saveExtra(Kennel kennel,Model model) {
		return kennelService.saveExtra(kennel);
	}

	@RequestMapping(value = "search/page")
	public String searchPage(Kennel kennel,HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Kennel> page = new Page<Kennel>();
		page = kennelService.findPage(new Page<Kennel>(request, response), kennel);
		for (Kennel k : page.getList()) {
			if(!StringUtils.isEmpty(k.getNameEn()) && k.getNameEn().contains("'")) {
				k.setNameEn(k.getNameEn().replace("'", " "));
			}
		}
		model.addAttribute("page", page);
		return "oa/kennel/kennelSearch";
	}
	
	
	@RequiresPermissions("kennel:kennel:search")
	@ResponseBody
	@RequestMapping(value = "search")
	public Object search(String searchMemberCode) {
		Map<String,String> map=new HashMap<String,String>();
		if (StringUtils.isNotBlank(searchMemberCode)) {
			Member member = memberService.getByMemberCode(searchMemberCode.toUpperCase());
			if (member!=null) {
				Date date=new Date();
				if (!(MemberUtil.isProfessionalMember(member) && MemberUtil.isActiveMember(member))) {
					map.put("rc", "1");
					map.put("msg", "该会员不是有效的专业版会员!");
					return map;
				}
				Kennel kennel = kennelService.getKennelByMemberCode(searchMemberCode.toUpperCase());
				if(kennel!=null){
					map.put("rc", "1");
					map.put("msg", "该会员名下已有犬舍!");
					return map;
				}
				map.put("rc", "0");
				map.put("msg", "查询成功");
				map.put("name", member.getName());
				return map;
			}else{
				map.put("rc", "1");
				map.put("msg", "查无此会员信息!");
				return map;
			}
		}else{
			map.put("rc", "1");
			map.put("msg", "请输入会员号!");
			return map;
		}

	}
	/**
	 * 修改会员类型
	 * @param
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "editKennel/edit")
	@ResponseBody
	public void editMember(@RequestParam String searchMemberCode ,@RequestParam String memberCode,@RequestParam String remarklogs ,Model model,HttpServletResponse response) throws IOException {
		JSONObject result = new JSONObject();
		//查询会员
		try {
			kennelService.editMemberType(searchMemberCode.toUpperCase(),memberCode,remarklogs);
			String mes = "会员："+memberCode+"犬舍转换成功！";
			result.put("rc", 0);
			result.put("msg",mes );
			result.put("successUrl", "/kennel/kennel/list?message="+ URLEncoder.encode(mes));
		} catch (Exception e) {
			result.put("rc", 1);
			result.put("msg", e.getMessage());

		}
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(result.toString());
	}

}