/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.vo.PaymentRefundOrderVO;
import com.cku.oa.show.entity.ApplyDiscountListVo;
import com.cku.oa.show.service.ShowApplyDiscountService;
import com.cku.oa.sys.service.UserService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;

/**
 * 订单Controller
 *
 * @author lyy
 * @version 2016-08-04
 */
@Controller
@RequestMapping(value = "${adminPath}/finance/paymentOrder")
public class PaymentOrderController extends BaseController {

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;

	@Autowired
	private UserService userService;

	@Autowired
	private ShowApplyDiscountService showApplyDiscountService;

	@ModelAttribute
	public PaymentOrder get(@RequestParam(required = false) String id,
			@RequestParam(required = false) String orderCode) {
		PaymentOrder entity = null;
		if (StringUtils.isNotBlank(id) || StringUtils.isNotBlank(orderCode)) {
			entity = paymentOrderService.get(id, orderCode);
		}
		if (entity == null) {
			entity = new PaymentOrder();
		}
		return entity;
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "list", "" })
	public String list(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		paymentOrder.setIncludedDelFlag(true);

		/** 将查询总金额放在查询列表之前，防止页面 分页信息显示错误，请勿调整位置 **/
		String orderCount = paymentOrderService.getOrderCount(paymentOrder);
		/** 将查询总金额放在查询列表之前，防止页面 分页信息显示错误，请勿调整位置 **/

		Page<PaymentOrder> page = paymentOrderService.findPages(new Page<PaymentOrder>(request, response),
				paymentOrder);

		if (CollectionUtils.isNotEmpty(page.getList())) {

			// 使用分组 避免因重复数据引发的异常
			Map<String, List<PaymentOrderDetail>> detailMap = new HashMap<>();
			// 批量查询 订单退款状态及凭证
			List<String> orderList = page.getList().stream().map(PaymentOrder::getOrderCode)
					.collect(Collectors.toList());
			List<PaymentOrderDetail> detailList = paymentOrderDetailDao.getByOrderCodes(orderList);

			if (CollectionUtils.isNotEmpty(detailList)) {
				detailMap.putAll(detailList.stream().collect(Collectors.groupingBy(PaymentOrderDetail::getOrderCode)));
			}

			// 使用分组 避免因重复数据引发的异常
			Map<String, List<User>> userMap = new HashMap<>();
			// 批量查询订单创建人
			List<String> userIdList = page.getList().stream().map(po -> {
				return Objects.nonNull(po.getCreateBy()) ? po.getCreateBy().getId() : "0";
			}).distinct().collect(Collectors.toList());
			List<User> userList = userService.findByIds(userIdList);
			if (CollectionUtils.isNotEmpty(userList)) {
				userMap.putAll(userList.stream().collect(Collectors.groupingBy(User::getId)));
			}

			page.getList().forEach(po -> {

				if (detailMap.containsKey(po.getOrderCode())) {
					po.setVoucherCode(detailMap.get(po.getOrderCode()).get(0).getVoucherCode());
					po.setBusinessRefundState(detailMap.get(po.getOrderCode()).get(0).getBusinessRefundState());
				}

				if (Objects.nonNull(po.getCreateBy()) && userMap.containsKey(po.getCreateBy().getId())
						&& !po.getOrderCode().contains("@")) {
					po.getCreateBy().setName(userMap.get(po.getCreateBy().getId()).get(0).getName());
				}

			});

		}

		// 注释原逻辑，改为上面单次查询，加快查询速度
//		for (PaymentOrder p : page.getList()) {
//			PaymentOrderDetail paymentOrderDetail = paymentOrderDetailDao.getByOrderCode(p.getOrderCode());
//			if (null != paymentOrderDetail) {
//				p.setVoucherCode(paymentOrderDetail.getVoucherCode());
//				p.setBusinessRefundState(paymentOrderDetail.getBusinessRefundState());
//			}
//		}
		model.addAttribute("orderCount", orderCount);
		model.addAttribute("page", page);
		return "oa/finance/paymentOrderList";
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = "form")
	public String form(PaymentOrder paymentOrder, Model model) {
		logger.info("PaymentOrderController param : {}", JSON.toJSONString(paymentOrder));
		if ("1".equals(paymentOrder.getDelFlag())) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
					.findAllByOrderCode(paymentOrder.getOrderCode());
			paymentOrder.setOrderDetailList(orderDetailList);
		}
		// business_refund_state 业务退款状态 1退款待审核，2审核不通过，3审核通过
		// 作废功能在存在退款完成和退款中的情况下禁用
		boolean isShowCancel = false;
		if (paymentOrder.getOrderDetailList() != null) {
			isShowCancel = paymentOrder.getOrderDetailList().stream().filter(a -> {
				return "1".equals(a.getBusinessRefundState()) || "3".equals(a.getBusinessRefundState());
			}).count() == 0;
		}

		model.addAttribute("paymentOrder", paymentOrder);
		model.addAttribute("isShowCancel", isShowCancel);
		return "oa/finance/paymentOrderForm";
	}

	@RequestMapping(value = "regionForm")
	public String regionForm(PaymentOrder paymentOrder, Model model) {

		if ("1".equals(paymentOrder.getDelFlag())) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
					.findAllByOrderCode(paymentOrder.getOrderCode());
			paymentOrder.setOrderDetailList(orderDetailList);
		}
		// business_refund_state 业务退款状态 1退款待审核，2审核不通过，3审核通过
		// 作废功能在存在退款完成和退款中的情况下禁用
		boolean isShowCancel = false;
		if (paymentOrder.getOrderDetailList() != null) {
			isShowCancel = paymentOrder.getOrderDetailList().stream().filter(a -> {
				return "1".equals(a.getBusinessRefundState()) || "3".equals(a.getBusinessRefundState());
			}).count() == 0;
		}

		model.addAttribute("paymentOrder", paymentOrder);
		model.addAttribute("isShowCancel", isShowCancel);
		return "oa/finance/regionPaymentOrderForm";
	}

	@RequiresPermissions("finance:paymentOrder:add")
	@RequestMapping(value = "save")
	public String save(PaymentOrder paymentOrder, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, paymentOrder)) {
			return form(paymentOrder, model);
		}
		try {
			paymentOrderService.save(paymentOrder);
			addMessage(redirectAttributes, "保存订单成功");
			redirectAttributes.addFlashAttribute("orderrc", "0");
		} catch (ZAException e) {
			addMessage(redirectAttributes, e.getMessage());
			redirectAttributes.addFlashAttribute("orderrc", "-1");
		}
		return "redirect:" + Global.getAdminPath() + "/finance/paymentProjectCart/form?projectId="
				+ paymentOrder.getOrderDetailList().get(0).getProjectId() + "&voucherCode="
				+ paymentOrder.getOrderDetailList().get(0).getVoucherCode() + "&memberCode="
				+ paymentOrder.getOrderDetailList().get(0).getMemberCode();
	}

	/**
	 * 订单处理
	 *
	 * @param paymentOrder
	 * @param model
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("finance:paymentOrder:changeStatus")
	@RequestMapping(value = "updateProccessState")
	public String updateProccessState(String id, String detailId, Model model, RedirectAttributes redirectAttributes) {
		paymentOrderService.updateProccessState(id, detailId);
		addMessage(redirectAttributes, "订单处理成功");
		return "redirect:" + Global.getAdminPath() + "/finance/paymentOrder/form?id=" + id;
	}

	@RequiresPermissions("finance:paymentOrder:locked")
	@RequestMapping(value = "locked")
	public String locked(PaymentOrder paymentOrder, RedirectAttributes redirectAttributes) {
		paymentOrderService.locked(paymentOrder);
		addMessage(redirectAttributes, "订单锁定成功");
		return "redirect:" + Global.getAdminPath() + "/finance/paymentOrder/form?id=" + paymentOrder.getId();
	}

	@RequiresPermissions("finance:paymentOrder:cancled")
	@RequestMapping(value = "cancled")
	public String cancled(String orderId, RedirectAttributes redirectAttributes) {
		paymentOrderService.cancled(orderId);
		addMessage(redirectAttributes, "订单作废成功");
		return "redirect:" + Global.getAdminPath() + "/finance/paymentOrder";
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "refundList" })
	public String refundList(PaymentRefundOrderVO refundOrder, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		// 部门聚合
		model.addAttribute("departmentList", paymentChargingItemGroupService.departmentList());
		Page<PaymentRefundOrderVO> page = paymentOrderService
				.refundList(new Page<PaymentRefundOrderVO>(request, response), refundOrder);

		model.addAttribute("page", page);
		model.addAttribute("refundOrder", refundOrder);

		return "oa/finance/paymentOrderRefundAuditList";
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "applyDiscountList" })
	public String applyDiscountList(String discountSign, String orderCode, String showMainId,
			HttpServletRequest request, HttpServletResponse response, Model model) {
		List<ApplyDiscountListVo> list = showApplyDiscountService.findApplyDiscountList(discountSign, showMainId);
		model.addAttribute("list", list);
		model.addAttribute("orderCode", orderCode);
		return "oa/finance/applyDiscountList";
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "refundAgree" })
	@ResponseBody
	public Map<String, String> refundAgree(PaymentRefundOrderVO refundOrder, RedirectAttributes redirectAttributes)
			throws Exception {
		PaymentOrder order = paymentOrderService.getByBusinessOrderCode(refundOrder.getBusinessOrderCode());
		refundOrder.setId(order.getId());
		return paymentOrderService.refundAgree(refundOrder);
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "refundDisagree" })
	@ResponseBody
	public Map<String, String> refundDisagree(PaymentRefundOrderVO refundOrder, RedirectAttributes redirectAttributes) {
		return paymentOrderService.refundDisagree(refundOrder);
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "refundAgreeALL" })
	@ResponseBody
	public Map<String, String> refundAgreeALL(PaymentRefundOrderVO refundOrderP,
			RedirectAttributes redirectAttributes) {
		List<PaymentRefundOrderVO> refundOrder = refundOrderP.getIds().stream().map(p -> {
			PaymentRefundOrderVO a = new PaymentRefundOrderVO();
			a.setBusinessOrderCode(p.get("businessOrderCode"));
			return a;
		}).collect(Collectors.toList());
		return paymentOrderService.refundAgreeALL(refundOrder);
	}

	@RequiresPermissions("finance:paymentOrder:view")
	@RequestMapping(value = { "refundList/business" })
	public String business(PaymentRefundOrderVO refundOrder, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		String table = refundOrder.getBusinessTable();
		String url = "/finance/paymentOrder/refundList/?repage";

		if ("dog_newborn".equals(table)) {
			// 配种证明费用
			url = "/dognewborn/dogNewborn/list?repage";
		} else if ("dog_birth_certificate".equals(table)) {
			// 新生犬登记卡
			url = "/birthcertificate/dogBirthCertificate/list?repage";
		} else if ("dog_chip".equals(table)) {
			// 新生犬血统证书
			url = "/dnewdogchip/dogChip/list?repage";

		} else if ("dog_pedigree_certified_redo".equals(table)) {
			// 证书补做
			url = "/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/list?repage";
		} else if ("dog_pedigree_certified_change".equals(table)) {
			// 证书换发 国外血统证书换发
			url = "/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/list?repage";

		} else if ("dog_pedigree_certified_export".equals(table)) {
			// 出口证书业务
			url = "/dogexport/dogPedigreeCertifiedExport/list?repage";

		} else if ("dog_owner_change".equals(table)) {
			// 犬主变更
			url = "/dogownerchange/dogOwnerChange/list?repage";
		} else if ("show_champion_login".equals(table)) {
			// 冠军登录
			url = "/championlogin/championLogin/list?repage";
		} else if ("groomer_register".equals(table)) {
			// 美容师资格认证考试
			url = "/groomer/groomerRegister/list?repage";
		} else if ("kennel_rename".equals(table)) {
			// 犬舍名称变更
			url = "/kennel/kennelRename/list?repage";
		} else if ("show_apply".equals(table)) {
			// 犬只参赛费
			url = "/apply/showApply/list?repage";
		}
		return "redirect:" + Global.getAdminPath() + url;
	}

}