/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 订单Entity
 * @author lyy
 * @version 2016-08-04
 */
/**
 * @author user
 *
 */
public class PaymentOrder extends DataEntity<PaymentOrder> {

	private static final long serialVersionUID = 1L;
	private String delFlagsss;

	private String memberCode; // 会员号
	private String memberName; // 会员名称
	private String orderCode; // 订单编号
	private String totalPrice; // 总价
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间
	private Date addTime; // 添加时间
	private String receiver; // 收货人
	private String receiveDel; // 收件人电话
	private String receiveProvince; // 收件省
	private String receiveCity; // 市
	private String receiveArea; // 区域
	private String receiveAddress; // 地址
	private String receivePostCode; // 收件邮编
	private String projectId; // 订单项目主键
	private String projectName; // 订单项目名称
	private Date beginAddTime; // 开始 添加时间
	private Date endAddTime; // 结束 添加时间
	private String locked; // 是否锁定
	private String paymentWay; // 支付方式
	private String transactionId; // 微信交易单号
	private String source;// 订单来源
	private String amount; // 充值金额

	private List<PaymentOrderDetail> orderDetailList;
	private String voucherCode; // 凭证号

	private String clientFlag;// 会员端查询标志位，如果不为空，则查询除会员充值外的收费项记录
	private String isRecharge = "0";// 是否充值订单：0否；1是,默认为0
	private String isBuying = "0"; // 是否抢购订单 : 0否; 1是,默认为0
	private String couponNum = "0";// 是否优惠订单 :0 否 ;其他数字为使用优惠劵的数量,默认为0

	private String beginCreateDate;
	private String endCreateDate;
	private String remark;
	private String chargingItemId; // 收费项目
	private boolean isIncludedDelFlag = false;
	private String businessRefundState;// '业务退款状态 1退款待审核，2审核不通过，3审核通过';
	
	public boolean isIncludedDelFlag() {
		return isIncludedDelFlag;
	}

	public void setIncludedDelFlag(boolean isIncludedDelFlag) {
		this.isIncludedDelFlag = isIncludedDelFlag;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(String beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public String getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(String endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public PaymentOrder() {
		super();
	}

	public PaymentOrder(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 50, message = "会员名称长度必须介于 0 和 50 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 1, max = 100, message = "订单编号长度必须介于 1 和 100 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@Length(min = 0, max = 10, message = "支付方式长度必须介于 0 和 10之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}

	@Length(min = 0, max = 2, message = "支付状态长度必须介于 0 和 2 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}

	@Length(min = 0, max = 100, message = "收货人长度必须介于 0 和 100 之间")
	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	@Length(min = 0, max = 20, message = "收货电话长度必须介于 0 和 20 之间")
	public String getReceiveDel() {
		return receiveDel;
	}

	public void setReceiveDel(String receiveDel) {
		this.receiveDel = receiveDel;
	}

	@Length(min = 0, max = 20, message = "收货省长度必须介于 0 和 20 之间")
	public String getReceiveProvince() {
		return receiveProvince;
	}

	public void setReceiveProvince(String receiveProvince) {
		this.receiveProvince = receiveProvince;
	}

	@Length(min = 0, max = 20, message = "收货市长度必须介于 0 和 20 之间")
	public String getReceiveCity() {
		return receiveCity;
	}

	public void setReceiveCity(String receiveCity) {
		this.receiveCity = receiveCity;
	}

	@Length(min = 0, max = 200, message = "收货地址长度必须介于 0 和 200 之间")
	public String getReceiveAddress() {
		return receiveAddress;
	}

	public void setReceiveAddress(String receiveAddress) {
		this.receiveAddress = receiveAddress;
	}

	@Length(min = 0, max = 11, message = "收货邮编长度必须介于 0 和 11 之间")
	public String getReceivePostCode() {
		return receivePostCode;
	}

	public void setReceivePostCode(String receivePostCode) {
		this.receivePostCode = receivePostCode;
	}

	@Length(min = 0, max = 64, message = "订单项目主键长度必须介于 0 和 64 之间")
	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	@Length(min = 0, max = 200, message = "订单项目名称长度必须介于 0 和 200 之间")
	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Date getBeginAddTime() {
		return beginAddTime;
	}

	public void setBeginAddTime(Date beginAddTime) {
		this.beginAddTime = beginAddTime;
	}

	public Date getEndAddTime() {
		return endAddTime;
	}

	public void setEndAddTime(Date endAddTime) {
		this.endAddTime = endAddTime;
	}

	@Length(min = 1, max = 1)
	public String getLocked() {
		return locked;
	}

	public void setLocked(String locked) {
		this.locked = locked;
	}

	public List<PaymentOrderDetail> getOrderDetailList() {
		return orderDetailList;
	}

	public void setOrderDetailList(List<PaymentOrderDetail> orderDetailList) {
		this.orderDetailList = orderDetailList;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}

	public String getClientFlag() {
		return clientFlag;
	}

	public void setClientFlag(String clientFlag) {
		this.clientFlag = clientFlag;
	}

	public String getIsRecharge() {
		return isRecharge;
	}

	public void setIsRecharge(String isRecharge) {
		this.isRecharge = isRecharge;
	}

	@Length(min = 0, max = 255, message = "微信交易号长度必须介于 0 和 255 之间")
	public String getTransactionId() {
		return transactionId;
	}

	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	public String getIsBuying() {
		return isBuying;
	}

	public void setIsBuying(String isBuying) {
		this.isBuying = isBuying;
	}

	public String getCouponNum() {
		return couponNum;
	}

	public void setCouponNum(String couponNum) {
		this.couponNum = couponNum;
	}

	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	public String getDelFlagsss() {
		return delFlagsss;
	}

	public void setDelFlagsss(String delFlagsss) {
		this.delFlagsss = delFlagsss;
	}

	public String getReceiveArea() {
		return receiveArea;
	}

	public void setReceiveArea(String receiveArea) {
		this.receiveArea = receiveArea;
	}

	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	public String getBusinessRefundState() {
		return businessRefundState;
	}

	public void setBusinessRefundState(String businessRefundState) {
		this.businessRefundState = businessRefundState;
	}
	
}