package com.cku.oa.dog.web;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.DogOwnerChange;
import com.cku.oa.dog.service.DogOwnerChangeService;
import com.cku.oa.dog.vo.DogOwnerChangeVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬主变更申请Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-17
 */
@Controller
@RequestMapping(value = "${adminPath}/dogownerchange/dogOwnerChange")
public class DogOwnerChangeController extends BaseController {

	@Autowired
	private DogOwnerChangeService dogOwnerChangeService;

	@Autowired
	private MemberService memberService;

	@ModelAttribute
	public DogOwnerChange get(@RequestParam(required = false) String id) {
		DogOwnerChange entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogOwnerChangeService.get(id);
		}
		if (entity == null) {
			entity = new DogOwnerChange();
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogOwnerChange dogOwnerChange, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		String dogBreed = request.getParameter("dogBreed");
		if ("230".equals(dogBreed) && dogOwnerChange.getDog() == null) {
			dogOwnerChange.setDogBreed(dogBreed);
		}
		Page<DogOwnerChange> page = dogOwnerChangeService.findPage(new Page<DogOwnerChange>(request, response),
				dogOwnerChange);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogOwnerChange> list = page.getList().stream().map(a -> {
			DogOwnerChangeVO b = new DogOwnerChangeVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if ("230".equals(dogBreed)) {
			return "oa/dog/dogownerchange/dogOwnerChangeListTibetanMastiff";
		} else {
			return "oa/dog/dogownerchange/dogOwnerChangeList";
		}
	}

	/**
	 * 
	 * @Description：犬主变更订单列表页
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午3:27:03
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = { "orderList" })
	public String orderList(DogOwnerChange dogOwnerChange, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		List<DogOwnerChange> list = dogOwnerChangeService.findList(dogOwnerChange);

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogOwnerChangeVO> list2 = list.stream().map(a -> {
			DogOwnerChangeVO b = new DogOwnerChangeVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/dogownerchange/dogOwnerChangeOrderList";
	}

	/**
	 * 
	 * @Description：犬主变更订单业务添加页
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午3:28:44
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(DogOwnerChange dogOwnerChange, Model model,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		dogOwnerChange.setNewOwnerName(member.getName());
		dogOwnerChange.setNewOwnerMemberCode(memberCode);
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/dog/dogownerchange/dogOwnerChangeOrderAdd";
	}

	/**
	 * 
	 * @Description：犬主变更业务信息保存
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午3:29:34
	 */
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public ResultDto<String> orderSave(DogOwnerChange dogOwnerChange, Model model) {
		try {
			return dogOwnerChangeService.orderSave(dogOwnerChange);
		}catch (Exception e){
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "保存犬主变更失败：" + e.getMessage());
		}
	}

	/**
	 * 
	 * @Description：犬主变更订单业务删除
	 * @author: zhuoHeng
	 * @version: 2016年9月6日 下午3:34:16
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:delete")
	@RequestMapping(value = "orderDelete")
	public String orderDelete(DogOwnerChange dogOwnerChange, RedirectAttributes redirectAttributes) {
		dogOwnerChangeService.delete(dogOwnerChange);
		String runningNumber = dogOwnerChange.getRunningNumber();
		addMessage(redirectAttributes, "删除犬主变更申请成功");
		return "redirect:" + Global.getAdminPath() + "/dogownerchange/dogOwnerChange/orderList?runningNumber="
				+ runningNumber + "&repage";
	}

	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = "form")
	public String form(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/dog/dogownerchange/dogOwnerChangeForm";
	}

	/**
	 * 查看
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日下午4:49:53
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:view")
	@RequestMapping(value = "view")
	public String view(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/dog/dogownerchange/dogOwnerChangeView";
	}

	@RequiresPermissions("dogownerchange:dogOwnerChange:edit")
	@RequestMapping(value = "save")
	public String save(DogOwnerChange dogOwnerChange, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogOwnerChange)) {
			return form(dogOwnerChange, model);
		}
		dogOwnerChangeService.edit(dogOwnerChange);
		addMessage(redirectAttributes, "保存犬主变更申请成功");
		String breed = "";
		if ("230".equals(dogOwnerChange.getDog().getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dogownerchange/dogOwnerChange/?repage" + breed;

	}

	@RequiresPermissions("dogownerchange:dogOwnerChange:delete")
	@RequestMapping(value = "delete")
	public String delete(DogOwnerChange dogOwnerChange, RedirectAttributes redirectAttributes) {
		dogOwnerChangeService.delete(dogOwnerChange);
		addMessage(redirectAttributes, "删除犬主变更申请成功");
		String breed = "";
		if ("230".equals(dogOwnerChange.getDog().getDogBreed())) {
			breed = "&dogBreed=230";
		}
		return "redirect:" + Global.getAdminPath() + "/dogownerchange/dogOwnerChange/?repage" + breed;
	}

	/**
	 * 
	 * @Description：打开犬主变更审核页面
	 * @author: zhuoHeng
	 * @version: 2016年8月17日 下午5:04:04
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:audit")
	@RequestMapping(value = "review")
	public String toAuditPage(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/dog/dogownerchange/dogOwnerChangeReview";
	}

	/**
	 * 
	 * @Description：打开犬主变更编辑页面
	 * @author: zhuoHeng
	 * @version: 2016年8月19日 上午10:28:46
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:edit")
	@RequestMapping(value = "edit")
	public String toEditPage(DogOwnerChange dogOwnerChange, Model model) {
		model.addAttribute("dogOwnerChange", dogOwnerChange);
		return "oa/dog/dogownerchange/dogOwnerChangeEdit";
	}

	/**
	 * 
	 * @Description：犬主变更审核状态更改
	 * @author: zhuoHeng
	 * @version: 2016年8月17日 下午6:54:24
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:audit")
	@RequestMapping(value = "changeStatus")
	@ResponseBody
	public String changeStatus(DogOwnerChange dogOwnerChange, Model model) {
		if (!beanValidator(model, dogOwnerChange)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		try {
			dogOwnerChangeService.changeStatus(dogOwnerChange);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

	/**
	 * 
	 * @Description：更改犬主变更处理状态并更新犬主信息
	 * @author: zhuoHeng
	 * @version: 2016年8月20日 下午4:38:21
	 */
	@RequiresPermissions("dogownerchange:dogOwnerChange:process")
	@RequestMapping(value = "process")
	@ResponseBody
	public String processState(DogOwnerChange dogOwnerChange, Model model) {
		if (!beanValidator(model, dogOwnerChange)) {
			return "{\"rc\":-1,\"msg\":\"error\"}";
		}
		try {
			dogOwnerChangeService.changeProcessState(dogOwnerChange);
		} catch (ZAException e) {
			return "{\"rc\":" + e.get_code() + ",\"msg\":\"" + e.getMessage() + "\"}";
		}
		return "{\"rc\":0,\"msg\":\"success\"}";
	}

}