/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.restful.v1.dog.model.RestDogColorMark;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬只颜色及标志Controller
 * @author lgl
 * @version 2016-08-05
 */
@Controller
@RequestMapping(value = "${adminPath}/dogcolormark/dogColorMark")
public class DogColorMarkController extends BaseController {

	@Autowired
	private DogColorMarkService dogColorMarkService;
	
	@ModelAttribute
	public DogColorMark get(@RequestParam(required=false) String id) {
		DogColorMark entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogColorMarkService.get(id);
		}
		if (entity == null){
			entity = new DogColorMark();
		}
		return entity;
	}
	
	@RequiresPermissions("dogcolormark:dogColorMark:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogColorMark dogColorMark, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogColorMark> page = dogColorMarkService.findPage(new Page<DogColorMark>(request, response), dogColorMark); 
		model.addAttribute("page", page);
		return "oa/dog/dogcolormark/dogColorMarkList";
	}

	@RequiresPermissions("dogcolormark:dogColorMark:view")
	@RequestMapping(value = "form")
	public String form(DogColorMark dogColorMark, Model model) {
		model.addAttribute("dogColorMark", dogColorMark);
		return "oa/dog/dogcolormark/dogColorMarkForm";
	}

	@RequiresPermissions("dogcolormark:dogColorMark:edit")
	@RequestMapping(value = "save")
	public String save(DogColorMark dogColorMark, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogColorMark)){
			return form(dogColorMark, model);
		}
		dogColorMarkService.save(dogColorMark);
		addMessage(redirectAttributes, "保存犬只颜色及标志成功");
		return "redirect:"+Global.getAdminPath()+"/dogcolormark/dogColorMark/?repage";
	}
	
	@RequiresPermissions("dogcolormark:dogColorMark:edit")
	@RequestMapping(value = "delete")
	public String delete(DogColorMark dogColorMark, RedirectAttributes redirectAttributes) {
		dogColorMarkService.delete(dogColorMark);
		addMessage(redirectAttributes, "删除犬只颜色及标志成功");
		return "redirect:"+Global.getAdminPath()+"/dogcolormark/dogColorMark/?repage";
	}
	
	/**
	 * 
	 * @description: 根据犬种获取毛色列表
	 * @author: laiguanglong
	 * @date: 2016年9月7日 下午5:07:39
	 */
	@RequestMapping(value = "getByDogBreed")
	@ResponseBody
	public List<RestDogColorMark> getByDogBreedCode(String dogBreedCode){
		return dogColorMarkService.getDogColor(dogBreedCode);
	}
	
	
	
}