/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 犬只鉴定表Entity
 * 
 * @author lgl
 * @version 2016-08-09
 */
public class DogAppraisal extends DataEntity<DogAppraisal> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只信息表主键
	private String dogOwnerCode; // 犬主会员号
	private String dogOwnerName; // 犬主姓名
	private String paymentMemberCode; // 付款会员号
	private String identifyType; // 鉴定类型
	private String identifySite; // 鉴定地点
	private Date identifyDate; // 鉴定时间
	private String identifier; // 鉴定人
	private String mainShowId; // 赛场鉴定主赛事id，show_main表主键
	private String mainShowInfo; // 主赛事信息，由show_code+show_location拼接而成
	private String showAppraisalCode; // 赛场鉴定编号，唯一，用于订单录入是关联赛场鉴定记录
	private String showAppraisalOrderRunningNumber; // 赛场鉴定订单流水号。有值表示已缴费并订单录入了
	private String dogBreed; // 犬种
	private String dogName; // 犬名
	private String dogGender; // 犬只性别
	private String dogFurColor; // 犬只毛色
	private Date birthday; // 犬只出生日期
	private String operator; // 操作人
	private String price; // 价格
	private String dogChip; // 犬只芯片号
	private String dogDnaImage; // 犬只dna图片
	private String dnaPrintFlag; // 犬只DNA鉴定打印标志位：0未打印；1已打印
	private String pedigreeCertified; // 血统证书号
	private String hospitalId; // 医院主键
	private String identifyCode; // 鉴定编号
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核的意见
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private Date processTime; // 流程变更的时间
	private String processState; // 流程状态
	private Date sendDate; // 邮寄日期
	private String stickerFlag;// 申请贴纸标识:0不申请;1申请
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private String breedCnName; // 犬种中文名
	private String dogColorMarkCn; // 犬颜色及标记(中文)
	private String paymentChargingItemId; // 收费项id，用于设置price
	private String chipInject; // 芯片录入

	private String breedEnName; // 犬种英文名
	private String pedigreeCertifiedEn; // 国外血统证书号
	private String printState; // dog表的打印状态
	private String chongaiCertificateCode; // 宠爱证书编号

	private String showAppraisalPrintFlag; // 赛场鉴定打印标记位：不可打印0，可以打印1。
	private Integer before;// 赛场犬只鉴定报名截至日期比赛事开始日期提前的天数。在赛事开始日期的基础上提前的天数
	private String isFinishOrder;// 赛场鉴定是否完成订单录入标记位
	private String businessState; // 业务状态

	// 赛场打印所需信息
	private String memberMobile;
	private String memberAddress;

	private Dog dog;

	private String videoAppraisalId;
	private String dogNose;
	private String businessRefundState;//订单状态
	
	private String dogPedigreeCertifiedRedoId;
	private String dna;
	public DogAppraisal() {
		super();
	}

	public DogAppraisal(String id) {
		super(id);
	}

	public DogAppraisal(String runningNumber, String paymentChargingItemId, String paymentMemberCode) {
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min = 0, max = 64, message = "犬主会员号长度必须介于 0 和 64 之间")
	public String getDogOwnerCode() {
		return dogOwnerCode;
	}

	public void setDogOwnerCode(String dogOwnerCode) {
		this.dogOwnerCode = dogOwnerCode;
	}

	@Length(min = 0, max = 64, message = "犬主姓名长度必须介于 0 和 64 之间")
	public String getDogOwnerName() {
		return dogOwnerName;
	}

	public void setDogOwnerName(String dogOwnerName) {
		this.dogOwnerName = dogOwnerName;
	}

	@Length(min = 0, max = 64, message = "付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "鉴定类型长度必须介于 0 和 64 之间")
	public String getIdentifyType() {
		return identifyType;
	}

	public void setIdentifyType(String identifyType) {
		this.identifyType = identifyType;
	}

	@Length(min = 0, max = 64, message = "鉴定地点长度必须介于 0 和 64 之间")
	public String getIdentifySite() {
		return identifySite;
	}

	public void setIdentifySite(String identifySite) {
		this.identifySite = identifySite;
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public String getMainShowId() {
		return mainShowId;
	}

	public void setMainShowId(String mainShowId) {
		this.mainShowId = mainShowId;
	}

	public String getMainShowInfo() {
		return mainShowInfo;
	}

	public void setMainShowInfo(String mainShowInfo) {
		this.mainShowInfo = mainShowInfo;
	}

	public String getShowAppraisalCode() {
		return showAppraisalCode;
	}

	public void setShowAppraisalCode(String showAppraisalCode) {
		this.showAppraisalCode = showAppraisalCode;
	}

	public String getShowAppraisalOrderRunningNumber() {
		return showAppraisalOrderRunningNumber;
	}

	public void setShowAppraisalOrderRunningNumber(String showAppraisalOrderRunningNumber) {
		this.showAppraisalOrderRunningNumber = showAppraisalOrderRunningNumber;
	}

	@Length(min = 0, max = 64, message = "犬种长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 0, max = 64, message = "犬名长度必须介于 0 和 64 之间")
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	@Length(min = 0, max = 64, message = "犬只性别长度必须介于 0 和 64 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	@Length(min = 0, max = 64, message = "犬只毛色长度必须介于 0 和 64 之间")
	public String getDogFurColor() {
		if(StringUtils.isNotBlank(dogFurColor) ) {
			return StringEscapeUtils.unescapeHtml4(dogFurColor.replace("&AMP;", "&amp;"));
		}
		return dogFurColor;
	}

	public void setDogFurColor(String dogFurColor) {
		this.dogFurColor = dogFurColor;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	@Length(min = 0, max = 64, message = "操作人长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 64, message = "犬只芯片号长度必须介于 0 和 64 之间")
	public String getDogChip() {
		return dogChip;
	}

	public void setDogChip(String dogChip) {
		this.dogChip = dogChip;
	}

	@Length(min = 0, max = 128, message = "犬只dna图片长度必须介于 0 和 128 之间")
	public String getDogDnaImage() {
		return dogDnaImage;
	}

	public void setDogDnaImage(String dogDnaImage) {
		this.dogDnaImage = dogDnaImage;
	}

	public String getDnaPrintFlag() {
		return dnaPrintFlag;
	}

	public void setDnaPrintFlag(String dnaPrintFlag) {
		this.dnaPrintFlag = dnaPrintFlag;
	}

	@Length(min = 0, max = 64, message = "血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 0, max = 64, message = "医院主键长度必须介于 0 和 64 之间")
	public String getHospitalId() {
		return hospitalId;
	}

	public void setHospitalId(String hospitalId) {
		this.hospitalId = hospitalId;
	}

	@Length(min = 0, max = 64, message = "鉴定编号长度必须介于 0 和 64 之间")
	public String getIdentifyCode() {
		return identifyCode;
	}

	public void setIdentifyCode(String identifyCode) {
		this.identifyCode = identifyCode;
	}

	@Length(min = 0, max = 20, message = "审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 255, message = "审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min = 0, max = 20, message = "流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getSendDate() {
		return sendDate;
	}

	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getDogColorMarkCn() {
		return dogColorMarkCn;
	}

	public void setDogColorMarkCn(String dogColorMarkCn) {
		this.dogColorMarkCn = dogColorMarkCn;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getBreedEnName() {
		return breedEnName;
	}

	public void setBreedEnName(String breedEnName) {
		this.breedEnName = breedEnName;
	}

	public String getPedigreeCertifiedEn() {
		return pedigreeCertifiedEn;
	}

	public void setPedigreeCertifiedEn(String pedigreeCertifiedEn) {
		this.pedigreeCertifiedEn = pedigreeCertifiedEn;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getIdentifyDate() {
		return identifyDate;
	}

	public void setIdentifyDate(Date identifyDate) {
		this.identifyDate = identifyDate;
	}

	public String getChongaiCertificateCode() {
		return chongaiCertificateCode;
	}

	public void setChongaiCertificateCode(String chongaiCertificateCode) {
		this.chongaiCertificateCode = chongaiCertificateCode;
	}

	public String getShowAppraisalPrintFlag() {
		return showAppraisalPrintFlag;
	}

	public void setShowAppraisalPrintFlag(String showAppraisalPrintFlag) {
		this.showAppraisalPrintFlag = showAppraisalPrintFlag;
	}

	public Integer getBefore() {
		return before;
	}

	public void setBefore(Integer before) {
		this.before = before;
	}

	public String getIsFinishOrder() {
		return isFinishOrder;
	}

	public void setIsFinishOrder(String isFinishOrder) {
		this.isFinishOrder = isFinishOrder;
	}

	public String getBusinessState() {
		return businessState;
	}

	public void setBusinessState(String businessState) {
		this.businessState = businessState;
	}

	public String getMemberMobile() {
		return memberMobile;
	}

	public void setMemberMobile(String memberMobile) {
		this.memberMobile = memberMobile;
	}

	public String getMemberAddress() {
		return memberAddress;
	}

	public void setMemberAddress(String memberAddress) {
		this.memberAddress = memberAddress;
	}

	public Dog getDog() {
		return dog;
	}

	public void setDog(Dog dog) {
		this.dog = dog;
	}

	public String getChipInject() {
		return chipInject;
	}

	public void setChipInject(String chipInject) {
		this.chipInject = chipInject;
	}

	public String getVideoAppraisalId() {
		return videoAppraisalId;
	}

	public void setVideoAppraisalId(String videoAppraisalId) {
		this.videoAppraisalId = videoAppraisalId;
	}

	public String getDogNose() {
		return dogNose;
	}

	public void setDogNose(String dogNose) {
		this.dogNose = dogNose;
	}

	public String getBusinessRefundState() {
		return businessRefundState;
	}

	public void setBusinessRefundState(String businessRefundState) {
		this.businessRefundState = businessRefundState;
	}

	public String getDogPedigreeCertifiedRedoId() {
		return dogPedigreeCertifiedRedoId;
	}

	public void setDogPedigreeCertifiedRedoId(String dogPedigreeCertifiedRedoId) {
		this.dogPedigreeCertifiedRedoId = dogPedigreeCertifiedRedoId;
	}

	public String getDna() {
		return dna;
	}

	public void setDna(String dna) {
		this.dna = dna;
	}
	
	
}