package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.show.entity.ChildShows;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestWinner;
import com.cku.oa.contest.service.ContestWinnerService;

/**
 * 犬展活动区域成绩Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestWinner")
public class ContestWinnerController extends BaseController {

	@Autowired
	private ContestWinnerService contestWinnerService;
	
	@ModelAttribute
	public ContestWinner get(@RequestParam(required=false) String id) {
		ContestWinner entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestWinnerService.get(id);
		}
		if (entity == null){
			entity = new ContestWinner();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestWinner:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestWinner contestWinner, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestWinner> page = contestWinnerService.findPage(new Page<ContestWinner>(request, response), contestWinner); 
		model.addAttribute("page", page);
		return "oa/contest/contestWinnerList";
	}

	@RequiresPermissions("contest:contestWinner:view")
	@RequestMapping(value = "form")
	public String form(ContestWinner contestWinner, Model model) {
		model.addAttribute("contestWinner", contestWinner);
		return "oa/contest/contestWinnerForm";
	}

	@RequiresPermissions("contest:contestWinner:edit")
	@RequestMapping(value = "save")
	public String save(ContestWinner contestWinner, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestWinner)){
			return form(contestWinner, model);
		}
		contestWinnerService.save(contestWinner);
		addMessage(redirectAttributes, "保存犬展活动区域成绩成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestWinner/?repage";
	}
	
	@RequiresPermissions("contest:contestWinner:del")
	@RequestMapping(value = "delete")
	public String delete(ContestWinner contestWinner, RedirectAttributes redirectAttributes) {
		contestWinnerService.delete(contestWinner);
		addMessage(redirectAttributes, "删除犬展活动区域成绩成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestWinner/?repage";
	}

	@RequiresPermissions("contest:contestWinner:createResult")
	@RequestMapping(value = "createResult", method= RequestMethod.GET)
	public String createResult(@RequestParam(required=true) String id, RedirectAttributes redirectAttributes) {
		try {
			contestWinnerService.createResult(id);
		} catch (Exception e) {
			addMessage(redirectAttributes, "生成犬展成绩失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/show.child/childShows/?repage";
	}

}