package com.cku.oa.breeder.service;

import com.cku.oa.breeder.dao.WhitelistDao;
import com.cku.oa.breeder.entity.Whitelist;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 白名单表Service
 *
 * @author lgl
 * @version 2018-01-16
 */
@Service
@Transactional(readOnly = true)
public class WhitelistService extends CrudService<WhitelistDao, Whitelist> {

    public Whitelist get(String id) {
        return super.get(id);
    }

    public List<Whitelist> findList(Whitelist whitelist) {
        return super.findList(whitelist);
    }

    public Page<Whitelist> findPage(Page<Whitelist> page, Whitelist whitelist) {
        return super.findPage(page, whitelist);
    }

    @Transactional(readOnly = false)
    public void save(Whitelist whitelist) {
        super.save(whitelist);
    }

    @Transactional(readOnly = false)
    public void delete(Whitelist whitelist) {
        super.delete(whitelist);
    }

    /**
     * @description: 是否在白名单，返回true表示在白名单中
     * @author: laiguanglong
     * @date: 2018/1/16 9:56
     */
    public boolean isInWhitelist(String memberCode, String userId, String module) {
        boolean flag = false;
        if (dao.getCount(memberCode, userId, module) > 0) {
            flag = true;
        }
        return flag;
    }
}