/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.activity.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 会员续费参与活动记录DAO接口
 * 
 * @author Sunny
 * @version 2019-12-05
 */
@MyBatisDao
public interface SysMemberActivityRecordDao extends CrudDao<SysMemberActivityRecord> {

	int saveRecord(SysMemberActivityRecord sysMemberActivityRecord);

	SysMemberActivityRecord getOneEntity(SysMemberActivityRecord sysMemberActivityRecord);

	List<SysMemberActivityRecord> getListByMemberId(@Param("id") String id);

	SysMemberActivityRecord getOneByActivityTypeAndmemberCode(@Param("activityType") String activityType,
			@Param("memberCode") String memeberCode);

	// 按照日期段查询会员优惠活动记录
	List<SysMemberActivityRecord> selectGroomerPromotion(@Param("memberCode") String memberCode,
			@Param("startDate") String startDate, @Param("endDate") String endDate);

	List<SysMemberActivityRecord> selectPromotion(@Param("memberCode") String memberCode,
			@Param("orderCode") String orderCode, @Param("startDate") String startDate,
			@Param("endDate") String endDate);

	SysMemberActivityRecord getOneByOrderCode(@Param("orderCode") String orderCode);

	SysMemberActivityRecord getFirstOne(@Param("memberCode") String memberCode);

	SysMemberActivityRecord getPKOne(@Param("memberCode") String memberCode);
}