//新生犬登记申请列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        var updateFlag = false;
        me.member = ko.observable({});
        //列表数据
        me.listData = ko.observableArray([]);
        //出生证明号
        me.birthCode = ko.observable("");
        //出生证明号
        me.pedigreeCertified = ko.observable("");
        //出生证明号
        me.originMemberCode = ko.observable("");
        //出生证明号
        me.semenCode = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //省市
        me.provinceList = ko.observableArray([]);
        me.provinceHtml = ko.observable("请选择地区");
        //医院列表
        me.hospitalList = ko.observableArray([]);
        me.hospitalCode = ko.observable("");
        //医院的显隐
        me.isShowHospital = ko.observable(false);
        me.hospitalText = ko.observable("请选择合作机构");
        
        //原因显隐
        me.showMessage= ko.observable(false);
        //详细数据
        me.detailData = ko.observable({
            pedigreeCertified:"",
            dogChip:"",
            dogBreed:"",
            dogName:"",
            dogOwner:"",
            originMemberCode:"",
            originMemberName:"",
            newMemberCode:"",
            newMemberName:"",
            createDate:"",
            semenNumber:"",
            dogSemenList:[]
        });
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findnewdogchipList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findnewdogchipList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findnewdogchipList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findnewdogchipList(false);
            }
            return false;
        }
        /**
         * 新生犬登记申请查询方法
         */
        me.findnewdogchipList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["type"] = "new";
            sendData["pedigreeCertified"] = me.pedigreeCertified().trim();
            sendData["originMemberCode"] = me.originMemberCode().trim();
            sendData["semenCode"] = me.semenCode().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogSemenChange',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //未通过原因的显隐
        me.showReason = function(data,event){
            if(data.businessState=="原主人未通过"||data.businessState=="协会未通过") {
                if ($(event.target).parent("a").siblings(".reason").css("display") == "none") {
                    $(event.target).parent("a").siblings(".reason").css("display", "block");
                } else {
                    $(event.target).parent("a").siblings(".reason").css("display", "none");
                }
            }
        }
        me.closeReason = function(data,event){
            $(event.target).parents(".reason").css("display","none")
        }

        //展示申请页弹出窗
        me.showNewMask = function(){
            $("#newmask").css("display","block");
    		  
            //location.href = location.href.split("#")[0]+"#/dog/newdogchipadd";
        }
        //展示查看页
        me.showCszmask = function(){
        	$("#viewMask").css("display","block");
        }
        //关闭mask
        me.closemask  = function(type){
            $("#"+type).css("display","none");
        }
        //申请弹出窗验证
        me.checkBirthCode = function(){
            var newBirthCode = $("#newBirthCode").val();
            util.sendAjax({
                url: 'dog/newdogchip/checkBirthCode',
                data: {birthCode:newBirthCode},
                async: false,
                loadFlag: true,
                type: 'GET',
                cache: false,
                success: function (data) {
                    if (data.rc == 0) {
                        location.href = location.href.split("#")[0]+"#/dog/newdogchipadd?birthCode="+newBirthCode+"&isNewDogBirthCertificate="+data.data.isNewDogBirthCertificate;
                    } else {
                        layer.msg("血统证书申请失败:" + data.msg);
                    }
                }
            });
        }
        //血统证书详情
        me.getDetail = function(data){
            $("#viewMask").css("display","inline-block");
            util.sendAjax({
                url:'dog/dogSemenChange/'+data.id,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    me.detailData(json.data);
                    if(json.rc==0){
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }
        //未审核及已通过可以修改
        me.changeMsg = function(data,event){
            if(data.businessState=="已通过"){
                $("#updateBtn").attr("class","old");
                $(".updateshowem").css("display","inline-block");
                $(".updateshowbtn").css("display","none");
                $("#oldOrg").css("display","block");
                $("#newOrg1").css("display","none");
                $("#newOrg2").css("display","none");
                $("#newOrg3").css("display","none");
                updateFlag = false;
                util.sendAjax({
                    url:'dog/newdogchip/'+data.id,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        me.detailData(json.data);
                        if(json.data.reviewState=='未通过'||json.data.reviewState=='已注销'){
                        	me.showMessage(true);
                        }else{
                        	me.showMessage(false);
                        }
                        if(json.rc==0){
                                $("#updatemask").css("display","block");
                                //me.getDogColorList(json.data.dogBreed);
                        }else{
                            layer.msg("信息查询失败:"+data.msg);
                        }
                    }
                });
            }
        }
        //修改弹出框点击修改按钮
        me.updateClick = function(){
        	updateFlag = true;
            $("#updateBtn").attr("class","xg");
            $("#oldOrg").css("display","none");
            $("#newOrg1").css("display","block");
            $("#newOrg2").css("display","block");
            $("#newOrg3").css("display","block");
            $(".updateshowem").css("display","none");
            $(".updateshowbtn").css("display","inline-block");
        }
        me.updateOrg = function(){
            //修改
        	if(updateFlag){
        		var updateData = {};
                updateData["id"] =  me.detailData().id;
                updateData["hospitalCode"] = me.hospitalCode() ;
                util.sendAjax({
                    url:'dog/newdogchip',
                    data: JSON.stringify(updateData),
                    async:false,
                    type:'PUT',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            layer.msg("修改成功!");
                            $("#updatemask").css("display","none");
                            me.findnewdogchipList(false);
                        }else{
                            layer.msg("修改失败："+json.msg);
                        }
                    }
                });
        	} else {
        		$("#updatemask").css("display","none");
        	}
        }
        /**
         * 撤销新生犬登记申请
         */
        me.delnewdogchip = function(data, event){
            //询问框
            if(data.isCanceled!='1'&&data.reviewState=="通过"&&data.canCanceled==true) {
                var delnewdogchiplayer = layer.confirm('是否确认撤销血统证书申请?', {
                    btn: ['确定', '关闭'] //按钮
                }, function () {
                    var id = data.id;
                    util.sendAjax({
                        url: 'dog/newdogchip/canceled/'+id,
                        data: {},
                        async: true,
                        loadFlag: true,
                        type: 'PUT',
                        cache: false,
                        success: function (data) {
                            if (data.rc == 0) {
                                layer.close(delnewdogchiplayer);
                                layer.msg("新生犬登记申请撤销成功！");
                                me.findnewdogchipList(false);
                            } else {
                                layer.msg("新生犬登记申请撤销失败:" + data.msg);
                            }
                        }
                    });
                });
            }
        }
        //地址的选择
        me.showProvince = function(){
            if($("#provinceDiv").css("display")=="none"){
                $("#provinceDiv").css("display","block");
            }else{    
            	$("#provinceDiv").css("display","none");
            }
        }
        me.changeProvince = function(data){
            me.member().province = data;
            me.provinceHtml(data);
            me.hospitalText("请选择合作机构");
            me.hospitalCode(" ");
            me.isShowHospital(false);
            for(var i = 0;i<util.city.length;i++){
                if(data==util.city[i].local){
                    me.initProCity(data);
                }
            }
            $("#provinceDiv").css("display","none");
            me.getHospital(data);
        }
        me.initProCity = function(province){
            me.provinceList().length = 0;
            for(var i = 0;i<util.city.length;i++){
                me.provinceList.push(util.city[i].local);
            }
        }
        //获取医院
        me.getHospital = function(province){
            var sendData = {};
            sendData["provinceName"] = province;
            util.sendAjax({
                url:'org',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length<=0){
                            $("#emptyShow").show();
                            me.hospitalList(data.list);
                        }else if(data.list.length>0){
                            $("#emptyShow").hide();
                            me.hospitalList(data.list);
                        }
                    }else{
                        layer.msg("合作机构查询失败:"+data.msg);
                    }
                }
            });
        }
        //医院的显示隐藏事件
        me.showHospital = function(){
            //me.isShowHospital(!me.isShowHospital());
            if($("#allHospital").css("display")=="none"){
                $("#allHospital").css("display","block");
            }else{
                $("#allHospital").css("display","none");
            }
        }
        //选择医院
        me.chooseHospital = function(data,event){
            me.hospitalCode(data.id);
            me.hospitalText(data.name);
           // me.isShowHospital(!me.isShowHospital());
            $("#allHospital").css("display","none");
            $("#allHospital li").removeAttr("class");
            $(event.target).parents("li").attr("class","active");
        }
        $(function(){
            me.findnewdogchipList(false);
            me.member(userInfo.getMember());
            if(me.member().memberType!="professional"||me.member().paymentState!="2"){
                layer.alert('只有有效专业会员才能办理此业务，请先缴费', {
                    time: 0 //不自动关闭
                    ,btn: ['缴费', '关闭']
                    ,yes: function(index){
                        layer.close(index);
                        location.href = location.href.split("#")[0]+"#home";
                    }
                });
            }
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});