//出口证书列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //血统证书号
        me.pedigreeCertified = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogexportList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddogexportList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogexportList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogexportList(false);
            }
            return false;
        }
        /**
         * 血统证书列表查询方法
         */
        me.finddogexportList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["pedigreeCertified"] = me.pedigreeCertified().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogexport',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("出口证书列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //撤销说明的显隐
        me.showReason = function(data,event){
            if(data.reviewState=="不通过"||data.reviewState=="未通过") {
                if ($(event.target).parent("a").siblings(".reason").css("display") == "none") {
                    $(event.target).parent("a").siblings(".reason").css("display", "block");
                } else {
                    $(event.target).parent("a").siblings(".reason").css("display", "none");
                }
            }
        }
        me.closeReason = function(){
            $(event.target).parents(".reason").css("display","none");
        }
        $(function(){
            me.finddogexportList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
