<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dog">犬只信息列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dog" action="${ctxDc}/dog" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		    <li><label>证书号/芯片号：</label>
                <form:input path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            <li><label>国外证书号：</label>
                <form:input path="pedigreeCertifiedEn" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>英文姓名：</label>
				<form:input path="nameEn" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>出生日期：</label>
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>毛色：</label>
				<form:input path="colorFlag" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>出生纸编号：</label>
				<form:input path="birthCertificateLevelCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬主人/会员号：</label>
				<form:input path="dogOwner" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>父血统证书号：</label>
				<form:input path="fdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>母血统证书号：</label>
				<form:input path="mdogPedigreeCertified" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>犬只状态：</label>
                <form:select path="dogState" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('dogState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>DNA留存方式：</label>
                <form:select path="dnaSaveWay" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:options items="${fns:getDictList('dna_save_way')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </li>
			<li><label>犬只代数：</label>
				<form:input path="dogGeneration" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
			<li><label>双亲比对：</label>
                <form:select path="isDnaParentsCompare" class="input-medium">
                    <form:option value="" label="全部"/>
                    <form:option value="1" label="是"/>
                    <form:option value="0" label="否"/>
                </form:select>
            </li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书号</th>
				<th>性别</th>
				<th>英文姓名</th>
				<th>种类</th>
				<th>出生日期</th>
				<th>毛色</th>
				<th>芯片号</th>
				<th>DNA留存方式</th>
				<th>双亲比对</th>
				<th>犬主人</th>
				<th>犬只代数</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dog">
			<tr>
				<td>
					${fns:escapeHtml(dog.pedigreeCertifiedCode) }
				</td>
				<td>
					${fns:getDictLabel(dog.gender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dog.nameEn)}
				</td>
				<td>
					${fns:escapeHtml(dog.dogBreed) }
				</td>
				<td>
					<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dog.colorFlag) }
				</td>
				<td>
					${fns:escapeHtml(dog.identificationFlag) }
				</td>
				<td>
						${fns:getDictLabel(dog.dnaSaveWay, 'dna_save_way', '')}
				</td>
				<td>
					<c:if test="${dog.isDnaParentsCompare=='1'}">是</c:if>
				</td>
				<td title="${fns:escapeHtml(dog.memberCode)}">
					${fns:escapeHtml(dog.dogOwner)}
					<c:if test="${dog.secondDogOwner!=''&&dog.secondDogOwner!=null}">/${fns:escapeHtml(dog.secondDogOwner) }</c:if>
				</td>
				<td>
				    ${fns:escapeHtml(dog.dogGeneration) }
				</td>
				<td>
                    <a href="${ctxDc}/dog/view?id=${dog.id}">查看</a>
				<shiro:hasPermission name="dog:dog:edit">
    				<a href="${ctx}/dog/dog/form?id=${dog.id}">编辑</a>
    			</shiro:hasPermission>
    			<shiro:hasPermission name="dog:dog:print">
    			<c:if test="${dog.printState=='1'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">鉴定证书打印</a></c:if>
    			<c:if test="${dog.printState=='2'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">血统证书打印</a></c:if>
    			<c:if test="${dog.printState=='3'}"><a onclick="print('${ctx}/dog/dog/print?id=${dog.id}');" href="###">出口证书打印</a></c:if>
				</shiro:hasPermission>
    			<shiro:hasPermission name="dog:dog:resetPrint">
    				<c:if test="${fn:length(dog.printState)==2&&fn:startsWith(dog.printState,'0')}">
					<a href="###" onclick="resetPrint('${ctx}/dog/dog/resetPrint?id=${dog.id}');">重置打印</a>
					</c:if>
				</shiro:hasPermission>
    			<shiro:hasPermission name="dog:dog:delete">
					<a href="${ctx}/dog/dog/delete?id=${dog.id}" onclick="return confirmx('确认要删除该犬只信息吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>