<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容课程管理</title>
	<meta name="decorator" content="default"/>
	<%--<script type="text/javascript" src="${ctxStatic}/wangEditor/js/wangEditor.js"></script>--%>
	<script type="text/javascript" src="${ctxStatic}/wangEditor/js/wangEditor.min.js"></script>

	<script type="text/javascript">
		var editor;
		$(document).ready(function() {
			typeChoose();
			$("#videoUrl2").hide();
			var qualifications = $("#qualifications").val();
			if(qualifications == '1'){
				$("#type option[value='1']").remove();
			}
			editor = new wangEditor('courseDetails');<%--// 上传图片（举例）--%>
			editor.config.uploadImgUrl = '${ctxSchools}/schoolsCourse/editorUpload';
			editor.config.uploadImgFileName = 'editorImg';
			editor.create();
			$("#viewButton").click(function(){
				var sHTML = editor.$txt.html();
				$("#previewContent").html(sHTML);
				$("#previewbox").show();
			});
		});

		function deleteImg(type){
			$("#"+type+"Show").attr("src","");
			$("#"+type+"Show").val("");
			$("#"+type).val("");
		}
		function deleteVideo(type){
			$("#videoUrl2").attr("src","");
			$("#videoUrl").attr("src","");
			$("#videoUrl2").val("");
			$("#videoUrl").val("");
			$("#"+type).val("");
		}
		function submitMsg() {
			var courseName = $("#courseName").val();
			if( courseName == "" ){
				$.jBox.alert("课程名称不能为空","提示");
				return;
			}
			var str = /^[a-zA-Z0-9_\u4e00-\u9fa5]+$/;
            if(!str.test(courseName)){
                $.jBox.alert("课程名称不能包含特殊字符","提示");
                return;
            }
			var type = $("#type").val();
			var video = $("#video").val();

			if( type == "" ){
				$.jBox.alert("课程类型不能为空","提示");
				return;
			}
			var cover = $("#cover").val();
			if(type != "3"  && cover == "" ){
				$.jBox.alert("课程封面不能为空","提示");
				return;
			}
			if(type == "1" ){
				var registrationStarteTime = $("#registrationStarteTime").val();
				var registrationEndTime = $("#registrationEndTime").val();
				if( registrationStarteTime == "" ||  registrationEndTime == ""){
					$.jBox.alert("报名时间不能为空","提示");
					return;
				}
				var startDate = $("#startDate").val();
				var endDate = $("#endDate").val();
				if( startDate == "" ||  endDate == ""){
					$.jBox.alert("培训时间不能为空","提示");
					return;
				}
				var pic1 = $("#pic1").val();
				var pic2 = $("#pic2").val();
				var pic3 = $("#pic3").val();
				if(pic1 == "" && pic2 == "" && pic3 == ""){
					$.jBox.alert("线下培训课需上传课程介绍图","提示");
					return;
				}
				var price = $("#price").val();
				if( price == "" || parseFloat(price) < parseFloat("1000.00")){
					$.jBox.alert("课程价格不能为空且不能小于1000","提示");
					return;
				}
			}
			var diplomaLevel = $("#diplomaLevel").val();
			if( diplomaLevel == "" ){
				$.jBox.alert("课程等级不能为空","提示");
				return;
			}
			if(type == "2" && video == "" ){
				$.jBox.alert("线上公开课需上传课程视频","提示");
				return;
			}
			var courseName = $("#courseName").val();
			if( courseName == "" ){
				$.jBox.alert("课程名称不能为空","提示");
				return;
			}

			var states = $("#states").val();
			if( states == "" ){
				$.jBox.alert("课程状态不能为空","提示");
				return;
			}

			var teacher = $("#teacher").val();
			if( teacher == "" ){
				$.jBox.alert("课程讲师不能为空","提示");
				return;
			}
			var courseDetails = $("#courseDetails").val();
			var text = editor.$txt.text();
			var str = text.replace(/\s+/g, "");//先去除空格
			var str2 = str.replace(/&nbsp+/g, "");//再去除&nbsp;
			if(type != 3 && (courseDetails == "" || !str2 )){
				$.jBox.alert("课程详情不能为空","提示");
				return;
			}

			$("#inputForm").submit();
		}
		function typeChoose() {
			var type = $("#type").val();
			if( type == "2" ) {
				$("#coverDiv").show();
				$("#introduceDiv").show();
				$("#videoDiv").show();
				$("#states").attr("readonly",false);
				$("#price").attr("readonly", true);
				$("#price").val(0);
				$("#registrationStarteTime").val("");
				$("#registrationEndTime").val("");
				$("#startDate").val("");
				$("#endDate").val("");
				$("#registrationStarteTime").attr("disabled", true);
				$("#registrationEndTime").attr("disabled", true);
				$("#startDate").attr("disabled", true);
				$("#endDate").attr("disabled", true);
				var count = $('#diplomaLevel').find('option').length;
				if (count < 5) {
					$("#diplomaLevel").append("<option value='none'>无</option>");
					$("#diplomaLevel").trigger('change');
				}
			}else if( type == "3" ){
				$("#coverDiv").hide();
				$("#introduceDiv").hide();
				$("#videoDiv").hide();
				$("#price").attr("readonly",false);
				$("#registrationStarteTime").attr("disabled",false);
				$("#registrationEndTime").attr("disabled",false);
				$("#startDate").attr("disabled",false);
				$("#endDate").attr("disabled",false);
				$("#states").val("1");
				$("#states").trigger('change');
				$("#states").attr("readonly",true);
				$("#diplomaLevel option[value='none']").remove();
			}else{
				$("#coverDiv").show();
				$("#introduceDiv").show();
				$("#videoDiv").show();
				$("#states").attr("readonly",false);
				$("#diplomaLevel option[value='none']").remove();
				$("#price").attr("readonly",false);
				$("#registrationStarteTime").attr("disabled",false);
				$("#registrationEndTime").attr("disabled",false);
				$("#startDate").attr("disabled",false);
				$("#endDate").attr("disabled",false);
			}
		}
		function searchTeacher(){
			var teacher=$("#teacher").val();
			if (teacher=='') {
				$.jBox.alert("请输入讲师编号/姓名!");
				return false;
			}
			$.ajax({
				type:"POST",
				url: "${ctxSchools}/schoolsTeacher/findTeacher",
				data : {'teacherName':teacher},
				dataType: 'json',
				async: false,
				success: function(jsons){
					if(jsons.rc==1){
						alert(jsons.msg);
					}else{
						$("#name").show();
						$("#name").text(jsons.name);
						$("#teacher").val(jsons.name);
						$("#teacherId").val(jsons.id);
					}
				}
			});
		}
		function previewboxClose(){
			$("#previewbox").hide();
			$("#previewContent").html("");
		}
		function uuid() {
			var s = [];
			var hexDigits = "0123456789abcdef";
			for (var i = 0; i < 36; i++) {
				s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
			}
			s[14] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
			s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
			s[8] = s[13] = s[18] = s[23] = "-";

			var uuid = s.join("");
			return uuid;
		}

	</script>
	<!--引入wangEditor.css-->
	<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
	<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
	<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
	<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
	<script src="${ctxStatic}/oss/aliyun-oss-sdk-6.11.2.min.js"></script>
	<style>
		#previewbox {
			position: fixed;
			z-index: 999999999;
			display: none;
			top: 0px;
			bottom: 100px;
			width: 800px;
			height: 1000px;
			background-color: #7ab5d3;
			margin: 50px 50px;
			background-size: contain;
			padding: 120px 25px 116px 25px;
		}

		.preview-title{
			font-size: 15px; font-weight: 700;
		}
		.preview-author{
			color: rgb(96, 127, 166); font-size: 12px;cursor:pointer;
		}
		.preview-date{
			color: rgb(140, 140, 140); font-size: 12px; font-style: normal;
		}
		.preview-content{
			height: 100%; padding-right: 0px;overflow-y: scroll;overflow-x: hidden;
		}
		.preview-close{
			top: 0px; width: 50px; height: 50px; right: -17px; font-size: 30px; font-weight: 700; position: absolute; cursor: pointer;
		}
		.preview-content::-webkit-scrollbar{
			width:2px;
		}
		.wangEditor-drop-panel table.choose-table {
			color: #7FD5C8;
		}
		.wangEditor-drop-panel table.choose-table td {
			color: #7FD5C8;
		}

	</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">美容课程${not empty groomerCourse.id?'修改':'添加'}</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerCourse" action="${ctxSchools}/schoolsCourse/save" method="post" class="form-horizontal"
	enctype="multipart/form-data" >
		<form:hidden path="id"/>
		<form:hidden path="schoolId" value="${trainingInstitution.id}"/>
		<input id="qualifications" type="hidden" value="${trainingInstitution.qualifications}"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">课程名称：</label>
			<div class="controls">
				<form:input path="courseName" htmlEscape="false" maxlength="20" class="input-xlarge required stringCheck" placeholder="请输入名称 " />
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程类型：</label>
			<div class="controls">
				<form:select path="type" class="input-medium required" onclick="typeChoose()">
					<form:options items="${fns:getDictList('course_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<c:if test="${groomerCourse.states == 4}">
			<div class="control-group">
				<label class="control-label">审核不通过原因：</label>
				<div class="controls">
						${groomerCourse.reviewRemarks}
				</div>
			</div>
		</c:if>
		<div class="control-group" id="coverDiv">
			<label class="control-label">课程封面：</label>
			<div class="controls">
				<c:if test="${empty groomerCourse.cover }">
					<div><img  id="coverShow"src=""></div>
				</c:if>
				<input id="coverBtn" type="file" name="file" lay-type="image" lay-title="请上传课程封面" class="layui-upload-file" lay-data="{size:'500'}"  accept="image/png,image/jpg">
				<span><a class="btn btn-success" onclick="deleteImg('cover')">删除图片</a></span>
				<form:input path="cover" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					layui.upload({
						url: '${ctxSchools}/schoolsCourse/layupload'
						,elem: "#coverBtn" //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#cover").val(res.id);
							$("#coverShow").attr("src",res.url);
							$("#coverShow").attr("style","width: 150px;height: 150px;");
						}
					});
				</script>
				<font color="red">600*400只能上传JPG/PNG文件。且不超过500KB</font>
			</div>
		</div>
		<div class="control-group" style="width: 100%" id="introduceDiv">
			<label class="control-label">课程介绍图：</label>
			<div class="controls" style="width: 170px; float: left">
				<c:if test="${empty groomerCourse.introduce }">
					<div><img  id="pic1Show"src=""></div>
				</c:if>
				<input id="introduceImage1" type="file" name="file" lay-type="image" lay-title="请上传课程介绍图" class="layui-upload-file" accept="image/png,image/jpg">
				<span><a class="btn btn-success" onclick="deleteImg('pic1')">删除图片</a></span>
				<form:input path="pic1" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					layui.upload({
						url: '${ctxSchools}/schoolsCourse/layupload'
						,elem: '#introduceImage1' //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#pic1").val(res.id);
							$("#pic1Show").attr("src",res.url);
							$("#pic1Show").attr("style","width: 150px;height: 150px;");
						}
					});
				</script>
			</div>
			<div class="controls" style="width: 170px; float: left">
				<c:if test="${empty groomerCourse.introduce }">
					<div><img  id="pic2Show" src=""></div>
				</c:if>
				<input id="introduceImage2" type="file" name="file" lay-type="image" lay-title="请上传课程介绍图" class="layui-upload-file" accept="image/png,image/jpg">
				<span><a class="btn btn-success" onclick="deleteImg('pic2')">删除图片</a></span>
				<form:input path="pic2" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					layui.upload({
						url: '${ctxSchools}/schoolsCourse/layupload'
						,elem: '#introduceImage2' //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#pic2").val(res.id);
							$("#pic2Show").attr("src",res.url);
							$("#pic2Show").attr("style","width: 150px;height: 150px;");

						}
					});
				</script>
			</div>
			<div class="controls" style="width: 170px; float: left">
				<c:if test="${empty groomerCourse.introduce }">
					<div><img  id="pic3Show" ssrc=""></div>
				</c:if>
				<input id="introduceImage3" type="file" name="file" lay-type="image" lay-title="请上传课程介绍图" class="layui-upload-file" accept="image/png,image/jpg">
				<span><a class="btn btn-success" onclick="deleteImg('pic3')">删除图片</a></span>
				<form:input path="pic3" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					layui.upload({
						url: '${ctxSchools}/schoolsCourse/layupload'
						,elem: '#introduceImage3' //指定原始元素，默认直接查找class="layui-upload-file"
						,method: 'POST' //上传接口的http类型
						,success: function(res){
							$("#pic3").val(res.id);
							$("#pic3Show").attr("src",res.url);
							$("#pic3Show").attr("style","width: 150px;height: 150px;");

						}
					});
				</script>
			</div>
			<font color="red">	600*400只能上传JPG/PNG文件。且不超过500KB</font>

		</div>
		<div class="control-group" id="videoDiv">
			<label class="control-label">课程视频：</label>
			<div class="controls">
				<c:if test="${not empty groomerCourse.videoUrl }">
					<video id="videoUrl"  src="${groomerCourse.videoUrl}" controls="controls"></video>
				</c:if>
				<video id="videoUrl2" controls="controls"></video>
				<input type="file" id="fileName">
					<script>
							 document.getElementById('fileName').addEventListener('change', function (e) {
							      let file = e.target.files[0];
							      let name = e.target.value;
								  let suffix = name.substr(name.indexOf("."))
							      let storeAs = uuid()+suffix;
								 var href = window.location.href;
								 var split = href.split("schoolsCourse");
								 var last = split[0]+"schoolsCourse/getStsToken"
							      // OSS.urlib是SDK内部封装的发送请求的逻辑，开发者可以使用任何发送请求的库向sts-server发送请求。
							      OSS.urllib.request(last, {method: 'GET'}, (err, response) => {
							          if (err) {
							            return alert(err);
							          }
							          try {
							            result = JSON.parse(response);
							          } catch (e) {
							            return alert('parse sts response info error: ' + e.message);
							          }
							          let client = new OSS({
							            accessKeyId: result.credentials.accessKeyId,
							            accessKeySecret: result.credentials.accessKeySecret,
							            stsToken: result.credentials.securityToken,
							            // region表示您申请OSS服务所在的地域，例如oss-cn-hangzhou。
							            region: 'oss-cn-qingdao',
							            bucket: 'groomer-course'
							          });
							          // storeAs可以自定义为文件名（例如file.txt）或目录（例如abc/test/file.txt）的形式，实现将文件上传至当前Bucket或Bucket下的指定目录。
							          // file可以自定义为File对象、Blob数据以及OSS Buffer。
							          client.multipartUpload(storeAs, file).then(function (result) {
										  console.log(result)
										  $("#video").val(storeAs)
										  $("#videoUrl").attr("src","");
										  $("#videoUrl").hide();
										  $("#videoUrl2").show();
										  geturl(storeAs);
									  }).catch(function (err) {
							            alert(err);
							          });
							        });
							    });
						function  geturl(storeAs) {
							$.ajax({
								type : 'GET',
								dataType:"json",
								data : {"name":storeAs},
								url:"${ctxSchools}/schoolsCourse/getVideoUrl",
								success: function(data) {
									$("#videoUrl2").attr("src",data.videoUrl);
								}
							});
						}
			</script>
				<span><a class="btn btn-success" onclick="deleteVideo('video')">删除视频</a></span>
				<form:hidden path="video" htmlEscape="false" maxlength="20" class="input-xlarge "/>
				<font color="red">视频时常5-20分钟，且不超过500M</font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程状态：</label>
			<div class="controls">
				<form:select path="states" class="input-medium required">
					<form:option value="2" label="上架状态"/>
					<form:option value="1" label="下架状态"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group"id="level2">
			<label class="control-label">课程等级：</label>
			<div class="controls">
				<form:select path="diplomaLevel" class="input-xlarge required">
					<form:option value="" label="请选择"/>
					<form:options items="${fns:getDictList('course_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程价格：</label>
			<div class="controls">
				<form:input path="price"  htmlEscape="false"  class="input-xlarge required isNumber"  placeholder="请输入金额 "/>元
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名时间：</label>
			<div class="controls">
				<input id="registrationStarteTime" name="registrationStarteTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${groomerCourse.registrationStarteTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onFocus="var endDate=$dp.$('registrationEndTime');WdatePicker({onpicked:function(){endDate.focus();},
						maxDate:'#F{$dp.$D(\'registrationEndTime\')}',dateFmt:'yyyy-MM-dd HH:mm:ss',startDate:'%y-%M-%d 00:00:00'})" placeholder="开始时间 "/>
				-<input id="registrationEndTime"  name="registrationEndTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${groomerCourse.registrationEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onFocus="WdatePicker({minDate:'#F{$dp.$D(\'registrationStarteTime\')}',dateFmt:'yyyy-MM-dd HH:mm:ss',startDate:'%y-%M-%d 23:59:59'})"  placeholder="结束时间 "/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训时间：</label>
			<div class="controls">
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${groomerCourse.startDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onFocus="var endDate=$dp.$('endDate');WdatePicker({onpicked:function(){endDate.focus();},maxDate:'#F{$dp.$D(\'endDate\')}',
					dateFmt:'yyyy-MM-dd HH:mm:ss',startDate:'%y-%M-%d 00:00:00'})"  placeholder="开始时间 "/>
				-<input id="endDate"  name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${groomerCourse.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onFocus="WdatePicker({minDate:'#F{$dp.$D(\'startDate\')}',dateFmt:'yyyy-MM-dd HH:mm:ss',startDate:'%y-%M-%d 23:59:59'})"  placeholder="结束时间 "/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程讲师：</label>
			<div class="controls">
				<form:select id="teacherId" path="teacherId" class="input-xlarge required">
					<form:options items="${teacherList}" itemLabel="teacherName" itemValue="id" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程详情：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="courseDetails" style="height:400px"   placeholder="输入内容 " />
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" onclick="submitMsg()"  value="保 存"/>&nbsp;
			<!-- 预览 -->
			<button type="button" class="btn btn-primary" id="viewButton"><i class="fa fa-eye"></i> 预览</button>
			<div id="previewbox">
				<div id="previewContent" class="preview-content" style="height:50%"></div>
				<div onclick = "previewboxClose()" class="preview-close">X</div>
			</div>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>

</body>
</html>