<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展积分榜标题管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			// 导出
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出最新积分榜吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/score/showScoreRanking/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/show/showScoreTitle/");
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/score/showScore/">犬展积分列表</a></li>
		<li class="active"><a href="${ctx}/show/showScoreTitle/">犬展积分榜</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showScoreTitle" action="${ctx}/show/showScoreTitle/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>年份：</label>
				<form:select path="year" class="input-medium required">
					<form:option value="" label="全部"/>
					<form:options items="${years}"  htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>组别：</label>
				<form:select path="ageGroup" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('cku_age_group')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>积分榜标题：</label>
				<form:input path="title" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns">
				<input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"  onclick="return page();"/>
			</li>
			<li class="btns"style="float:right">
				<button id="" class="btn btn-primary" type="button" onclick="window.location.href='${ctx}/show/showScoreTitle/form'">添加</button>
			</li>
			<li class="btns"style="float:right">
				<button id="btnExport" type="button" class="btn btn-primary" >最新积分榜下载</button>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>年份</th>
				<th>组别</th>
				<th>积分榜标题</th>
				<th>统计起始日期</th>
				<th>统计截止日期</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showScoreTitle">
			<tr>
				<td><a href="${ctx}/show/showScoreTitle/form?id=${showScoreTitle.id}">
					${showScoreTitle.year}
				</a></td>
				<td>
					${fns:getDictLabel(showScoreTitle.ageGroup, 'cku_age_group', '')}
				</td>
				<td>
					${showScoreTitle.title}
				</td>
				<td>
					<fmt:formatDate value="${showScoreTitle.startTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${showScoreTitle.endTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
    				<a href="${ctx}/show/showScoreTitle/form?id=${showScoreTitle.id}">修改</a>
					<%--<a href="${ctx}/show/showScoreTitle/delete?id=${showScoreTitle.id}" onclick="return confirmx('确认要删除该犬展积分榜标题吗？', this.href)">删除</a>--%>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>