<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
			
			//悬浮提示插件
			$(document).tooltip();
 			$("#btnRefreshRanking").click(function(){
				top.$.jBox.confirm("确认刷新cku官网积分排行榜吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						loading('正在刷新，请稍等...');
						 $.ajax({
								type: "GET",
				                dataType:"json",
				                url:"${ctx}/results/showResults/refreshRanking",
				                async: true,
				                error: function(request, textStatus, errorThrown) {
				                    alert("请求失败！");
				                    parent.isYes = true;
				                    parent.layer.closeAll();
				                },
				                success: function(data) {
				                	if(data.rc == 1){
										closeLoading();
				                	}else{
				                		 closeLoading();
				                		 alert("刷新成功！");
				                	}
				                }
							});
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
 			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/results/showResults/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/results/showResults/">犬展成绩列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showResults" action="${ctx}/results/showResults/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>秩序号：</label>
				<form:input path="orderCode" htmlEscape="false" maxlength="5" class="input-medium"/>
			</li>
			<li><label>犬主人/会员号：</label>
				<form:input path="dogOwnerNameCn" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>犬只证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬展编号：</label>
                <form:input path="showCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="results:showResults:edit">
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="成绩导入"/></li>
			<!-- <li class="btns"><input id="btnRefreshRanking" class="btn btn-primary" type="button" value="刷新排行榜"/></li>  -->
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			
				<th>归属年份</th>
				<th>秩序号</th>
				<th>评价</th>
				<th>CC</th>
				<th>CACIB</th>
				<th>BOW</th>
				<th style="text-align: center;">BOJ/<br>VBOB</th>
				<th>JBIG</th>
				<th>JBIS</th>
				<th>BOB</th>
				<th>BOV</th>
				<th>BIG</th>
				<th>BIS</th>
				<th>BBE-BIS</th>
				<th>BBE-BIG</th>
				<th>BBE-BISS</th>
				<th>BBE-WINNER</th>
				<th>OHC-BIS</th>
				<th>OHC-BIG</th>
				<th>OHC-BISS</th>
				<th>OHC-BOH</th>
				<th>本场积分</th>
				<th>单犬种积分</th>
				<th>组别积分</th>
				<th>牵犬师积分</th>
				<th>牵犬师会员</th>
				<th>OHC积分</th>
				<th>BBE积分</th>
				<th style="text-align: center;">WW/<br>APCS-CAC</th>
				<th>犬主中文名</th>
				<th>会员号</th>
				<th>犬种</th>
				<th style="width:66px">年龄组别</th>
				<th>血统证书号</th>
				<th style="width:155px">犬展编号</th>
				<th>裁判</th>
				<th>活动区域</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showResults">
			<tr>
			<td>
					${fns:escapeHtml(showResults.year)}
				</td>
				<td>
					${fns:escapeHtml(showResults.orderCode)}
				</td>
				<td>
					${fns:escapeHtml(showResults.appraisal)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultCc)} ${fns:escapeHtml(showResults.remarksCc)}
				</td>
				<td>
					${fns:getDictLabel(showResults.resultCacib, 'show_result_cacib', '')}
				</td>
				<td>
						${fns:escapeHtml(showResults.resultBow)}
				</td>
				<td style="text-align: center;">
						${fns:escapeHtml(showResults.resultBoj)}
				</td>
				<td>
						${fns:escapeHtml(showResults.resultJbig)}
				</td>
				<td>
						${fns:escapeHtml(showResults.resultJbis)}
				</td>
				<td>
					${fns:getDictLabel(showResults.resultBob, 'show_result_bob', '')}
				</td>
				<td>
						${fns:escapeHtml(showResults.resultBov)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBig)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBis)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBbeBis)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBbeBig)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBbeBiss)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultBbeWinner)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultOhcBis)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultOhcBig)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultOhcBiss)}
				</td>
				<td>
					${fns:escapeHtml(showResults.resultOhcBoh)}
				</td>
				<td>
					${fns:escapeHtml(showResults.showResult)}
				</td>
				<td>
					${fns:escapeHtml(showResults.showBreedResult)}
				</td>
				<td>
					${fns:escapeHtml(showResults.showGroupResult)}
				</td>
				<td>
					${fns:escapeHtml(showResults.qusResult)}
				</td>
				<td>
					${fns:escapeHtml(showResults.qusCode)}
				</td>
				<td>
					${fns:escapeHtml(showResults.ohcScore)}
				</td>
				<td>
					${fns:escapeHtml(showResults.bbeScore)}
				</td>
				<td style="text-align: center;">
						${fns:escapeHtml(showResults.resultApaccc)}
				</td>
				<td>
					${fns:escapeHtml(showResults.dogOwnerNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showResults.dogOwnerMemberCode)}
				</td>
				<td>
					${fns:escapeHtml(showResults.breedCnName)}
				</td>
				<td>
					${fns:getDictLabel(showResults.ageGroup, 'show_age_group', '')}
				</td>
				<td>
					${fns:escapeHtml(showResults.pedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(showResults.showCode)}
				</a></td>
				<td>
					${fns:escapeHtml(showResults.referee)}
				</td>
				<td>
					${fns:escapeHtml(showResults.raceLap)}
				</td>
				<td>
				<shiro:hasPermission name="results:showResults:view">
    				<a href="${ctx}/results/showResults/form?id=${showResults.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="results:showResults:edit">
    				<a href="${ctx}/results/showResults/editForm?id=${showResults.id}" target="_blank">编辑</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="results:showResults:delete">
					<a href="${ctx}/results/showResults/delete?id=${showResults.id}" onclick="return confirmx('确认要删除该犬展成绩吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>