<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商城订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			closeLoading();
			//$("#name").focus();
			$("#inputFormCart").validate({
				submitHandler: function(formCart){
					loading('正在提交，请稍等...');
					formCart.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#inputFormOrder").validate({
				submitHandler: function(formOrder){
//		            if($("#addAddressDiv").css("display")=="none" || $("#userAddressId").val()==""){
//		            	alert("请选择默认地址或选择新增临时地址");
//		            	return;
//		            } else {
		            	loading('正在提交，请稍等...');
		            	formOrder.submit();
//		            }
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			var nums = $(".onenum");
			var total = 0;
			for(var i=0;i<nums.length;i++){
				total = total+parseFloat(nums[i].value);
			}
			$("#totalNum").html(total);
			$("#totalNumHidden").val(total);
		});
	</script>
	<style>
		.form-group{
			margin-top: 5px;
		}
	</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/shop/shopOrder/">订单列表</a></li>
		<li class="active"><a href="${ctx}/shop/shopOrder/form">订单添加</a></li>
	</ul><br/>
	<div id="content" class="row-fluid">
		<sys:message content="${message}"/>
		<div id="left" class="accordion-group" style="width: 30%;">
			<div class="panel panel-default">
				<div class="panel-heading" style="text-align: center;background-color: #f5f5f5;padding-top: 10px;"><h2>添加商品</h2></div>
				<form:form id="inputFormCart" modelAttribute="shopCarts" action="${ctx}/shop/shopCarts/save" method="post" class="form-horizontal">
				<div class="panel-body">
					<div class="form-group">
						会员号:<input type="hidden" name="memberName" id="memberName" value="${member.name}" >
							<input type="text" class="form-control" id="memberCode" name="memberCode" value="${member.memberCode}" required title="会员号不能为空！" onblur="searchUser()">
							<button type="button" class="btn btn-default" onclick="searchUser()">查</button>
					</div>
					<div class="form-group">
						商品:<input type="hidden" name="goodsName" id="goodsName" value="${goodsItems[0].name}">
							<select name="goodsId" id="goodsId" style="width:300px;" onchange="changeGoods(this)" class="input-medium" required title="商品不能为空！">
								<option value="">请选择商品</option>
								<c:forEach items="${goodsItems}" var="item">
									<option value="${item.id}" priceStr="${item.price}" buyGifts="${item.buyGifts}" isRebate="${item.isRebate}"  isInterval="${item.isInterval}"
											interval1Num="${item.interval1Num}"  interval1Price="${item.interval1Price}"  interval2Num="${item.interval2Num}"  interval2Price="${item.interval2Price}"  interval3Price="${item.interval3Price}"
											isFreight="${item.isFreight}" limits="${item.limits}" htmlEscape="false">${item.name}</option>
								</c:forEach>
							</select><br><span id="goodsTag" style="color: red;"></span>
					</div>
					<div class="form-group">
						单价:<input type="number" name="goodsPrice" id="goodsPrice" class="form-control" required title="单价不能为空！">
					</div>
					<div class="form-group">
						数  量:<input class="btn" type="button" onclick="del()" value="-"></input><input type="number" min="0" style="width: 80px;" value="1" name="goodsNum" id="goodsNum"><input class="btn" type="button" onclick="add()"value="+"></input>
					</div>
					<div class="form-group" id="buyGiftsDiv" style="display: none;">
						赠  品:
							<select class="input-medium" style="width:280px;" id="buyGiftsGoods" name="buyGiftsGoods">
							</select>
							数量:<input type="text" style="width:30px;" readonly id="buyGiftsNum" name="buyGiftsNum" value="0"/>
					</div>
				</div>
				<div class="panel-footer"  style="padding-bottom: 5px;margin-top: 20px;">
					<div class="form-group" style="text-align: center;">
						<shiro:hasPermission name="shop:shopCarts:add">
						<input id="btnSubmit" class="btn btn-primary" type="submit" value="添 加"/>&nbsp;
						</shiro:hasPermission>
					</div>
				</div>
				</form:form>
			</div>
		</div>
		<div id="right" class="accordion-group"  style="width: 68%;">
			<form:form id="inputFormOrder" modelAttribute="shopOrder" action="${ctx}/shop/shopOrder/save" method="post">
				<div class="panel panel-default">
					<div class="panel-heading" style="text-align: center;background-color: #f5f5f5;padding-top: 10px;"><h2>待结算订单详情</h2></div>
					<div class="panel-body">
						<table id="contentTable" class="table table-striped table-bordered table-condensed" style="margin-bottom: 0px;">
							<thead>
							<tr>
								<th>会员号</th>
								<th>会员名称</th>
								<th>商品</th>
								<th>单价</th>
								<th>数量</th>
								<th>备注</th>
								<th>合计</th>
								<th>操作</th>
							</tr>
							</thead>
							<tbody>
							<c:forEach items="${cartsList}" var="itm" varStatus="status">
									<tr>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].id" value="${itm.id}">
										<input type="hidden" name="orderDetailList[${status.index}].memberCode" value="${itm.memberCode}">
											${itm.memberCode}
									</td>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].memberName" value="${itm.memberName}">
											${itm.memberName}
									</td>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].goodsId" value="${itm.goodsId}">
										<input type="hidden" name="orderDetailList[${status.index}].goodsName" value="${itm.goodsName}">
											${itm.goodsName}
									</td>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].goodsPrice" value="${itm.goodsPrice}">
											${itm.goodsPrice}
									</td>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].goodsNum" value="${itm.goodsNum}">
										<c:if test="${itm.isBuyGifts=='0'}">
										<a class="btn" onclick="delShopGoods('${itm.id}')">-</a>
										</c:if>
											${itm.goodsNum}
										<c:if test="${itm.isBuyGifts=='0'}">
										<a class="btn" onclick="addShopGoods('${itm.id}')">+</a>
										</c:if>
									</td>
									<td>
										<input type="hidden" name="orderDetailList[${status.index}].isBuyGifts" value="${itm.isBuyGifts}">
										${itm.isBuyGifts=='0'?'':'赠品'}
									</td>
									<td>
										<input type="hidden" class="onenum" name="orderDetailList[${status.index}].totalPrice" value="${itm.totalPrice}">
											${itm.totalPrice}
									</td>
									<td>
										<shiro:hasPermission name="shop:shopCarts:delete">
										<c:if test="${itm.isBuyGifts=='0'}">
											<a href="${ctx}/shop/shopCarts/delete?id=${itm.id}&memberCode=${itm.memberCode}">删除</a>
										</c:if>
										</shiro:hasPermission>
									</td>
								</tr>
							</c:forEach>
							<tr>
								<td colspan="8" style="text-align: right; font-size: 20px;color: red;">
									运费：<span id="postPrice">0</span>元　商品合计：<span id="totalNum">0</span>元<input type="hidden" id="totalNumHidden"/>
								</td>
							</tr>
							</tbody>
						</table>
					</div>
					<div class="panel-footer">
						<c:if test="${member!=null}">
							<div id="paymentShow">
								<div class="col-md-12" style="margin-top: 10px;margin-left: 20px;">
									<p>邮寄方式:
										<input type="radio" name="postType" onclick="getPostPrice('${member.memberCode}',this.value)" value="zhongtie" required title="邮寄方式不能为空！">中铁物流
										<input type="radio" name="postType" onclick="getPostPrice('${member.memberCode}',this.value)" value="sutong" required title="邮寄方式不能为空！">速通物流
										<input type="radio" name="postType" onclick="getPostPrice('${member.memberCode}',this.value)" value="yunda" required title="邮寄方式不能为空！">韵达快递
										<input type="radio" name="postType" onclick="getPostPrice('${member.memberCode}',this.value)" value="cku" required title="邮寄方式不能为空！">协会配送
										单号：<input type="text" name="postOrderNo" class="input-medium" style="margin-bottom: 0px;">
									</p>
								</div>
								<div class="col-md-12" style="margin-top: 10px;margin-left: 20px;">
									<p>默认地址：<select style="width:400px;" name="userAddressId" id="userAddressId" class="input-medium">
													<c:forEach items="${shopUserAddressList}" var="item">
														<option value="${item.id}" htmlEscape="false">${item.province}-${item.city}-${item.address},${item.postName},${item.postDel}}</option>
													</c:forEach>
												</select>
												<a onclick="updateAddress()">更改默认地址</a>
												<a onclick="showAddAddress()">新增临时地址</a>
									</p>
								</div>
								<div class="col-md-12" id="addAddressDiv" style="margin-top: 10px;margin-left: 20px;display: none;">
									<p>
										收件人:　<input type="text" id="postName" name="postName" placeholder="收件人" class="input-medium" style="margin-bottom: 0px;">　　
										联系电话:　<input type="text" id="postDel" name="postDel" placeholder="联系电话" class="input-medium" style="margin-bottom: 0px;">
									</p>
									<p>
										新增地址：
										<select name="province" id="province" onchange="changeProvince(this.value)" style="width:100px;">
										</select>
										<select name="city" id="city" onchange="selGetPostPrice('${member.memberCode}')" style="width:150px;">
										</select>
										<input type="text" id="address" name="address" placeholder="详细地址" class="input-medium" style="margin-bottom: 0px;">

										<input type="text" id="postCode" name="postCode" placeholder="邮政编码" class="input-medium" style="margin-bottom: 0px;">
										<input type="hidden" name="isNewAddress" id="isNewAddress" value="0">
									</p>
								</div>
								<div class="col-md-12" style="margin-top: 10px;margin-left: 20px;">
									<input type="hidden" name="isOrg" value="${isOrg}">
									<p>缴费方式：
														<span >
															<input type="radio" name="paymentWay" value="3" required title="缴费方式不能为空！">现金支付
														</span>
														<span >
															<input type="radio" name="paymentWay" value="25" required title="缴费方式不能为空！">账户余额
														</span>
										<c:if test="${isOrg=='0'}">
											【￥${member.accountBalance}】
										</c:if>
										<c:if test="${isOrg=='1'}">
											【￥${shopUserMoney.userMoney}】
											<span >
												<input type="radio" name="paymentWay" value="26" required title="缴费方式不能为空！">返利支付
											</span>
											【￥${shopUserMoney.rebateMoney}】
										</c:if>

									</p>
								</div>
								<div class="col-md-12" style="margin-top: 10px;margin-left: 20px;">
									<p>销售渠道：<select name="channel" class="input-medium">
													<c:forEach items="${channelList}" var="item">
														<option value="${item.id}" htmlEscape="false">${fns:getDictLabel(item.type, 'channel_type','' )}-${item.name}</option>
													</c:forEach>
												</select>
									</p>
								</div>
								<div class="col-md-12" style="margin-top: 10px;margin-left: 20px;">
									<p>备注：<textarea name="remarks" class="input-medium" cols="3" rows="2"></textarea>
									</p>
								</div>
									${fns:escapeHtml(shopOrder.remarks)}
								<shiro:hasPermission name="shop:shopOrder:add">
								<div class="col-md-12" style="text-align: center;">
									<input type="hidden" name="memberName" value="${member.name}" >
									<input type="hidden" name="memberCode" value="${member.memberCode}">
									<input class="btn btn-primary" type="submit" value="订单结算"/>
								</div>
								</shiro:hasPermission>
							</div>
						</c:if>
					</div>
				</div>
			</form:form>
		</div>
	</div>
	<script>
		var localBuyGifts = 0;
		var localLimit = null;
		var provinceList = [
			<c:forEach items="${provinceList}" var="p" varStatus="status">
				<c:choose>
					<c:when test="${status.last}">
					{"id":"${p.id}","name":"${p.name}"}
					</c:when>
					<c:otherwise>
					{"id":"${p.id}","name":"${p.name}"},
					</c:otherwise>
				</c:choose>
			</c:forEach>
		];
		var cityList = [
			<c:forEach items="${cityList}" var="c" varStatus="status">
				<c:choose>
					<c:when test="${status.last}">
					{"id":"${c.id}","name":"${c.name}","parentId":"${c.parent.id}"}
					</c:when>
					<c:otherwise>
					{"id":"${c.id}","name":"${c.name}","parentId":"${c.parent.id}"},
					</c:otherwise>
				</c:choose>

			</c:forEach>
		];
		$(function(){
			$.each(provinceList,function(index,item){
				$("#province").append("<option value=\""+item.id+"\">"+item.name+"</option>");
			});
			changeProvince(provinceList[0].id);
		})
		function changeProvince(pcode){
			$("#s2id_city a .select2-chosen").html("");
			$("#city").html("");
			$.each(cityList,function(index,item){
				if(pcode == item.parentId){
					$("#city").append("<option value=\""+item.id+"\">"+item.name+"</option>");
				}
			});
		}
		function delShopGoods(id){
			window.location.href="${ctx}/shop/shopCarts/subtractGoods?id="+id+"&memberCode="+localMemberCode;
		}
		function addShopGoods(id){
			window.location.href="${ctx}/shop/shopCarts/addGoods?id="+id+"&memberCode="+localMemberCode;
		}
		function changeGoods(obj){
			var pricestr = $("#goodsId option[value="+obj.value+"]").attr("pricestr");
			var buyGifts = $("#goodsId option[value="+obj.value+"]").attr("buyGifts");
			var isRebate = $("#goodsId option[value="+obj.value+"]").attr("isRebate");
			var isFreight = $("#goodsId option[value="+obj.value+"]").attr("isFreight");
			var limits = $("#goodsId option[value="+obj.value+"]").attr("limits");
			var isInterval = $("#goodsId option[value="+obj.value+"]").attr("isInterval");
			var interval1Num = $("#goodsId option[value="+obj.value+"]").attr("interval1Num");
			var interval1Price = $("#goodsId option[value="+obj.value+"]").attr("interval1Price");
			var interval2Num = $("#goodsId option[value="+obj.value+"]").attr("interval2Num");
			var interval2Price = $("#goodsId option[value="+obj.value+"]").attr("interval2Price");
			var interval3Price = $("#goodsId option[value="+obj.value+"]").attr("interval3Price");
			var goodsName = $("#goodsId option[value="+obj.value+"]").html();
			$("#goodsPrice").val(pricestr);
			$("#goodsName").val(goodsName);
			var tagStr = "";
			var isBuy = 0;
			if(isRebate=="0"){
				tagStr+="返利 ";
			}
			if(isFreight=="0"){
				tagStr+="免运费 ";
			}
			if(limits>0){
				localLimit = limits;
				tagStr+="限购"+limits+" ";
			}
			if(buyGifts=="1"){
				tagStr+="满5返1,满10返3 ";
				isBuy = 1;
			}else if(buyGifts=="2"){
				tagStr+="满10返2 ";
				isBuy = 1;
			}
			if(isInterval=="1"){
				if(interval1Num==interval2Num){
					tagStr+="<br>区间计费:0-"+interval1Num+"价格为"+interval1Price+","+interval2Num+"-&"+"价格为"+interval2Price;
				}else{
					tagStr+="<br>区间计费:0-"+interval1Num+"价格为"+interval1Price+","+interval1Num+"-"+interval2Num+"价格为"+interval2Price+","+interval2Num+"-&价格为"+interval3Price;
				}
				var interval1Num = $("#goodsId option[value="+obj.value+"]").attr("interval1Num");
				var interval1Price = $("#goodsId option[value="+obj.value+"]").attr("interval1Price");
				var interval2Num = $("#goodsId option[value="+obj.value+"]").attr("interval2Num");
				var interval2Price = $("#goodsId option[value="+obj.value+"]").attr("interval2Price");
				var interval3Price = $("#goodsId option[value="+obj.value+"]").attr("interval3Price");

			}
			localBuyGifts = buyGifts;
			$("#goodsNum").val(1);
			$("#buyGiftsNum").val(0);
			$("#buyGiftsDiv").css("display","none");
			$("#goodsTag").html(tagStr);
			$("#buyGiftsGoods").html("");
			//得到满赠商品
			if(isBuy==1){
				$.ajax({
					type: "POST",
					url:"${ctx}/shop/shopOrder/getLessGoodsList",
					dataType:"json",
					data:{goodsId:obj.value},
					async: false,
					error: function(request, textStatus, errorThrown) {
						alert("系统错误，请联系管理员！");
					},
					success: function(data) {
						if(data!=null && data.length>0){
							var html = "";
							$.each(data,function(index,item){
								html+="<option value=\""+item.id+"\">"+item.name+"</option>";
							});
							$("#buyGiftsGoods").html(html);
						}
					}
				});
			}
		}
		var localMemberCode="";
		//打开查询用户的弹窗
		function searchUser(){
			var memberCode = $("#memberCode").val();
			localMemberCode = memberCode;
			window.location.href="${ctx}/shop/shopOrder/form?memberCode="+memberCode;
		}
		function updateAddress(){
			var userAddressId = $("#userAddressId").val();
			var data = {id:userAddressId};
			$.ajax({
				type: "POST",
				url:"${ctx}/shop/shopUserAddress/updateAddress",
				dataType:"json",
				data:data,
				async: false,
				error: function(request, textStatus, errorThrown) {
					alert("系统错误，请联系管理员！");
				},
				success: function(data) {
					alert("修改默认地址成功！");
				}
			});
		}

		function showAddAddress(){
			if($("#addAddressDiv").css("display")=="none"){
				$("#isNewAddress").val("1");
				$("#addAddressDiv").css("display","block");
				$("#address").addClass("required");
				$("#postCode").addClass("required");
				$("#postName").addClass("required");
				$("#postDel").addClass("required");
				$("#province").addClass("required");
				$("#city").addClass("required");
			}else{
				$("#isNewAddress").val("0");
				$("#addAddressDiv").css("display","none");
			}
		}
		var localPostType = "";
		function selGetPostPrice(memberCode){
			if(localPostType==""){
				alert("请选择邮寄方式！");
			}else{
				getPostPrice(memberCode,localPostType);
			}
		}
		function getPostPrice(memberCode,val){
			localPostType = val;
			var isNewAddress = $("#isNewAddress").val();
			var city = $("#city").val();
			var userAddressId = $("#userAddressId").val();
			var data = {memberCode:memberCode,postType:val,isNewAddress:isNewAddress,city:city,userAddressId:userAddressId};
			$.ajax({
				type: "POST",
				url:"${ctx}/shop/shopOrder/getPostPrice",
				dataType:"json",
				data:data,
				async: false,
				error: function(request, textStatus, errorThrown) {
					alert("系统错误，请联系管理员！");
				},
				success: function(data) {
					console.log(data);
					$("#postPrice").html(data);
					var totalNumHidden = $("#totalNumHidden").val();
					$("#totalNum").html(parseFloat(totalNumHidden)+parseFloat(data));
				}
			});
		}
		/**
		 * 数量删除方法
		 */
		function del(){
			if(util.isVal($("#goodsId").val())==""){
				return;
			}
			var nowNum =  $("#goodsNum").val();
			var intNum = parseInt(nowNum);
			if(intNum<=1){
				$("#goodsNum").val(intNum);
				$("#buyGiftsDiv").css("display","none");
			}else{
				intNum = intNum-1;
				$("#goodsNum").val(intNum);
				if(localBuyGifts==1){
					if(intNum>=5 && intNum<10){
						$("#buyGiftsNum").val(1);
						$("#buyGiftsDiv").css("display","block");
					}else if(intNum>=10){
						var nn = 3*parseInt(intNum/10);
						var durnn = intNum - 10*parseInt(intNum/10);
						var nnn = 1*parseInt(durnn/5);
						$("#buyGiftsNum").val(nn+nnn);
						$("#buyGiftsDiv").css("display","block");
					}else{
						$("#buyGiftsDiv").css("display","none");
					}
				}else if(localBuyGifts==2){
					if(intNum>=10){
						$("#buyGiftsNum").val(2*parseInt(intNum/10));
						$("#buyGiftsDiv").css("display","block");
					}else{
						$("#buyGiftsDiv").css("display","none");
					}
				}
			}
		};
		/**
		 * 数量添加方法
		 */
		function add(){
			if(util.isVal($("#goodsId").val())==""){
				return;
			}
			var nowNum =  $("#goodsNum").val();
			if(localLimit!=null){
				if(parseInt(localLimit)==parseInt(nowNum)){
					alert("此商品限购"+localLimit+"。购买商品超出限购数量！");
					return;
				}
			}
			var intNum = parseInt(nowNum)+1;
			$("#goodsNum").val(intNum);
			if(localBuyGifts==1){
				if(intNum>=5 && intNum<10){
					$("#buyGiftsNum").val(1);
					$("#buyGiftsDiv").css("display","block");
				}else if(intNum>=10){
					if(intNum-10*parseInt(intNum/10)>=5){
						$("#buyGiftsNum").val(3*parseInt(intNum/10)+1);
					}else{
						$("#buyGiftsNum").val(3*parseInt(intNum/10));
					}
					$("#buyGiftsDiv").css("display","block");
				}else{
					$("#buyGiftsDiv").css("display","none");
				}
			}else if(localBuyGifts==2){
				if(intNum>=10){
					$("#buyGiftsNum").val(2*parseInt(intNum/10));
					$("#buyGiftsDiv").css("display","block");
				}else{
					$("#buyGiftsDiv").css("display","none");
				}
			}

		};
	</script>
</body>
</html>