<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍所有人变更管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
			parent.layer.open({
				type: 2,
				title: ['犬舍所有人变更审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['550px', '350px'],
				content: "${ctx}/kennel/kennelOwnerChange/auditForm?id="+id,
				end:function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬舍中文名</th>
				<th>犬舍英文名</th>
				<th>犬舍原主人</th>
				<th>犬舍新主人</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理</th>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="kennelOwnerChange">
			<tr>
				<td>
					${fns:escapeHtml(kennelOwnerChange.kennel.name)}
				</td>
				<td>
					${fns:escapeHtml(kennelOwnerChange.kennel.nameEn)}
				</td>
				<td title="${fns:escapeHtml(kennelOwnerChange.originOwnerMemberCode)}">
					${fns:escapeHtml(kennelOwnerChange.member1.name)}
				</td>
				<td title="${fns:escapeHtml(kennelOwnerChange.newOwnerMemberCode)}">
					${fns:escapeHtml(kennelOwnerChange.member2.name)}
				</td>
				<td>
					<fmt:formatDate value="${kennelOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${'1' eq kennelOwnerChange.paymentState}">
						<font color="red">${fns:getDictLabel(kennelOwnerChange.paymentState, 'user_payment_state', '')}</font>
					</c:if>
					<c:if test="${'2' eq kennelOwnerChange.paymentState}">
						<font color="green">${fns:getDictLabel(kennelOwnerChange.paymentState, 'user_payment_state', '')}</font>
					</c:if>
				</td>				
				<%-- <shiro:hasPermission name="kennel:kennelOwnerChange:audit"> --%>
				<td>
					<c:if test="${'0' eq kennelOwnerChange.reviewState}">
						<c:if test="${'1' eq kennelOwnerChange.paymentState}">
							<font color="red">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</font>
						</c:if>
						<c:if test="${'2' eq kennelOwnerChange.paymentState}">
							<a href="#" onclick="auditForm('${fns:escapeHtml(kennelOwnerChange.id)}')">
								<font color="red">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</font>
							</a> 
						</c:if>
					</c:if>
					<c:if test="${'1' eq kennelOwnerChange.reviewState}">
						${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}
					</c:if>
					<c:if test="${'2' eq kennelOwnerChange.reviewState}">
						<a title="${fns:escapeHtml(kennelOwnerChange.reviewRemarks)}">${fns:getDictLabel(kennelOwnerChange.reviewState, 'review_state', '')}</a>
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${'1' eq kennelOwnerChange.processState}">
							<font color="green">${fns:getDictLabel(kennelOwnerChange.processState, 'proccess_state', '')}</font>
						</c:when>
						<c:when test="${'2' eq kennelOwnerChange.paymentState and '1' eq kennelOwnerChange.reviewState and not empty  kennelOwnerChange.kennel.name}">
						 	<a href="${ctx}/kennel/kennelOwnerChange/resolve?id=${kennelOwnerChange.id}" onclick="return confirmx('确认要处理该犬舍所有人变更吗？', this.href)">
								<font color="red">处理</font>
							</a> 
						</c:when>
					</c:choose>
				</td>
<!-- 				<td>
					<a href="#" onclick="window.print()">打印</a>
				</td>
				<td>
					<a href="#" onclick="window.print()">打印</a>
				</td> -->
				<%-- </shiro:hasPermission> --%>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>