<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>积分榜牵犬师管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/showHandler/">积分榜牵犬师列表</a></li>
		<shiro:hasPermission name="handler:showHandler:edit"><li><a href="${ctx}/handler/showHandler/form">积分榜牵犬师添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="showHandler" action="${ctx}/handler/showHandler/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>牵犬师姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>牵犬师姓名</th>
				<th>会员号</th>
				<th>照片</th>
				<th   style="width: 350px;">简介</th>
				<th>更新时间</th>
				<shiro:hasPermission name="handler:showHandler:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showHandler">
			<tr>
				<td>
					<a href="${ctx}/handler/showHandler/form?id=${showHandler.id}">
						${showHandler.name}
					</a>
				</td>
				<td>
					${showHandler.memberCode}
				</td>
				<td>
					<c:if test="${not empty showHandler.photo and showHandler.photo!=''}">
						<img src="${showHandler.photo}" style="height: 100px;width: 100px;">
					</c:if>
				</td>
				<td>
					${showHandler.introduce}
				</td>
				<td>
					<fmt:formatDate value="${showHandler.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<shiro:hasPermission name="handler:showHandler:edit"><td>
    				<a href="${ctx}/handler/showHandler/form?id=${showHandler.id}">修改</a>
					<a href="${ctx}/handler/showHandler/delete?id=${showHandler.id}" onclick="return confirmx('确认要删除该积分榜牵犬师吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>