<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>国际美容师管理管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/groomer/internationalGroomerCertificate/">国际宠物美容师列表</a></li>
		<li class="active"><a href="${ctx}/groomer/internationalGroomerCertificate/form?id=${internationalGroomerCertificate.id}">国际宠物美容师查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="internationalGroomerCertificate" action="${ctx}/groomer/internationalGroomerCertificate/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
		<h3>会员基本信息</h3>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				${internationalGroomerCertificate.certificateCode}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书类型：</label>
			<div class="controls">
				${fns:getDictLabel(internationalGroomerCertificate.certificateType, 'groomer_certificate_type', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${internationalGroomerCertificate.memberCode}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">中文名：</label>
			<div class="controls">
				${internationalGroomerCertificate.cnName}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<fmt:formatDate value="${internationalGroomerCertificate.issueDate}" pattern="yyyy-MM-dd "/>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>其他信息</h3>
		<div class="control-group">
			<label class="control-label">缴费状态：</label>
			<div class="controls">
				${fns:getDictLabel(internationalGroomerCertificate.paymentState, 'user_payment_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">流水号：</label>
			<div class="controls">
				${internationalGroomerCertificate.runningNumber}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费时间：</label>
			<div class="controls">
				<fmt:formatDate value="${internationalGroomerCertificate.paymentTime}" pattern="yyyy-MM-dd "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				${fns:getDictLabel(internationalGroomerCertificate.reviewState, 'review_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核人：</label>
			<div class="controls">
				${internationalGroomerCertificate.reviewer}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核时间：</label>
			<div class="controls">
				<fmt:formatDate value="${internationalGroomerCertificate.reviewTime}" pattern="yyyy-MM-dd "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">打印状态：</label>
			<div class="controls">
				${fns:getDictLabel(internationalGroomerCertificate.printState, 'print_state', '')}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>