<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>国外美容考试结果管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		function importFile(){
			parent.layer.open({
				type: 2,
				title: ['结果导入', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '300px'],
				content: "${ctx}/groomer/groomerForeignRegister/import/form"
			});
			return false;
		}
		
		function importFileCallback(data){
			window.location.reload();
		}
		
		// 全选/取消全选
		var checkFlag = false;
		function allCheck() {
			if (!checkFlag) {
				checkFlag = true;
				$(".checkedId").each(function () {
					$(this).attr("checked", checkFlag);
				});
			} else {
				checkFlag = false;
				$(".checkedId").each(function () {
					$(this).attr("checked", checkFlag);
				});
			}
		}
		function batchDelete(){
			let ids = "";
			$(".checkedId:checked").each(function () {
				ids += $(this).attr("value") + ',';
			});
			if (ids == '') {
				layer.msg("请至少选择一个记录");
				return false;
			}
			let arr = [];
			$(ids.split(",")).each(function (i, val) {
				arr.push({id:val});
			})
			top.$.jBox.confirm("确认要批量删除吗？","批量删除",function(v,h,f){
				if(v=="ok"){
					$.ajax({
						type: "POST",
						url:"${ctx}/groomer/groomerForeignRegister/batchDelete",
						contentType:"application/json",
						dataType:"json",
						data: JSON.stringify(arr),
						async: true,
						error: function(request, textStatus, errorThrown) {
							if(request.status=='403'&&errorThrown=='Forbidden'){
								alert("服务器拒绝您的访问，请查看是否存在此功能操作权限！");
							} else {
								alert("错误代码："+request.status+"，错误描述："+errorThrown);
							}
						},
						success: function (data) {
							if (data.rc == 0) {
								layer.msg("删除成功！");
								window.location.reload();
							} else {
								layer.msg("错误代码：" + data.rc + "错误信息：" + data.msg);
							}
						}
					});
				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerForeignRegister/">国外美容考试结果列表</a></li>
		<%-- <shiro:hasPermission name="groomer:groomerForeignRegister:edit"><li><a href="${ctx}/groomer/groomerForeignRegister/form">国外美容考试结果添加</a></li></shiro:hasPermission> --%>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerForeignRegister" action="${ctx}/groomer/groomerForeignRegister/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li>
				<label>编号：</label>
				<form:input path="registerNo" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li>
				<label>姓名：</label>
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>犬种：</label>
				<form:input path="breed" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>结果：</label>
				<form:input path="result" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>级别：</label>
				<form:input path="level" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>分类：</label>
				<form:input path="category" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li>
				<label>月份：</label>
				<input name="specificDate" type="text" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${groomerForeignRegister.specificDate}" pattern="yyyy-MM"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM',isShowClear:true});"/>
			</li>
			<li>
				<label>国家：</label>
				<form:select path="country" class="input-medium" style="width: 178px;">
					<form:option value="">全部</form:option>
					<form:options items="${fns:getDictList('country_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="groomer:groomerForeignRegister:edit">
				<li class="btns"><input onclick="importFile();" class="btn btn-primary" type="button" value="导入"/></li>
				<li class="btns"><input onclick="batchDelete();" class="btn btn-warning" type="button" value="批量删除"/></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a id="allCheck" href="#" onclick="allCheck()"><input type="checkbox"/></a></th>
				<th>国家</th>
				<th>月份</th>
				<th>编号</th>
				<th>名称</th>
				<th>犬种</th>
				<th>结果</th>
				<th>级别</th>
				<th>组别</th>
				<th>证书号</th>
				<shiro:hasPermission name="groomer:groomerForeignRegister:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="record">
			<tr>
				<td>
					<input type="checkbox" class="checkedId" value="${record.id}"/>
				</td>
				<td>
					${fns:getDictLabel(record.country,'country_type','-')}
				</td>
				<td>
					<fmt:formatDate value="${record.specificDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${record.registerNo}
				</td>
				<td>
					${record.name}
				</td>
				<td>
					${record.breed}
				</td>
				<td>
					${record.result}
				</td>
				<td>
					${record.level}
				</td>
				<td>
					${record.category}
				</td>
				<td>
					${record.certifiedNo}
				</td>
				<shiro:hasPermission name="groomer:groomerForeignRegister:edit"><td>
    				<a href="${ctx}/groomer/groomerForeignRegister/form?id=${record.id}">修改</a>
					<a href="${ctx}/groomer/groomerForeignRegister/delete?id=${record.id}" onclick="return confirmx('确认要删除该国外美容考试结果吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>