<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>采样包补寄信息管理</title>
    <meta name="decorator" content="default"/>
    <style>
	    .jbox-body .jbox-icon {
			top: 50px !important;
		}
    </style>
    <script type="text/javascript">
        function loadFun(btnId){
    		top.layer.load();
    		if(!btnId){
    			$("#"+btnId).prop("disabled",true);	
    		}
    	}
    	function closeLoadFun(btnId){
    		top.layer.closeAll('loading');
    		if(!btnId){
    			$("#"+btnId).prop("disabled",false);
    		}
    	}
/*         function orderDelete(reissueSamplingId){
        	$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					loadFun();
	    			$.ajax({
	    				type : "GET",
	    				url : "${ctx}/dogDnaArchive/dogDnaArchiveReissueSampling/orderDelete?id=" + reissueSamplingId,
	    				dataType: 'JSON',
	    				success : function(result) {
	    					closeLoadFun();
	    					if (result.rc == 0) {
	    						window.reload();
	    					} else {
	    						layer.msg(result.msg);
	    					}
	    				},
	    				error: function (res) {
	    					closeLoadFun();
	    					layer.msg("操作失败!");
	    				}
	    			});
				}
			},{buttonsFocus:1});
	    }
 */	    
        function orderView(reissueSamplingId){
			top.layer.open({
				type: 2,
				title: ['订单查看', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['750px', '750px'],
				content: ctx+"/dogDnaArchive/dogDnaArchiveReissueSampling/orderView?id="+reissueSamplingId,
				end: function(){
				}
			});
		}
    </script>
</head>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>血统证书编号</th>
		<th>国外血统证书号</th>
		<th>犬主</th>
		<th>出生纸编号</th>
		<th>申请日期</th>
		<th>采样包编号</th>
		<th>原采样包编号</th>
		<th>订单状态</th>
		<th>操作</th>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${reissueSamplingList}" var="reissueSampling">
		<tr>
			<td>
					${fns:escapeHtml(reissueSampling.dogDnaArchive.pedigreeCertifiedCode)}
			</td>
			<td>
					${fns:escapeHtml(reissueSampling.dogDnaArchive.overseasPedigreeCertified)}
			</td>
			<td title="${fns:escapeHtml(reissueSampling.dogDnaArchive.paymentMemberCode)}">
					${fns:escapeHtml(reissueSampling.dogDnaArchive.memberName)}
			</td>
			<td>
					${fns:escapeHtml(reissueSampling.dogDnaArchive.birthCode)}
			</td>
			<td>
				<fmt:formatDate value="${reissueSampling.dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			<td>
					${fns:escapeHtml(reissueSampling.samplingCode)}
			</td>
			<td>
					${fns:escapeHtml(reissueSampling.oldSamplingCode)}
			</td>
			<td style="color:${reissueSampling.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(reissueSampling.paymentState, 'user_payment_state', '')}
			</td>
			<td>
				<a href="javascript:orderView('${reissueSampling.id}');">查看</a>
				<%-- <shiro:hasPermission name="dnaarchive:dogDnaArchive:delete">
					<a href="javascript:orderDelete('${reissueSampling.id}');">删除</a>
				</shiro:hasPermission> --%>
			</td>
		</tr>
	</c:forEach>
	</tbody>
</table>
</body>
</html>