<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只DNA存档管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">

		$(document).ready(function(){
			closeLoadFun();
		});

		function loadFun(btnId){
			top.layer.load();
			if(!btnId){
				$("#"+btnId).prop("disabled",true);
			}
		}
		function closeLoadFun(btnId){
			top.layer.closeAll('loading');
			if(!btnId){
				$("#"+btnId).prop("disabled",false);
			}
		}
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
 			parent.layer.open({
				type: 2,
				title: ['DNA存档审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: ctx+"/dnaarchive/dogDnaArchive/auditForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}

		function resolveForm(id){
			parent.layer.open({
				type: 2,
				title: ['DNA登记编号 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '550px'],
				content: ctx+"/dnaarchive/dogDnaArchive/resolveForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		function DNAList(dogId){
			parent.layer.open({
				type: 2,
				title: ['DNA信息列表', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['900px', '600px'],
				content: ctx+"/dna/dogDna/list?dogId="+dogId,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		function editApplyChannel(param){
			top.$.jBox.confirm(getApplyChangeTipHtml(param),"系统提示",function(v,h,f){
				if(v=="ok"){
					loadFun();
					$.ajax({
						type : "GET",
						dataType : 'json',
						timeout: 30000,
						url : "${ctx}/dnaarchive/dogDnaArchive/editApplyChannel?id=" + param.id,
						success : function(result) {
							if (result.rc == 0) {
								layer.msg("修改成功，页面正在刷新，请稍后...");
								window.location.reload();
							} else {
								closeLoadFun();
								layer.msg(result.msg);
							}
						},
						error: function (res) {
							closeLoadFun();
							layer.msg("操作失败!");
						}
					});
				}
			},{buttonsFocus:1});
			top.$('.jbox-body .jbox-icon').css('top','55px');
		}

		function bindForm(id) {
			parent.layer.open({
				type: 2,
				title: ['采样包绑定 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['600px', '550px'],
				content: ctx + "/dnaarchive/dogDnaArchive/bindForm?id=" + id,
				end: function () {
					if (parent.isYes) {
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		function reissueForm(id) {
			parent.isYes = false;
			parent.layer.open({
				type: 2,
				title: ['采样包补寄 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '600px'],
				content: ctx + "/dnaarchive/dogDnaArchive/reissueForm?id=" + id,
				end: function () {
					if (parent.isYes) {
						layer.load();
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}
		function rebindForm(id) {
			parent.layer.open({
				type: 2,
				title: ['采样包换绑 ', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '600px'],
				content: ctx + "/dnaarchive/dogDnaArchive/rebindForm?id=" + id,
				end: function () {
					if (parent.isYes) {
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					}
				}
			});
		}

		function getApplyChangeTipHtml(param){
			var info = '';
			info += '确认要修改办理方式为自检吗？<br/><br/>';
			info += '办理机构：'+param.organizationName+'<br/>';
			info += '血统证书号：'+param.pedigreeCertifiedCode+'<br/>';
			info += '国外证书号：'+param.overseasPedigreeCertified+'<br/>';
			info += '出生纸编号：'+param.birthCode+'<br/>';
			info += '犬主人：'+param.memberName+'<br/>';
			info += '申请日期：'+param.createDate+'<br/><br/>';
			return info;
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dnaarchive/dogDnaArchive/">DNA存档管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogDnaArchive" action="${ctx}/dnaarchive/dogDnaArchive/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>国外血统证书号：</label>
				<form:input path="overseasPedigreeCertifiedLike" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>DNA编号：</label>
				<form:input path="dnaCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>出生纸编号：</label>
				<form:input path="birthCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>办理结构：</label>
				<form:input path="organizationName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>撤销状态：</label>
				<form:select path="isCanceled" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="未撤销"/>
					<form:option value="1" label="已撤销"/>
					<%--<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>--%>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
				<li><label>完成时间：</label>
				<input name="beginFinishDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.beginFinishDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endFinishDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogDnaArchive.endFinishDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>采样包编号：</label>
				<form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>办理方式：</label>
				<form:select path="applyChannel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dna_apply_channel')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书编号</th>
				<th>国外血统证书号</th>
				<th>犬主人</th>
				<th>出生纸编号</th>
				<th>办理方式</th>
				<th>办理机构</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>完成时间</th>
				<th>审核状态</th>
				<th>撤销状态</th>
				<th>采样包信息</th>
				<th>DNA信息</th>
				<th>采集方式</th>
				<th>操作</th>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogDnaArchive">
			<tr>
				<td>
					${fns:escapeHtml(dogDnaArchive.pedigreeCertifiedCode)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.overseasPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogDnaArchive.paymentMemberCode)}">
					${fns:escapeHtml(dogDnaArchive.memberName)}
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.birthCode)}
				</td>
				<td>
					<c:choose>
					    <c:when test="${dogDnaArchive.applyChannel eq 0 and dogDnaArchive.isOEC=='1' and empty dogDnaArchive.samplingCode}">
					   		<shiro:hasPermission name="dnaarchive:dogDnaArchive:edit">
						    	<a href="javascript:editApplyChannel({'id':'${dogDnaArchive.id}','organizationName':'${dogDnaArchive.organizationName}','pedigreeCertifiedCode':'${dogDnaArchive.pedigreeCertifiedCode}','overseasPedigreeCertified':'${dogDnaArchive.overseasPedigreeCertified}','birthCode':'${dogDnaArchive.birthCode}','memberName':'${dogDnaArchive.memberName}','createDate':'<fmt:formatDate value="${dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss" />'});">
							</shiro:hasPermission>
								${fns:getDictLabel(dogDnaArchive.applyChannel, 'dna_apply_channel', '')}
							<shiro:hasPermission name="dnaarchive:dogDnaArchive:edit">
								</a>
							</shiro:hasPermission>
					    </c:when>
					    <c:otherwise>${fns:getDictLabel(dogDnaArchive.applyChannel, 'dna_apply_channel','')}</c:otherwise>
					</c:choose>
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.organizationName)}
				</td>
				<td>
					<fmt:formatDate value="${dogDnaArchive.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td style="color:${dogDnaArchive.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogDnaArchive.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<fmt:formatDate value="${dogDnaArchive.finishTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td title="${fns:escapeHtml(dogDnaArchive.reviewRemarks)}" style="color:#000">
					<c:if test="${dogDnaArchive.paymentState=='2' }">
						<c:choose>
							<c:when test="${(dogDnaArchive.reviewState=='0'|| dogDnaArchive.reviewState=='2' ) && !dogDnaArchive.businessRefundState && dogDnaArchive.isCanceled=='0'}">
								<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogDnaArchive.id)}')">
								${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
								</a>
							</c:when>
							<c:otherwise>
								${fns:getDictLabel(dogDnaArchive.reviewState, 'review_state', '')}
							</c:otherwise>
						</c:choose>
					</c:if>
				</td>
				<td>
					<c:if test="${dogDnaArchive.isCanceled=='0'}">
						未撤销
					</c:if>
					<c:if test="${dogDnaArchive.isCanceled=='1'}">
						已撤销
					</c:if>
				</td>
				<td>
					${fns:escapeHtml(dogDnaArchive.samplingCode)}
					<c:if test="${dogDnaArchive.isOEC=='1' and dogDnaArchive.paymentState == '2' and  dogDnaArchive.isCanceled!='1' && !dogDnaArchive.businessRefundState}">
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:bind">
							<c:if test="${dogDnaArchive.samplingCode == null and dogDnaArchive.dnaCode == null}">
								<a href="#" onclick="bindForm('${dogDnaArchive.id}')">绑定</a>
							</c:if>
						</shiro:hasPermission>
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:reissue">
							<c:if test="${not empty dogDnaArchive.samplingCode && empty dogDnaArchive.dnaCode}">
								<a href="#" onclick="reissueForm('${dogDnaArchive.id}')">补寄</a>
							</c:if>
						</shiro:hasPermission>
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:rebind">
							<c:if test="${dogDnaArchive.samplingCode != null
										and dogDnaArchive.paymentState == '2'
										and dogDnaArchive.applyChannel == '0'
										and dogDnaArchive.dnaCode == null
										and dogDnaArchive.samplingFlowState < 2}">
								<a href="#" onclick="rebindForm('${dogDnaArchive.id}')">换绑</a>
							</c:if>
						</shiro:hasPermission>
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:unbind">
							<c:if test="${dogDnaArchive.samplingCode != null and dogDnaArchive.paymentState == '2'}">
								<c:if test="${dogDnaArchive.samplingFlowState < 2}">
									<a href="${ctx}/dnaarchive/dogDnaArchive/unbind?id=${dogDnaArchive.id}"
									   onclick="return confirmx('该采样包状态为<font color=green>'
											   +'${fns:getDictLabel(dogDnaArchive.samplingFlowState, "sampling_flow_state", '')}'
											   +'</font><br>确认要解绑该采样包吗？', this.href)">
										解绑
									</a>
								</c:if>
								<c:if test="${dogDnaArchive.samplingFlowState >= 2}">
									<a href="${ctx}/dnaarchive/dogDnaArchive/unbind?id=${dogDnaArchive.id}"
									   onclick="return confirmx('该采样包状态为<font color=red>'
											   +'${fns:getDictLabel(dogDnaArchive.samplingFlowState, "sampling_flow_state", '')}'
											   +'</font><br>确认要解绑该采样包吗？', this.href)">
										解绑
									</a>
								</c:if>
							</c:if>
						</shiro:hasPermission>
					</c:if>
				</td>
				<td>
				<c:if test="${ !dogDnaArchive.businessRefundState }">
					<c:choose>
						<c:when test="${not empty dogDnaArchive.dnaCode}">
							<a onclick="resolveForm('${dogDnaArchive.id}')">${fns:escapeHtml(dogDnaArchive.dnaCode)}</a>
							<c:if test="${not empty dogDnaArchive.dogId}">
								<a onclick="DNAList('${dogDnaArchive.dogId}')">列表</a>
							</c:if>
						</c:when>
						<c:when test="${empty dogDnaArchive.dnaCode&&dogDnaArchive.reviewState=='1'}">
							<a style="color:#F00" onclick="resolveForm('${dogDnaArchive.id}')">录入</a>
						</c:when>
					</c:choose>
			     </c:if>
				</td>
				<td>
					<c:if test="${dogDnaArchive.isOEC=='1'}">
						唾液
					</c:if>
					<c:if test="${dogDnaArchive.isOEC=='0'}">
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:blood2OEC">
							<a href="${ctx}/dnaarchive/dogDnaArchive/blood2OEC?id=${dogDnaArchive.id}" onclick="return confirmx('确认要修改DNA采集方式为唾液吗？', this.href)">
						</shiro:hasPermission>
						血样
						<shiro:hasPermission name="dnaarchive:dogDnaArchive:blood2OEC">
							</a>
						</shiro:hasPermission>
					</c:if>
				</td>
				<td>
					<a href="${ctx}/dnaarchive/dogDnaArchive/form?id=${dogDnaArchive.id}">查看</a>
					<c:if test="${ !dogDnaArchive.businessRefundState }">
							<shiro:hasPermission name="dnaarchive:dogDnaArchive:edit">
								<a href="${ctx}/dnaarchive/dogDnaArchive/editForm?id=${dogDnaArchive.id}">编辑</a>
							</shiro:hasPermission>
	
							<c:if test="${dogDnaArchive.paymentState=='2' && dogDnaArchive.isCanceled!='1' && (dogDnaArchive.samplingCode == null||dogDnaArchive.samplingCode == '')}">
								<a href="${ctx}/dnaarchive/dogDnaArchive/cancel?id=${dogDnaArchive.id}" onclick="return confirmx('确认要撤销该犬只DNA存档吗？', this.href)">撤销</a>
							</c:if>
	
							<shiro:hasPermission name="dnaarchive:dogDnaArchive:delete">
								<c:if test="${dogDnaArchive.isCanceled=='0'}">
									<a href="${ctx}/dnaarchive/dogDnaArchive/delete?id=${dogDnaArchive.id}" onclick="return confirmx('确认要删除该犬只DNA存档吗？', this.href)">删除</a>
								</c:if>
							</shiro:hasPermission>
					</c:if>
				</td>
				<td>
					<shiro:hasPermission name="dnaarchive:dogDnaArchive:print">
					<c:if test="${not empty dogDnaArchive.dnaCode && dogDnaArchive.printState=='0'}">
						<a href="${ctx}/dnaarchive/dogDnaArchive/print?id=${dogDnaArchive.id}" >打印</a>
					</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="dnaarchive:dogDnaArchive:resetPrint">
					<c:if test="${not empty dogDnaArchive.dnaCode && dogDnaArchive.printState=='1'}">
						<a href="${ctx}/dnaarchive/dogDnaArchive/resetPrint?id=${dogDnaArchive.id}" >重置打印</a>
					</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>