package com.cku.restful.v1.show.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.service.FileService;
import com.cku.restful.v1.show.service.CkuShowJudgeService;
import com.cku.util.ServletUtils;

/**
 * 赛事裁判查询接口(此类访问不需要登录,如添加请修改拦截器设置)
 *user chaixueteng
 *2017年3月15日
 */
@Controller
@RequestMapping(value = "/cku/v1/shows/showJudge")
public class CkuShowJudgeController {
	
	@Autowired
	private CkuShowJudgeService ckuShowJudgeService;
	@Autowired
	private FileService fileService;
	/**
	 * 
	 * @Description：按赛事的id获取裁判信息(CKU官网使用)
	 * @author: 柴雪腾
	 * @version: 2017-03-15
	 */
	@RequestMapping(value = "/getShowJudge",method = RequestMethod.GET)
	@ResponseBody
	public void getShowJudge(HttpServletRequest request, HttpServletResponse response) throws IOException{
		String id = request.getParameter("id");//裁判id
		RESTResponse result = ckuShowJudgeService.getShowJudge(id);
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 根据图片id 查看图片
	 * @Author chaixueteng
	 * @2017年3月17日下午3:16:06
	 */
	@RequestMapping(value="judgePicture/{id}")
	@ResponseBody
	public void image(@PathVariable String id,HttpServletResponse response) throws IOException{
		response.setContentType("application/octet-stream");
		fileService.fileDownload(id,response.getOutputStream());
	}
}
